/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.e2e.api.schema;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.netbeans.modules.e2e.api.schema.Element;
import org.netbeans.modules.e2e.api.schema.SchemaConstruct;
import org.netbeans.modules.e2e.api.schema.SchemaHolder;
import org.netbeans.modules.e2e.api.schema.Type;
import org.netbeans.modules.e2e.api.schema.TypeMapping;

public class TypeMappingRegistry {
    private SchemaHolder schemaHolder;
    private Map<QName, TypeMapping> mappings;

    public TypeMappingRegistry(SchemaHolder schemaHolder) {
        this.schemaHolder = schemaHolder;
        this.mappings = new HashMap<QName, TypeMapping>();
        for (Element element : schemaHolder.getSchemaElements()) {
            this.mapType(element);
        }
    }

    public TypeMapping getType(QName qName) {
        return this.mappings.get(qName);
    }

    private void mapType(Element element) {
        Type type = element.getType();
        if (3 == type.getFlavor()) {
            this.mappings.put(element.getName(), new TypeMappingImpl(type, element.getMaxOccurs() > 1, element.isNillable()));
        } else if (1 == type.getFlavor()) {
            SchemaConstruct schemaConstruct;
            if (type.getSubconstructs().size() == 0) {
                System.err.print("void");
            } else if (type.getSubconstructs().size() == 1 && SchemaConstruct.ConstructType.ELEMENT == (schemaConstruct = type.getSubconstructs().get(0)).getConstructType()) {
                Element element2 = (Element)schemaConstruct;
                if (3 == element2.getType().getFlavor()) {
                    System.err.print(element2.getType().getJavaTypeName());
                } else {
                    System.err.print(element2.getName().getLocalPart());
                }
            }
        }
    }

    private static final class TypeMappingImpl
    implements TypeMapping {
        private String name;
        private boolean array;
        private boolean primitive;
        private boolean nillable;
        private Type type;

        public TypeMappingImpl(Type type, boolean bl, boolean bl2) {
            this.type = type;
            this.array = bl;
            this.nillable = bl2;
        }
    }
}

