/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.preprocessor;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CompletionSupport;
import org.netbeans.modules.cnd.completion.preprocessor.CsmPreprocessorDirectiveCompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmPreprocessorDirectiveCompletionProvider
implements CompletionProvider {
    private static final boolean TRACE = Boolean.getBoolean("cnd.completion.preproc.trace");
    private static final String[] keywords = new String[]{"define", "elif", "else", "endif", "error", "ident", "if", "ifdef", "ifndef", "include", "include_next", "line", "pragma", "undef", "warning", "#if\n#endif", "#if\n#else\n#endif", "#ifdef\n#endif", "#ifdef\n#else\n#endif", "#ifndef\n#endif", "#ifndef\n#else\n#endif"};

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        CompletionSupport completionSupport;
        if (TRACE) {
            System.err.println("typed text " + string);
        }
        if ((completionSupport = CompletionSupport.get(jTextComponent)) == null) {
            return 0;
        }
        int n = jTextComponent.getCaretPosition();
        if (CompletionSupport.isPreprocessorDirectiveCompletionEnabled(jTextComponent.getDocument(), n)) {
            if (TRACE) {
                System.err.println("preprocessor completion will be shown on " + n);
            }
            return 1;
        }
        if (TRACE) {
            System.err.println("preprocessor completion will NOT be shown on " + n);
        }
        return 0;
    }

    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        if (TRACE) {
            System.err.println("queryType = " + n);
        }
        if ((n & 1) != 0) {
            int n2 = jTextComponent.getCaret().getDot();
            if (CompletionSupport.isPreprocessorDirectiveCompletionEnabled(jTextComponent.getDocument(), n2)) {
                if (TRACE) {
                    System.err.println("preprocessor completion task is created with offset " + n2);
                }
                return new AsyncCompletionTask((AsyncCompletionQuery)new Query(n2), jTextComponent);
            }
            if (TRACE) {
                System.err.println("preprocessor completion task is NOT created on " + n2);
            }
        }
        return null;
    }

    static Collection<CsmPreprocessorDirectiveCompletionItem> getFilteredData(BaseDocument baseDocument, int n, int n2) {
        Query query = new Query(n);
        Collection collection = query.getItems(baseDocument, n);
        if (TRACE) {
            System.err.println("Completion Items " + collection.size());
            for (CsmPreprocessorDirectiveCompletionItem csmPreprocessorDirectiveCompletionItem : collection) {
                System.err.println(csmPreprocessorDirectiveCompletionItem.toString());
            }
        }
        return collection;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Query
    extends AsyncCompletionQuery {
        private Collection<CsmPreprocessorDirectiveCompletionItem> results;
        private int creationCaretOffset;
        private int resultSetAnchorOffset;
        private int queryAnchorOffset;
        private String filterPrefix;

        Query(int n) {
            this.creationCaretOffset = n;
            this.queryAnchorOffset = -1;
            this.resultSetAnchorOffset = this.creationCaretOffset;
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            if (TRACE) {
                System.err.println("query on " + n + " anchor " + this.queryAnchorOffset);
            }
            Collection<CsmPreprocessorDirectiveCompletionItem> collection = this.getItems((BaseDocument)document, n);
            if (this.queryAnchorOffset > 0) {
                if (collection != null && collection.size() > 0) {
                    this.results = collection;
                    collection = this.getFilteredData(collection, this.filterPrefix);
                    completionResultSet.estimateItems(collection.size(), -1);
                    completionResultSet.addAllItems(collection);
                    completionResultSet.setAnchorOffset(this.resultSetAnchorOffset);
                }
                completionResultSet.setHasAdditionalItems(false);
            }
            completionResultSet.finish();
        }

        protected boolean canFilter(JTextComponent jTextComponent) {
            int n = jTextComponent.getCaretPosition();
            if (TRACE) {
                System.err.println("canFilter on " + n + " anchor " + this.queryAnchorOffset);
            }
            this.filterPrefix = null;
            if (this.queryAnchorOffset > -1 && n >= this.queryAnchorOffset) {
                Document document = jTextComponent.getDocument();
                try {
                    this.filterPrefix = document.getText(this.queryAnchorOffset, n - this.queryAnchorOffset);
                }
                catch (BadLocationException badLocationException) {
                    Completion.get().hideCompletion();
                }
            } else {
                Completion.get().hideCompletion();
            }
            return this.filterPrefix != null;
        }

        protected void filter(CompletionResultSet completionResultSet) {
            if (this.filterPrefix != null && this.results != null) {
                completionResultSet.setAnchorOffset(this.resultSetAnchorOffset);
                Collection<CsmPreprocessorDirectiveCompletionItem> collection = this.getFilteredData(this.results, this.filterPrefix);
                completionResultSet.estimateItems(collection.size(), -1);
                completionResultSet.addAllItems(collection);
            }
            completionResultSet.setHasAdditionalItems(false);
            completionResultSet.finish();
        }

        private Collection<CsmPreprocessorDirectiveCompletionItem> getItems(BaseDocument baseDocument, int n) {
            ArrayList<CsmPreprocessorDirectiveCompletionItem> arrayList = new ArrayList<CsmPreprocessorDirectiveCompletionItem>();
            try {
                if (this.init(baseDocument, n)) {
                    for (String string : keywords) {
                        arrayList.add(CsmPreprocessorDirectiveCompletionItem.createItem(this.queryAnchorOffset, n, string));
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean init(BaseDocument baseDocument, int n) throws BadLocationException {
            this.resultSetAnchorOffset = n;
            this.filterPrefix = "";
            this.queryAnchorOffset = -1;
            if (CompletionSupport.isPreprocessorDirectiveCompletionEnabled((Document)baseDocument, n)) {
                baseDocument.readLock();
                try {
                    TokenSequence tokenSequence = CndLexerUtilities.getCppTokenSequence((Document)baseDocument, (int)n, (boolean)true, (boolean)true);
                    if (tokenSequence == null || tokenSequence.token() == null) {
                        boolean bl = false;
                        return bl;
                    }
                    switch ((CppTokenId)tokenSequence.token().id()) {
                        case WHITESPACE: 
                        case PREPROCESSOR_START: {
                            this.queryAnchorOffset = n;
                            break;
                        }
                        default: {
                            this.queryAnchorOffset = tokenSequence.offset();
                        }
                    }
                    this.filterPrefix = baseDocument.getText(this.queryAnchorOffset, n - this.queryAnchorOffset);
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    baseDocument.readUnlock();
                }
            }
            if (TRACE) {
                System.err.println(" anchorOffset=" + this.queryAnchorOffset + " filterPrefix=" + this.filterPrefix);
            }
            return this.queryAnchorOffset >= 0;
        }

        private Collection<CsmPreprocessorDirectiveCompletionItem> getFilteredData(Collection<CsmPreprocessorDirectiveCompletionItem> collection, String string) {
            Collection<CsmPreprocessorDirectiveCompletionItem> collection2;
            if (string == null) {
                collection2 = collection;
            } else {
                ArrayList<CsmPreprocessorDirectiveCompletionItem> arrayList = new ArrayList<CsmPreprocessorDirectiveCompletionItem>(collection.size());
                for (CsmPreprocessorDirectiveCompletionItem csmPreprocessorDirectiveCompletionItem : collection) {
                    if (!this.matchPrefix(csmPreprocessorDirectiveCompletionItem, string)) continue;
                    arrayList.add(csmPreprocessorDirectiveCompletionItem);
                }
                collection2 = arrayList;
            }
            return collection2;
        }

        private boolean matchPrefix(CsmPreprocessorDirectiveCompletionItem csmPreprocessorDirectiveCompletionItem, String string) {
            return csmPreprocessorDirectiveCompletionItem.getItemText().startsWith(string);
        }
    }
}

