/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.completion.cplusplus.CsmFinderFactory;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletion;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmFinder;
import org.netbeans.modules.cnd.completion.csm.CompletionUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompletionSupport
implements DocumentListener {
    private final Reference<Document> docRef;
    private static int NOT_INITIALIZED = -1;
    private int lastSeparatorOffset = -1;
    private int contextOffset = NOT_INITIALIZED;

    private CompletionSupport(Document document) {
        this.docRef = new WeakReference<Document>(document);
        document.addDocumentListener(this);
    }

    public static CompletionSupport get(JTextComponent jTextComponent) {
        return CompletionSupport.get(jTextComponent.getDocument());
    }

    public static CompletionSupport get(Document document) {
        CompletionSupport completionSupport = (CompletionSupport)document.getProperty(CompletionSupport.class);
        if (completionSupport == null) {
            boolean bl;
            boolean bl2 = bl = CndLexerUtilities.getLanguage((Document)document) != null;
            if (bl) {
                completionSupport = new CompletionSupport(document);
                document.putProperty(CompletionSupport.class, completionSupport);
            }
        }
        return completionSupport;
    }

    public final Document getDocument() {
        return this.docRef.get();
    }

    public static boolean isPreprocCompletionEnabled(Document document, int n) {
        return CompletionSupport.isIncludeCompletionEnabled(document, n) || CompletionSupport.isPreprocessorDirectiveCompletionEnabled(document, n);
    }

    public static boolean isPreprocessorDirectiveCompletionEnabled(Document document, int n) {
        TokenSequence tokenSequence = CndLexerUtilities.getCppTokenSequence((Document)document, (int)n, (boolean)false, (boolean)true);
        if (tokenSequence == null) {
            return false;
        }
        if (tokenSequence.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
            TokenSequence tokenSequence2 = tokenSequence.embedded();
            tokenSequence2.moveStart();
            tokenSequence2.moveNext();
            if (!tokenSequence2.moveNext()) {
                return true;
            }
            CndTokenUtilities.shiftToNonWhite((TokenSequence)tokenSequence2, (boolean)false);
            return tokenSequence2.offset() + tokenSequence2.token().length() >= n;
        }
        return false;
    }

    public static boolean isIncludeCompletionEnabled(Document document, int n) {
        TokenSequence tokenSequence;
        TokenSequence tokenSequence2 = CndLexerUtilities.getCppTokenSequence((Document)document, (int)n, (boolean)false, (boolean)true);
        if (tokenSequence2 == null) {
            return false;
        }
        if (tokenSequence2.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE && CndTokenUtilities.moveToPreprocKeyword((TokenSequence)(tokenSequence = tokenSequence2.embedded()))) {
            switch ((CppTokenId)tokenSequence.token().id()) {
                case PREPROCESSOR_INCLUDE: 
                case PREPROCESSOR_INCLUDE_NEXT: {
                    return tokenSequence.offset() + tokenSequence.token().length() <= n;
                }
            }
        }
        return false;
    }

    public final CsmFinder getFinder() {
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)this.getDocument());
        assert (dataObject != null);
        FileObject fileObject = dataObject.getPrimaryFile();
        return CsmFinderFactory.getDefault().getFinder(fileObject);
    }

    public void setContextOffset(int n) {
        this.contextOffset = n;
    }

    public int doc2context(int n) {
        int n2 = this.contextOffset == NOT_INITIALIZED ? n : this.contextOffset;
        n2 = CsmMacroExpansion.getOffsetInOriginalText((Document)this.getDocument(), (int)n2);
        return n2;
    }

    protected void setLastSeparatorOffset(int n) {
        this.lastSeparatorOffset = n;
    }

    protected int getLastCommandSeparator(int n) throws BadLocationException {
        if (n < 0 || n > this.getDocument().getLength()) {
            throw new BadLocationException("position is out of range[0-" + this.getDocument().getLength() + "]", n);
        }
        if (n == 0) {
            return 0;
        }
        if (!CndTokenUtilities.isInPreprocessorDirective((Document)this.getDocument(), (int)n)) {
            if (this.lastSeparatorOffset >= 0 && this.lastSeparatorOffset < n) {
                return this.lastSeparatorOffset;
            }
            this.lastSeparatorOffset = CndTokenUtilities.getLastCommandSeparator((Document)this.getDocument(), (int)n);
            return this.lastSeparatorOffset;
        }
        return CndTokenUtilities.getLastCommandSeparator((Document)this.getDocument(), (int)n);
    }

    public static CsmClassifier getClassFromName(CsmFinder csmFinder, String string, boolean bl) {
        List<CsmClassifier> list;
        CsmClassifier csmClassifier = null;
        if (csmClassifier == null && bl && (list = csmFinder.findClasses(null, string, true, false)) != null && list.size() > 0 && !list.isEmpty()) {
            csmClassifier = list.get(0);
        }
        return csmClassifier;
    }

    public CsmClass getClass(int n) {
        int n2 = this.doc2context(n);
        return CompletionUtilities.findClassOnPosition(this.getDocument(), n2);
    }

    public CsmOffsetableDeclaration getDefinition(int n, FileReferencesContext fileReferencesContext) {
        int n2 = this.doc2context(n);
        return CompletionUtilities.findFunDefinitionOrClassOnPosition(this.getDocument(), n2, fileReferencesContext);
    }

    public boolean isStaticBlock(int n) {
        return false;
    }

    public static boolean isAssignable(CsmType csmType, CsmType csmType2) {
        String string;
        CsmClassifier csmClassifier = csmType.getClassifier();
        CsmClassifier csmClassifier2 = csmType2.getClassifier();
        if (csmClassifier == null) {
            return false;
        }
        if (csmClassifier2 == null) {
            return false;
        }
        if (csmClassifier.equals(CsmCompletion.NULL_CLASS)) {
            return csmType2.getArrayDepth() > 0 || !CsmCompletion.isPrimitiveClass(csmClassifier2);
        }
        if (csmClassifier2.equals(CsmCompletion.OBJECT_CLASS)) {
            return csmType.getArrayDepth() > csmType2.getArrayDepth() || csmType.getArrayDepth() == csmType2.getArrayDepth() && !CsmCompletion.isPrimitiveClass(csmClassifier);
        }
        if (csmType.getArrayDepth() != csmType2.getArrayDepth() || csmType.getPointerDepth() != csmType2.getPointerDepth()) {
            return false;
        }
        if (csmClassifier.equals(csmClassifier2)) {
            return true;
        }
        String string2 = ((Object)csmType.getCanonicalText()).toString().replaceAll("const", "").trim();
        if (string2.equals(string = ((Object)csmType2.getCanonicalText()).toString().replaceAll("const", "").trim())) {
            return true;
        }
        if (CsmKindUtilities.isClass((CsmObject)csmClassifier2) && CsmKindUtilities.isClass((CsmObject)csmClassifier)) {
            return CsmInheritanceUtilities.isAssignableFrom((CsmClass)((CsmClass)csmClassifier), (CsmClass)((CsmClass)csmClassifier2));
        }
        return false;
    }

    public CsmType getCommonType(CsmType csmType, CsmType csmType2) {
        if (csmType.equals(csmType2)) {
            return csmType;
        }
        if (!CndLexerUtilities.isType((String)((Object)csmType.getClassifier().getName()).toString()) && CndLexerUtilities.isType((String)((Object)csmType2.getClassifier().getName()).toString())) {
            if (CompletionSupport.isAssignable(csmType, csmType2)) {
                return csmType;
            }
            if (CompletionSupport.isAssignable(csmType2, csmType)) {
                return csmType2;
            }
            return null;
        }
        if (csmType.getArrayDepth() != csmType2.getArrayDepth()) {
            return null;
        }
        return null;
    }

    public static Collection<CsmFunction> filterMethods(Collection<CsmFunction> collection, List list, boolean bl, boolean bl2) {
        assert (collection != null);
        if (list == null) {
            return collection;
        }
        ArrayList<CsmFunction> arrayList = new ArrayList<CsmFunction>();
        int n = list.size();
        int n2 = bl2 ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        for (CsmFunction csmFunction : collection) {
            CsmType csmType;
            CsmParameter[] csmParameterArray = csmFunction.getParameters().toArray(new CsmParameter[csmFunction.getParameters().size()]);
            if (csmParameterArray.length == n || bl && csmParameterArray.length >= n) {
                boolean bl3 = true;
                boolean bl4 = !bl;
                int n3 = 0;
                for (int i = 0; bl3 && i < n; ++i) {
                    if (csmParameterArray[i] == null) {
                        System.err.println("Null parameter " + i + " in function " + UIDs.get((Object)csmFunction));
                        bl4 = false;
                        continue;
                    }
                    CsmType csmType2 = csmParameterArray[i].getType();
                    CsmType csmType3 = (CsmType)list.get(i);
                    if (csmType3 != null) {
                        if (!csmParameterArray[i].isVarArgs() && !CompletionSupport.equalTypes(csmType3, csmType2)) {
                            bl4 = false;
                            if (!CompletionSupport.isAssignable(csmType3, csmType2)) {
                                bl3 = false;
                                continue;
                            }
                            ++n3;
                            continue;
                        }
                        ++n3;
                        continue;
                    }
                    bl4 = false;
                }
                if (bl3) {
                    if (bl4) {
                        arrayList.clear();
                    } else if (n3 > n2) {
                        n2 = n3;
                        arrayList.clear();
                    }
                    arrayList.add(csmFunction);
                    if (!bl4) continue;
                    break;
                }
                if (n3 <= n2) continue;
                n2 = n3;
                arrayList.clear();
                arrayList.add(csmFunction);
                continue;
            }
            if (csmParameterArray.length != 0 || n != 1 || (csmType = (CsmType)list.get(0)) == null || !"void".equals(csmType.getText())) continue;
            arrayList.clear();
            arrayList.add(csmFunction);
        }
        return arrayList;
    }

    public static boolean isCompletionEnabled(Document document, int n) {
        if (document.getLength() == 0) {
            return true;
        }
        TokenSequence tokenSequence = CndLexerUtilities.getCppTokenSequence((Document)document, (int)n, (boolean)true, (n > 0 ? 1 : 0) != 0);
        if (tokenSequence == null) {
            return false;
        }
        if (tokenSequence.offset() < n && n <= tokenSequence.offset() + tokenSequence.token().length()) {
            switch ((CppTokenId)tokenSequence.token().id()) {
                case LINE_COMMENT: 
                case DOXYGEN_LINE_COMMENT: 
                case CHAR_LITERAL: 
                case STRING_LITERAL: 
                case PREPROCESSOR_USER_INCLUDE: 
                case PREPROCESSOR_SYS_INCLUDE: 
                case PREPROCESSOR_DEFINED: {
                    return false;
                }
                case BLOCK_COMMENT: 
                case DOXYGEN_COMMENT: {
                    return n == tokenSequence.offset() + tokenSequence.token().length();
                }
            }
            if ("preprocessor-keyword-directive".equals(((CppTokenId)tokenSequence.token().id()).primaryCategory())) {
                return false;
            }
            if ("number".equals(((CppTokenId)tokenSequence.token().id()).primaryCategory())) {
                return false;
            }
        }
        return true;
    }

    public static boolean needShowCompletionOnText(JTextComponent jTextComponent, String string) throws BadLocationException {
        char c = string.charAt(string.length() - 1);
        if (c == ' ' || c == '>' || c == ':' || c == '.' || c == '*') {
            int n = jTextComponent.getCaret().getDot();
            Document document = jTextComponent.getDocument();
            TokenSequence tokenSequence = CndLexerUtilities.getCppTokenSequence((Document)document, (int)n, (boolean)true, (boolean)true);
            if (tokenSequence == null) {
                return false;
            }
            Token token = tokenSequence.token();
            if (!tokenSequence.movePrevious()) {
                return false;
            }
            switch ((CppTokenId)token.id()) {
                case WHITESPACE: {
                    return token.length() == 1 && tokenSequence.token().id() == CppTokenId.NEW;
                }
                case ARROW: {
                    return true;
                }
                case DOT: {
                    return true;
                }
                case ARROWMBR: 
                case DOTMBR: {
                    return true;
                }
                case SCOPE: {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean equalTypes(CsmType csmType, CsmType csmType2) {
        assert (csmType != null);
        if (csmType.equals(csmType2)) {
            return true;
        }
        if (csmType2 != null) {
            String string = ((Object)csmType.getCanonicalText()).toString();
            String string2 = ((Object)csmType2.getCanonicalText()).toString();
            return string.equals(string2);
        }
        return false;
    }

    CsmType findExactVarType(CsmFile csmFile, String string, int n, FileReferencesContext fileReferencesContext) {
        CsmVariable csmVariable;
        if (csmFile == null) {
            return null;
        }
        int n2 = this.doc2context(n);
        CsmContext csmContext = CsmOffsetResolver.findContext(csmFile, n2, fileReferencesContext);
        if (string.length() == 0 && CsmKindUtilities.isVariable((CsmObject)csmContext.getLastObject()) && CsmOffsetUtilities.isInObject((CsmObject)(csmVariable = (CsmVariable)csmContext.getLastObject()).getInitialValue(), n2)) {
            CsmClassifier csmClassifier;
            CsmType csmType = csmVariable.getType();
            if (csmType.getArrayDepth() > 0 && (csmClassifier = csmType.getClassifier()) != null) {
                csmType = CsmCompletion.getType(csmClassifier, 0, false, 0, false);
            }
            return csmType;
        }
        for (CsmDeclaration csmDeclaration : CsmContextUtilities.findFunctionLocalVariables(csmContext)) {
            CsmVariable csmVariable2;
            if (!(csmDeclaration instanceof CsmVariable) || !((Object)(csmVariable2 = (CsmVariable)csmDeclaration).getName()).toString().equals(string)) continue;
            return csmVariable2.getType();
        }
        return null;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.lastSeparatorOffset = -1;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.lastSeparatorOffset = -1;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.lastSeparatorOffset = -1;
    }
}

