/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util.projects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.versioning.util.ProjectUtilities;
import org.netbeans.modules.versioning.util.projects.CheckoutCompletedPanel;
import org.netbeans.modules.versioning.util.projects.OpenProjectsPanel;
import org.netbeans.modules.versioning.util.projects.ProjectsView;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectOpener
implements ActionListener,
PropertyChangeListener {
    private CheckoutCompletedPanel panel;
    private Dialog dialog;
    private final Map<Project, Set<Project>> checkedOutProjects;
    private final File workingFolder;
    private OpenProjectsPanel projectsPanel;
    private JButton okButton;
    private int numberOfProjects;

    public ProjectOpener(Map<Project, Set<Project>> map, File file) {
        this.checkedOutProjects = map;
        this.workingFolder = file;
        this.numberOfProjects = map.size() - 1;
    }

    public void openCheckedOutProjects() {
        this.panel = new CheckoutCompletedPanel();
        this.panel.openButton.addActionListener(this);
        this.panel.createButton.addActionListener(this);
        this.panel.closeButton.addActionListener(this);
        this.panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.panel.againCheckBox.setVisible(false);
        String string = NbBundle.getMessage(CheckoutCompletedPanel.class, (String)"BK3008");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.panel, string);
        dialogDescriptor.setModal(true);
        this.panel.remove(this.panel.openButton);
        this.panel.remove(this.panel.createButton);
        this.panel.remove(this.panel.closeButton);
        Object[] objectArray = null;
        if (this.numberOfProjects > 1) {
            String string2 = NbBundle.getMessage(ProjectOpener.class, (String)"BK3009", (Object)new Integer(this.numberOfProjects));
            this.panel.jLabel1.setText(string2);
            objectArray = new Object[]{this.panel.openButton, this.panel.closeButton};
        } else if (this.numberOfProjects == 1) {
            Project project = this.checkedOutProjects.get(null).iterator().next();
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
            String string3 = projectInformation.getDisplayName();
            String string4 = NbBundle.getMessage(ProjectOpener.class, (String)"BK3011", (Object)string3);
            this.panel.jLabel1.setText(string4);
            this.panel.openButton.setText(NbBundle.getMessage(ProjectOpener.class, (String)"BK3012"));
            objectArray = new Object[]{this.panel.openButton, this.panel.closeButton};
        } else {
            String string5 = NbBundle.getMessage(ProjectOpener.class, (String)"BK3010");
            this.panel.jLabel1.setText(string5);
            objectArray = new Object[]{this.panel.createButton, this.panel.closeButton};
        }
        dialogDescriptor.setMessageType(1);
        dialogDescriptor.setOptions(objectArray);
        dialogDescriptor.setClosingOptions(objectArray);
        this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        this.dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectOpener.class, (String)"ACSD_CheckoutCompleted_Dialog"));
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ProjectOpener.this.dialog.setVisible(true);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.dialog.setVisible(false);
        if (this.panel.openButton.equals(object)) {
            if (this.numberOfProjects > 1) {
                this.selectAndOpenProjects(this.checkedOutProjects);
            } else {
                this.openProject(this.checkedOutProjects.get(null).iterator().next());
            }
        } else if (this.panel.createButton.equals(object)) {
            ProjectUtilities.newProjectWizard(this.workingFolder);
        }
    }

    private void openProject(Project project) {
        Project[] projectArray = new Project[]{project};
        OpenProjects.getDefault().open(projectArray, false, true);
        ProjectUtilities.selectAndExpandProject(project);
    }

    private void selectAndOpenProjects(Map<Project, Set<Project>> map) {
        this.projectsPanel = new OpenProjectsPanel();
        ProjectsView projectsView = new ProjectsView(map);
        this.projectsPanel.jPanel1.setLayout(new BorderLayout());
        this.projectsPanel.jPanel1.add((Component)projectsView, "Center");
        projectsView.addSelectionChangeListener(this);
        this.okButton = new JButton(NbBundle.getMessage(CheckoutCompletedPanel.class, (String)"LBL_ButtonOpen"));
        this.okButton.setEnabled(false);
        JButton jButton = new JButton(NbBundle.getMessage(CheckoutCompletedPanel.class, (String)"LBL_ButtonCancel"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.projectsPanel, NbBundle.getMessage(CheckoutCompletedPanel.class, (String)"LBL_OpenPanelLabel"), true, new Object[]{this.okButton, jButton}, (Object)this.okButton, 0, new HelpCtx(this.getClass()), null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == this.okButton) {
            final Set<Project> set = projectsView.getSelectedProjects();
            if (this.projectsPanel.cbOpenRequired.isSelected()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        final HashSet<Project> hashSet = new HashSet<Project>();
                        HashMap<Project, Set<? extends Project>> hashMap = new HashMap<Project, Set<? extends Project>>();
                        hashSet.addAll(set);
                        for (Project project : set) {
                            ProjectUtilities.addSubprojects(project, hashSet, hashMap);
                        }
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                for (Project project : hashSet) {
                                    ProjectOpener.this.openProject(project);
                                }
                            }
                        });
                    }
                });
            } else {
                for (Project project : set) {
                    this.openProject(project);
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            if (nodeArray.length == 0) {
                this.okButton.setEnabled(false);
            } else {
                this.okButton.setEnabled(true);
            }
        }
    }
}

