/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.versioning.util.HyperlinkProvider;
import org.netbeans.modules.versioning.util.VCSKenaiSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCSHyperlinkSupport {
    private static Logger LOG = Logger.getLogger(VCSHyperlinkSupport.class.getName());
    private Map<Integer, List<Linker>> linkers = new HashMap<Integer, List<Linker>>();

    public <T extends Linker> T getLinker(Class<T> clazz, int n) {
        List<Linker> list = this.linkers.get(n);
        if (list == null) {
            return null;
        }
        for (Linker linker : list) {
            if (linker.getClass() != clazz) continue;
            return (T)linker;
        }
        return null;
    }

    public void add(Linker linker, int n) {
        if (linker == null) {
            return;
        }
        List<Linker> list = this.linkers.get(n);
        if (list == null) {
            list = new ArrayList<Linker>();
        }
        list.add(linker);
        this.linkers.put(n, list);
    }

    public boolean mouseMoved(Point point, JComponent jComponent, int n) {
        List<Linker> list = this.linkers.get(n);
        if (list == null) {
            return false;
        }
        for (Linker linker : list) {
            if (!linker.mouseMoved(point, jComponent)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseClicked(Point point, int n) {
        List<Linker> list = this.linkers.get(n);
        if (list == null) {
            return false;
        }
        for (Linker linker : list) {
            if (!linker.mouseClicked(point)) continue;
            return true;
        }
        return false;
    }

    public void computeBounds(JTextPane jTextPane, int n) {
        List<Linker> list = this.linkers.get(n);
        if (list == null) {
            return;
        }
        for (Linker linker : list) {
            linker.computeBounds(jTextPane);
        }
    }

    public static class AuthorLinker
    extends Linker {
        private static final String AUTHOR_ICON_STYLE = "authorIconStyle";
        private Rectangle bounds;
        private final int docstart;
        private final int docend;
        private final VCSKenaiSupport.KenaiUser kenaiUser;
        private final String author;
        private final Style authorStyle;
        private final String insertToChat;

        public AuthorLinker(VCSKenaiSupport.KenaiUser kenaiUser, Style style, StyledDocument styledDocument, String string) throws BadLocationException {
            this(kenaiUser, style, styledDocument, string, null);
        }

        public AuthorLinker(VCSKenaiSupport.KenaiUser kenaiUser, Style style, StyledDocument styledDocument, String string, String string2) throws BadLocationException {
            this.kenaiUser = kenaiUser;
            this.author = string;
            this.authorStyle = style;
            this.insertToChat = string2;
            int n = styledDocument.getLength();
            int n2 = string.length();
            this.docstart = n;
            this.docend = n + n2;
        }

        public void computeBounds(JTextPane jTextPane) {
            Rectangle rectangle = jTextPane.getBounds();
            TextUI textUI = jTextPane.getUI();
            this.bounds = new Rectangle();
            try {
                Rectangle rectangle2 = textUI.modelToView(jTextPane, this.docstart, Position.Bias.Forward).getBounds();
                Rectangle rectangle3 = textUI.modelToView(jTextPane, this.docend, Position.Bias.Backward).getBounds();
                if (this.kenaiUser.getIcon() != null) {
                    rectangle3.x += this.kenaiUser.getIcon().getIconWidth();
                }
                this.bounds = new Rectangle(rectangle.x + rectangle2.x, rectangle2.y, rectangle3.x - rectangle2.x, rectangle2.height);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }

        public boolean mouseClicked(Point point) {
            if (this.bounds != null && this.bounds.contains(point)) {
                if (this.insertToChat != null) {
                    this.kenaiUser.startChat(this.insertToChat);
                } else {
                    this.kenaiUser.startChat();
                }
                return true;
            }
            return false;
        }

        public boolean mouseMoved(Point point, JComponent jComponent) {
            if (this.bounds != null && this.bounds.contains(point)) {
                jComponent.setCursor(Cursor.getPredefinedCursor(12));
                jComponent.setToolTipText(NbBundle.getMessage(VCSHyperlinkSupport.class, (String)"LBL_StartChat", (Object)this.author));
                return true;
            }
            return false;
        }

        public void insertString(StyledDocument styledDocument, Style style) throws BadLocationException {
            if (style == null) {
                style = this.authorStyle;
            }
            styledDocument.insertString(styledDocument.getLength(), this.author, style);
            String string = AUTHOR_ICON_STYLE + this.author;
            Style style2 = styledDocument.getStyle(string);
            if (style2 == null) {
                style2 = styledDocument.addStyle(string, null);
                StyleConstants.setIcon(style2, this.kenaiUser.getIcon());
            }
            styledDocument.insertString(styledDocument.getLength(), " ", style);
            styledDocument.insertString(styledDocument.getLength(), " ", style2);
        }
    }

    public static class IssueLinker
    extends Linker {
        private Rectangle[] bounds;
        private final int[] docstart;
        private final int[] docend;
        private final int[] start;
        private final int[] end;
        private final String text;
        private final HyperlinkProvider hp;
        private final File root;
        private final int length;
        private final Style issueHyperlinkStyle;

        private IssueLinker(HyperlinkProvider hyperlinkProvider, Style style, File file, StyledDocument styledDocument, String string, int[] nArray) {
            this.length = nArray.length / 2;
            this.docstart = new int[this.length];
            this.docend = new int[this.length];
            this.start = new int[this.length];
            this.end = new int[this.length];
            this.hp = hyperlinkProvider;
            this.root = file;
            this.text = string;
            this.issueHyperlinkStyle = style;
            int n = 0;
            while (n < nArray.length) {
                int n2;
                int n3;
                int n4 = n / 2;
                if ((n3 = nArray[n++]) < (n2 = nArray[n++])) {
                    LOG.warning("Hyperlink provider " + hyperlinkProvider.getClass().getName() + " returns wrong spans [" + n2 + "," + n3 + "]");
                    continue;
                }
                int n5 = styledDocument.getLength();
                this.start[n4] = n2;
                this.end[n4] = n3;
                this.docstart[n4] = n5 + n2;
                this.docend[n4] = n5 + n3;
            }
        }

        public static IssueLinker create(HyperlinkProvider hyperlinkProvider, Style style, File file, StyledDocument styledDocument, String string) {
            int[] nArray = hyperlinkProvider.getSpans(string);
            if (nArray == null) {
                return null;
            }
            if (nArray.length % 2 != 0) {
                LOG.warning("Hyperlink provider " + hyperlinkProvider.getClass().getName() + " returns wrong spans");
                return null;
            }
            if (nArray.length > 0) {
                IssueLinker issueLinker = new IssueLinker(hyperlinkProvider, style, file, styledDocument, string, nArray);
                return issueLinker;
            }
            return null;
        }

        public void computeBounds(JTextPane jTextPane) {
            Rectangle rectangle = jTextPane.getBounds();
            TextUI textUI = jTextPane.getUI();
            this.bounds = new Rectangle[this.length];
            for (int i = 0; i < this.length; ++i) {
                try {
                    Rectangle rectangle2 = textUI.modelToView(jTextPane, this.docstart[i], Position.Bias.Forward).getBounds();
                    Rectangle rectangle3 = textUI.modelToView(jTextPane, this.docend[i], Position.Bias.Backward).getBounds();
                    this.bounds[i] = new Rectangle(rectangle.x + rectangle2.x, rectangle2.y, rectangle3.x - rectangle2.x, rectangle2.height);
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public boolean mouseMoved(Point point, JComponent jComponent) {
            for (int i = 0; i < this.start.length; ++i) {
                if (this.bounds == null || this.bounds[i] == null || !this.bounds[i].contains(point)) continue;
                jComponent.setCursor(Cursor.getPredefinedCursor(12));
                return true;
            }
            return false;
        }

        public boolean mouseClicked(Point point) {
            for (int i = 0; i < this.start.length; ++i) {
                if (this.bounds == null || this.bounds[i] == null || !this.bounds[i].contains(point)) continue;
                this.hp.onClick(this.root, this.text, this.start[i], this.end[i]);
                return true;
            }
            return false;
        }

        public void insertString(StyledDocument styledDocument, Style style) throws BadLocationException {
            styledDocument.insertString(styledDocument.getLength(), this.text, style);
            for (int i = 0; i < this.length; ++i) {
                styledDocument.setCharacterAttributes(styledDocument.getLength() - this.text.length() + this.start[i], this.end[i] - this.start[i], this.issueHyperlinkStyle, false);
            }
        }
    }

    public static abstract class Linker {
        public abstract boolean mouseMoved(Point var1, JComponent var2);

        public abstract boolean mouseClicked(Point var1);

        public abstract void computeBounds(JTextPane var1);

        public abstract void insertString(StyledDocument var1, Style var2) throws BadLocationException;
    }
}

