/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.netbeans.modules.gsf.testrunner.TestRunnerSettings;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.ResultPanelTree;
import org.netbeans.modules.gsf.testrunner.api.StatisticsPanel;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.windows.IOContainer;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

final class ResultDisplayHandler {
    private static final Logger LOGGER = Logger.getLogger(ResultDisplayHandler.class.getName());
    private static ResourceBundle bundle = NbBundle.getBundle(ResultDisplayHandler.class);
    private ResultPanelTree treePanel;
    private JSplitPane displayComp;
    private JComponent outputComponent;
    private InputOutput inOut;
    private final TestSession session;
    static final Object[] EMPTY_QUEUE = new Object[0];
    private final Object queueLock = new Object();
    private volatile Object[] outputQueue;
    private volatile int outputQueueSize = 0;
    private String runningSuite;
    private final List<Report> reports = new ArrayList<Report>();
    private String message;
    private boolean sessionFinished;
    private Map<String, Method> methodsMap = new HashMap<String, Method>();

    public ResultDisplayHandler(TestSession testSession) {
        this.session = testSession;
    }

    JComponent getOutputComponent() {
        if (this.outputComponent == null) {
            this.outputComponent = new JPanel(new BorderLayout());
        }
        return this.outputComponent;
    }

    void createIO(IOContainer iOContainer) {
        this.inOut = IOProvider.getDefault().getIO("test-results", null, iOContainer);
    }

    public TestSession getSession() {
        return this.session;
    }

    public JSplitPane getDisplayComponent() {
        if (this.displayComp == null) {
            this.displayComp = this.createDisplayComp();
        }
        return this.displayComp;
    }

    private JSplitPane createDisplayComp() {
        TestRunnerSettings.DividerSettings dividerSettings = TestRunnerSettings.getDefault().getDividerSettings(null);
        return this.createDisplayComp(new StatisticsPanel(this), this.getOutputComponent(), dividerSettings.getOrientation(), dividerSettings.getLocation());
    }

    private JSplitPane createDisplayComp(Component component, Component component2, int n, int n2) {
        final JSplitPane jSplitPane = new JSplitPane(n, component, component2);
        jSplitPane.setDividerLocation(n2);
        jSplitPane.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ResultPanelTree"));
        jSplitPane.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ResultPanelTree"));
        jSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TestRunnerSettings.DividerSettings dividerSettings = new TestRunnerSettings.DividerSettings(jSplitPane.getOrientation(), jSplitPane.getDividerLocation());
                TestRunnerSettings.getDefault().setDividerSettings(dividerSettings);
            }
        });
        jSplitPane.addPropertyChangeListener("orientation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TestRunnerSettings.DividerSettings dividerSettings = new TestRunnerSettings.DividerSettings(jSplitPane.getOrientation(), jSplitPane.getDividerLocation());
                TestRunnerSettings.getDefault().setDividerSettings(dividerSettings);
            }
        });
        return jSplitPane;
    }

    void displayShown() {
    }

    void displayHidden() {
    }

    Object getOutputQueueLock() {
        return this.queueLock;
    }

    public void displayOutput(String string, boolean bl) {
        if (this.inOut != null) {
            OutputWriter outputWriter = bl ? this.inOut.getErr() : this.inOut.getOut();
            this.session.getOutputLineHandler().handleLine(outputWriter, string);
        } else {
            LOGGER.log(Level.WARNING, "Tried to display output before inOut was initialized. Output text: {0}", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] consumeOutput() {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.outputQueueSize == 0) {
                return EMPTY_QUEUE;
            }
            Object[] objectArray = this.outputQueue;
            this.outputQueue = null;
            this.outputQueueSize = 0;
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displaySuiteRunning(String string) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            assert (this.runningSuite == null);
            String string2 = string = string != null ? string : TestSuite.ANONYMOUS_SUITE;
            if (this.treePanel == null) {
                this.runningSuite = string;
                return;
            }
        }
        this.displayInDispatchThread(this.prepareMethod("displaySuiteRunning", String.class), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displaySuiteRunning(TestSuite testSuite) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            assert (this.runningSuite == null);
            TestSuite testSuite2 = testSuite = testSuite != null ? testSuite : TestSuite.ANONYMOUS_TEST_SUITE;
            if (this.treePanel == null) {
                this.runningSuite = testSuite.getName();
                return;
            }
        }
        this.displayInDispatchThread(this.prepareMethod("displaySuiteRunning", TestSuite.class), testSuite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayReport(Report report) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel == null) {
                if (!this.reports.contains(report)) {
                    this.reports.add(report);
                }
                this.runningSuite = null;
                return;
            }
            assert (this.runningSuite == null);
        }
        this.displayInDispatchThread(this.prepareMethod("displayReport", Report.class), report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayMessage(String string) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel == null) {
                this.message = string;
                return;
            }
        }
        this.displayInDispatchThread(this.prepareMethod("displayMsg", String.class), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayMessageSessionFinished(String string) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel == null) {
                this.sessionFinished = true;
                this.message = string;
                return;
            }
        }
        this.displayInDispatchThread(this.prepareMethod("displayMsgSessionFinished", String.class), string);
    }

    private void displayInDispatchThread(final Method method, final Object object) {
        assert (method != null);
        final Method method2 = method;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Invoking: " + method.getName() + " with param: " + object);
                    }
                    method2.invoke((Object)ResultDisplayHandler.this.treePanel, object);
                }
                catch (InvocationTargetException invocationTargetException) {
                    ErrorManager.getDefault().notify(invocationTargetException.getTargetException());
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(65536, (Throwable)exception);
                }
            }
        });
    }

    private synchronized Method prepareMethod(String string, Class clazz) {
        Method method = this.methodsMap.get(string + "_" + clazz.getName());
        if (method == null) {
            try {
                method = ResultPanelTree.class.getDeclaredMethod(string, clazz);
            }
            catch (Exception exception) {
                method = null;
                ErrorManager.getDefault().notify(65536, (Throwable)exception);
            }
            this.methodsMap.put(string + "_" + clazz.getName(), method);
        }
        return method;
    }

    synchronized void setTreePanel(ResultPanelTree resultPanelTree) {
        assert (EventQueue.isDispatchThread());
        if (this.treePanel != null) {
            return;
        }
        this.treePanel = resultPanelTree;
        if (this.message != null) {
            resultPanelTree.displayMsg(this.message);
            this.message = null;
        }
        if (!this.reports.isEmpty()) {
            resultPanelTree.displayReports(this.reports);
            this.reports.clear();
        }
        if (this.runningSuite != null) {
            resultPanelTree.displaySuiteRunning(this.runningSuite != TestSuite.ANONYMOUS_SUITE ? this.runningSuite : null);
            this.runningSuite = null;
        }
        if (this.sessionFinished) {
            resultPanelTree.displayMsgSessionFinished(this.message);
        }
    }
}

