/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartDecorator;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartItemChange;
import org.netbeans.lib.profiler.charts.ChartOverlay;
import org.netbeans.lib.profiler.charts.ChartSelectionListener;
import org.netbeans.lib.profiler.charts.ChartSelectionManager;
import org.netbeans.lib.profiler.charts.ChartSelectionModel;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.ItemsListener;
import org.netbeans.lib.profiler.charts.ItemsModel;
import org.netbeans.lib.profiler.charts.PaintersListener;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.canvas.InteractiveCanvasComponent;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.swing.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartComponent
extends InteractiveCanvasComponent {
    private RenderingHints renderingHints;
    private List<ChartDecorator> preDecorators;
    private List<ChartDecorator> postDecorators;
    private ItemsModel itemsModel;
    private PaintersModel paintersModel;
    protected LongRect dataBounds;
    private LongRect initialDataBounds;
    private ChartContext chartContext;
    private ItemsModelListener itemsListener;
    private PaintersModelListener paintersListener;
    private List<ChartOverlay> overlays;
    private ChartSelectionModel selectionModel;
    private SelectionListener selectionListener;
    private List<ChartConfigurationListener> configurationListeners;

    public ChartComponent() {
        this.initRenderingHints();
        this.itemsListener = new ItemsModelListener();
        this.paintersListener = new PaintersModelListener();
        this.dataBounds = new LongRect();
        this.initialDataBounds = new LongRect();
        this.setLayout(null);
        this.setSelectionModel(new ChartSelectionManager());
    }

    public final void setItemsModel(ItemsModel itemsModel) {
        if (itemsModel == null) {
            throw new IllegalArgumentException("ItemsModel cannot be null");
        }
        if (itemsModel == this.itemsModel) {
            return;
        }
        if (this.itemsModel != null) {
            this.itemsModel.removeItemsListener(this.itemsListener);
        }
        this.itemsModel = itemsModel;
        this.itemsModel.addItemsListener(this.itemsListener);
        this.updateChart();
    }

    public final ItemsModel getItemsModel() {
        return this.itemsModel;
    }

    public final void setPaintersModel(PaintersModel paintersModel) {
        if (paintersModel == null) {
            throw new IllegalArgumentException("PaintersModel cannot be null");
        }
        if (paintersModel == this.paintersModel) {
            return;
        }
        if (this.paintersModel != null) {
            this.paintersModel.removePaintersListener(this.paintersListener);
        }
        this.paintersModel = paintersModel;
        this.paintersModel.addPaintersListener(this.paintersListener);
        this.updateChart();
    }

    public final PaintersModel getPaintersModel() {
        return this.paintersModel;
    }

    public final void setSelectionModel(ChartSelectionModel chartSelectionModel) {
        if (this.selectionModel != null) {
            this.selectionModel.removeSelectionListener(this.selectionListener);
            if (this.selectionModel instanceof ChartSelectionManager) {
                ((ChartSelectionManager)this.selectionModel).unregisterChart(this);
            }
        }
        this.selectionModel = chartSelectionModel;
        if (chartSelectionModel != null) {
            if (this.selectionListener == null) {
                this.selectionListener = new SelectionListener();
            }
            chartSelectionModel.addSelectionListener(this.selectionListener);
            if (chartSelectionModel instanceof ChartSelectionManager) {
                ((ChartSelectionManager)chartSelectionModel).registerChart(this);
            }
        } else {
            this.selectionListener = null;
        }
    }

    public final ChartSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public final void setInitialDataBounds(LongRect longRect) {
        if (LongRect.equals(longRect, this.initialDataBounds)) {
            return;
        }
        LongRect.set(this.initialDataBounds, longRect);
        if (LongRect.isEmpty(this.dataBounds)) {
            this.resizeChart();
            this.invalidateImage();
            this.repaintDirty();
        }
    }

    public final LongRect getInitialDataBounds() {
        return this.initialDataBounds;
    }

    public final void setRenderingHints(RenderingHints renderingHints) {
        this.renderingHints = Utils.checkedRenderingHints(renderingHints);
    }

    public final RenderingHints getRenderingHints() {
        return (RenderingHints)this.renderingHints.clone();
    }

    private void applyRenderingHints(Graphics2D graphics2D) {
        if (this.renderingHints != null) {
            graphics2D.setRenderingHints(this.renderingHints);
        }
    }

    private void initRenderingHints() {
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        this.setRenderingHints(renderingHints);
    }

    public final ChartContext getChartContext() {
        return this.getChartContext(null);
    }

    protected ChartContext getChartContext(ChartItem chartItem) {
        if (this.chartContext == null) {
            this.chartContext = this.createChartContext();
        }
        return this.chartContext;
    }

    protected ChartContext createChartContext() {
        return new Context(this);
    }

    public final void addConfigurationListener(ChartConfigurationListener chartConfigurationListener) {
        if (this.configurationListeners == null) {
            this.configurationListeners = new ArrayList<ChartConfigurationListener>();
        }
        this.configurationListeners.add(chartConfigurationListener);
    }

    public final void removeConfigurationListener(ChartConfigurationListener chartConfigurationListener) {
        if (this.configurationListeners == null) {
            return;
        }
        this.configurationListeners.remove(chartConfigurationListener);
    }

    @Override
    protected final void offsetChanged(long l, long l2, long l3, long l4) {
        super.offsetChanged(l, l2, l3, l4);
        this.fireOffsetChanged(l, l2, l3, l4);
    }

    @Override
    protected final void scaleChanged(double d, double d2, double d3, double d4) {
        super.scaleChanged(d, d2, d3, d4);
        this.fireScaleChanged(d, d2, d3, d4);
    }

    @Override
    protected final void dataBoundsChanged(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        super.dataBoundsChanged(l, l2, l3, l4, l5, l6, l7, l8);
        this.fireDataBoundsChanged(l, l2, l3, l4, l5, l6, l7, l8);
    }

    @Override
    protected final void contentsWillBeUpdated(long l, long l2, double d, double d2, long l3, long l4, double d3, double d4) {
        super.contentsWillBeUpdated(l, l2, d, d2, l3, l4, d3, d4);
        this.fireContentsWillBeUpdated(l, l2, d, d2, l3, l4, d3, d4);
    }

    @Override
    protected final void contentsUpdated(long l, long l2, double d, double d2, long l3, long l4, double d3, double d4, int n, int n2) {
        super.contentsUpdated(l, l2, d, d2, l3, l4, d3, d4, n, n2);
        this.fireContentsUpdated(l, l2, d, d2, l3, l4, d3, d4, n, n2);
    }

    private void fireOffsetChanged(long l, long l2, long l3, long l4) {
        if (this.configurationListeners == null) {
            return;
        }
        for (ChartConfigurationListener chartConfigurationListener : this.configurationListeners) {
            chartConfigurationListener.offsetChanged(l, l2, l3, l4);
        }
    }

    private void fireScaleChanged(double d, double d2, double d3, double d4) {
        if (this.configurationListeners == null) {
            return;
        }
        for (ChartConfigurationListener chartConfigurationListener : this.configurationListeners) {
            chartConfigurationListener.scaleChanged(d, d2, d3, d4);
        }
    }

    private void fireDataBoundsChanged(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        if (this.configurationListeners == null) {
            return;
        }
        for (ChartConfigurationListener chartConfigurationListener : this.configurationListeners) {
            chartConfigurationListener.dataBoundsChanged(l, l2, l3, l4, l5, l6, l7, l8);
        }
    }

    private void fireContentsWillBeUpdated(long l, long l2, double d, double d2, long l3, long l4, double d3, double d4) {
        if (this.configurationListeners == null) {
            return;
        }
        for (ChartConfigurationListener chartConfigurationListener : this.configurationListeners) {
            chartConfigurationListener.contentsWillBeUpdated(l, l2, d, d2, l3, l4, d3, d4);
        }
    }

    private void fireContentsUpdated(long l, long l2, double d, double d2, long l3, long l4, double d3, double d4, int n, int n2) {
        if (this.configurationListeners == null) {
            return;
        }
        for (ChartConfigurationListener chartConfigurationListener : this.configurationListeners) {
            chartConfigurationListener.contentsUpdated(l, l2, d, d2, l3, l4, d3, d4, n, n2);
        }
    }

    public final void addPreDecorator(ChartDecorator chartDecorator) {
        if (this.preDecorators == null) {
            this.preDecorators = new ArrayList<ChartDecorator>(2);
        }
        this.preDecorators.add(chartDecorator);
    }

    public final void removePreDecorator(ChartDecorator chartDecorator) {
        if (this.preDecorators != null) {
            this.preDecorators.remove(chartDecorator);
        }
    }

    final List<ChartDecorator> getPreDecorators() {
        return this.preDecorators;
    }

    public final void addPostDecorator(ChartDecorator chartDecorator) {
        if (this.postDecorators == null) {
            this.postDecorators = new ArrayList<ChartDecorator>(2);
        }
        this.postDecorators.add(chartDecorator);
    }

    public final void removePostDecorator(ChartDecorator chartDecorator) {
        if (this.postDecorators != null) {
            this.postDecorators.remove(chartDecorator);
        }
    }

    final List<ChartDecorator> getPostDecorators() {
        return this.postDecorators;
    }

    public final void addOverlayComponent(ChartOverlay chartOverlay) {
        if (this.overlays == null) {
            this.overlays = new ArrayList<ChartOverlay>();
        }
        chartOverlay.setChartContext(this.getChartContext());
        this.overlays.add(chartOverlay);
        this.add(chartOverlay);
    }

    public final void removeOverlayComponent(ChartOverlay chartOverlay) {
        this.remove(chartOverlay);
        this.overlays.remove(chartOverlay);
        chartOverlay.setChartContext(null);
    }

    @Override
    protected void reshaped(Rectangle rectangle, Rectangle rectangle2) {
        super.reshaped(rectangle, rectangle2);
        if (this.overlays == null) {
            return;
        }
        for (ChartOverlay chartOverlay : this.overlays) {
            chartOverlay.setBounds(0, 0, rectangle2.width, rectangle2.height);
        }
    }

    @Override
    protected void paintContents(Graphics graphics, Rectangle rectangle) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setClip(rectangle);
        this.applyRenderingHints(graphics2D);
        if (this.isOpaque()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.preDecorators != null) {
            for (ChartDecorator chartDecorator : this.preDecorators) {
                chartDecorator.paint(graphics2D, rectangle, this.getChartContext());
            }
        }
        if (this.itemsModel != null && this.paintersModel != null && (n = this.itemsModel.getItemsCount()) != 0) {
            boolean bl = this.selectionModel != null;
            List<ItemSelection> list = bl ? this.selectionModel.getHighlightedItems() : null;
            List<ItemSelection> list2 = bl ? this.selectionModel.getSelectedItems() : null;
            List list3 = bl ? new ArrayList() : Collections.EMPTY_LIST;
            List list4 = bl ? new ArrayList() : Collections.EMPTY_LIST;
            for (int i = 0; i < n; ++i) {
                ChartItem chartItem = this.itemsModel.getItem(i);
                ItemPainter itemPainter = this.paintersModel.getPainter(chartItem);
                if (bl) {
                    list3.clear();
                    if (itemPainter.supportsHovering(chartItem)) {
                        ChartComponent.filterSelection(list, list3, chartItem);
                    }
                    list4.clear();
                    if (itemPainter.supportsSelecting(chartItem)) {
                        ChartComponent.filterSelection(list2, list4, chartItem);
                    }
                }
                itemPainter.paintItem(chartItem, list3, list4, graphics2D, rectangle, this.getChartContext(chartItem));
            }
        }
        if (this.postDecorators != null) {
            for (ChartDecorator chartDecorator : this.postDecorators) {
                chartDecorator.paint(graphics2D, rectangle, this.getChartContext());
            }
        }
    }

    private static void filterSelection(List<ItemSelection> list, List<ItemSelection> list2, ChartItem chartItem) {
        if (chartItem == null) {
            return;
        }
        for (ItemSelection itemSelection : list) {
            if (!itemSelection.getItem().equals(chartItem)) continue;
            list2.add(itemSelection);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(Utils.checkedColor(color));
    }

    protected void computeDataBounds() {
        LongRect.clear(this.dataBounds);
        if (this.itemsModel == null || this.paintersModel == null) {
            return;
        }
        int n = this.itemsModel.getItemsCount();
        for (int i = 0; i < n; ++i) {
            ChartItem chartItem = this.itemsModel.getItem(i);
            ItemPainter itemPainter = this.paintersModel.getPainter(chartItem);
            if (i == 0) {
                LongRect.set(this.dataBounds, itemPainter.getItemBounds(chartItem));
                continue;
            }
            LongRect.add(this.dataBounds, itemPainter.getItemBounds(chartItem));
        }
    }

    protected void resizeChart() {
        if (LongRect.isEmpty(this.dataBounds)) {
            LongRect longRect = new LongRect(this.dataBounds);
            if (longRect.width == 0L) {
                longRect.width = this.initialDataBounds.width;
                if (longRect.x == 0L) {
                    longRect.x = this.initialDataBounds.x;
                }
            }
            if (longRect.height == 0L) {
                longRect.height = this.initialDataBounds.height;
                if (longRect.y == 0L) {
                    longRect.y = this.initialDataBounds.y;
                }
            }
            this.setDataBounds(longRect.x, longRect.y, longRect.width, longRect.height);
        } else {
            this.setDataBounds(this.dataBounds.x, this.dataBounds.y, this.dataBounds.width, this.dataBounds.height);
        }
    }

    protected void updateChart() {
        this.computeDataBounds();
        this.resizeChart();
        this.invalidateImage();
        this.repaintDirty();
    }

    protected void itemsAdded(List<ChartItem> list) {
        LongRect longRect = new LongRect(this.dataBounds);
        for (ChartItem object : list) {
            ItemPainter itemPainter = this.paintersModel.getPainter(object);
            LongRect.add(this.dataBounds, itemPainter.getItemBounds(object));
        }
        if (!LongRect.equals(longRect, this.dataBounds)) {
            this.resizeChart();
        }
        Object object = null;
        for (ChartItem chartItem : list) {
            ItemPainter itemPainter = this.paintersModel.getPainter(chartItem);
            if (object == null) {
                object = new LongRect(itemPainter.getItemBounds(chartItem, this.getChartContext(chartItem)));
                continue;
            }
            LongRect.add(object, itemPainter.getItemBounds(chartItem, this.getChartContext(chartItem)));
        }
        this.invalidateImage(Utils.checkedRectangle(object));
        this.repaintDirty();
    }

    /*
     * WARNING - void declaration
     */
    protected void itemsRemoved(List<ChartItem> list) {
        ArrayList<ItemPainter> arrayList = new ArrayList<ItemPainter>(list.size());
        for (ChartItem object : list) {
            ItemPainter itemPainter = this.paintersModel.getPainter(object);
            if (itemPainter == null) {
                arrayList = null;
                break;
            }
            arrayList.add(itemPainter);
        }
        if (arrayList == null) {
            this.updateChart();
        } else {
            void var4_6;
            LongRect longRect = new LongRect(this.dataBounds);
            this.computeDataBounds();
            if (!LongRect.equals(longRect, this.dataBounds)) {
                this.resizeChart();
            }
            Object var4_5 = null;
            for (int i = 0; i < list.size(); ++i) {
                ChartItem chartItem = list.get(i);
                ItemPainter itemPainter = (ItemPainter)arrayList.get(i);
                if (var4_6 == null) {
                    LongRect longRect2 = new LongRect(itemPainter.getItemBounds(chartItem, this.getChartContext(chartItem)));
                    continue;
                }
                LongRect.add((LongRect)var4_6, itemPainter.getItemBounds(chartItem, this.getChartContext(chartItem)));
            }
            this.invalidateImage(Utils.checkedRectangle((LongRect)var4_6));
            this.repaintDirty();
        }
    }

    protected void itemsChanged(List<ChartItemChange> list) {
        Object object;
        Object object2;
        ArrayList<ItemPainter> arrayList = new ArrayList<ItemPainter>(list.size());
        for (ChartItemChange chartItemChange : list) {
            arrayList.add(this.paintersModel.getPainter(chartItemChange.getItem()));
        }
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            ChartItemChange chartItemChange = list.get(i);
            object2 = (ItemPainter)arrayList.get(i);
            bl = object2.isBoundsChange(chartItemChange);
            if (bl) break;
        }
        if (bl) {
            LongRect longRect = new LongRect(this.dataBounds);
            this.computeDataBounds();
            if (!LongRect.equals(longRect, this.dataBounds)) {
                this.resizeChart();
            }
        }
        boolean bl2 = false;
        for (int i = 0; i < list.size(); ++i) {
            object2 = list.get(i);
            object = (ItemPainter)arrayList.get(i);
            bl2 = object.isAppearanceChange((ChartItemChange)object2);
            if (bl2) break;
        }
        if (bl2) {
            LongRect longRect = null;
            for (int i = 0; i < list.size(); ++i) {
                object = list.get(i);
                ChartItem chartItem = object.getItem();
                ItemPainter itemPainter = this.paintersModel.getPainter(chartItem);
                if (!itemPainter.isAppearanceChange((ChartItemChange)object)) continue;
                if (longRect == null) {
                    longRect = new LongRect(itemPainter.getDirtyBounds((ChartItemChange)object, this.getChartContext(chartItem)));
                    continue;
                }
                LongRect.add(longRect, itemPainter.getDirtyBounds((ChartItemChange)object, this.getChartContext(chartItem)));
            }
            this.invalidateImage(Utils.checkedRectangle(longRect));
            this.repaintDirtyAccel();
        } else {
            this.repaintDirty();
        }
    }

    protected void paintersChanged() {
        this.updateChart();
    }

    protected void paintersChanged(List<ItemPainter> list) {
        HashSet<Object> hashSet = new HashSet<Object>();
        LongRect longRect = new LongRect(this.dataBounds);
        this.computeDataBounds();
        if (!LongRect.equals(longRect, this.dataBounds)) {
            this.resizeChart();
        }
        for (int i = 0; i < this.itemsModel.getItemsCount(); ++i) {
            ChartItem chartItem = this.itemsModel.getItem(i);
            if (!list.contains(this.paintersModel.getPainter(chartItem))) continue;
            hashSet.add(chartItem);
        }
        LongRect longRect2 = null;
        for (ChartItem chartItem : hashSet) {
            ItemPainter itemPainter = this.paintersModel.getPainter(chartItem);
            if (longRect2 == null) {
                longRect2 = new LongRect(itemPainter.getItemBounds(chartItem, this.getChartContext(chartItem)));
                continue;
            }
            LongRect.add(longRect2, itemPainter.getItemBounds(chartItem, this.getChartContext(chartItem)));
        }
        this.invalidateImage(Utils.checkedRectangle(longRect2));
        this.repaintDirty();
    }

    protected static class Context
    implements ChartContext {
        private ChartComponent chart;

        public Context(ChartComponent chartComponent) {
            this.chart = chartComponent;
        }

        protected ChartComponent getChartComponent() {
            return this.chart;
        }

        public boolean isRightBased() {
            return this.chart.isRightBased();
        }

        public boolean isBottomBased() {
            return this.chart.isBottomBased();
        }

        public boolean fitsWidth() {
            return this.chart.fitsWidth();
        }

        public boolean fitsHeight() {
            return this.chart.fitsHeight();
        }

        public long getDataOffsetX() {
            return this.chart.getDataOffsetX();
        }

        public long getDataOffsetY() {
            return this.chart.getDataOffsetY();
        }

        public long getDataWidth() {
            return this.chart.getDataWidth();
        }

        public long getDataHeight() {
            return this.chart.getDataHeight();
        }

        public long getViewWidth() {
            return this.chart.getContentsWidth();
        }

        public long getViewHeight() {
            return this.chart.getContentsHeight();
        }

        public long getViewportOffsetX() {
            return 0L;
        }

        public long getViewportOffsetY() {
            return 0L;
        }

        public int getViewportWidth() {
            return this.chart.getWidth();
        }

        public int getViewportHeight() {
            return this.chart.getHeight();
        }

        public double getViewX(double d) {
            return this.chart.getViewX(d);
        }

        public double getReversedViewX(double d) {
            return this.chart.getReversedViewX(d);
        }

        public double getViewY(double d) {
            return this.chart.getViewY(d);
        }

        public double getReversedViewY(double d) {
            return this.chart.getReversedViewY(d);
        }

        public double getViewWidth(double d) {
            return this.chart.getViewWidth(d);
        }

        public double getViewHeight(double d) {
            return this.chart.getViewHeight(d);
        }

        public LongRect getViewRect(LongRect longRect) {
            return this.getViewRectImpl(longRect);
        }

        public double getDataX(double d) {
            return this.chart.getDataX(d);
        }

        public double getReversedDataX(double d) {
            return this.chart.getReversedDataX(d);
        }

        public double getDataY(double d) {
            return this.chart.getDataY(d);
        }

        public double getReversedDataY(double d) {
            return this.chart.getReversedDataY(d);
        }

        public double getDataWidth(double d) {
            return this.chart.getDataWidth(d);
        }

        public double getDataHeight(double d) {
            return this.chart.getDataHeight(d);
        }

        private LongRect getViewRectImpl(LongRect longRect) {
            LongRect longRect2 = new LongRect();
            longRect2.x = (long)Math.ceil(this.getViewX(longRect.x));
            longRect2.width = (long)Math.ceil(this.getViewWidth(longRect.width));
            if (this.isRightBased()) {
                longRect2.x -= longRect2.width;
            }
            longRect2.y = (long)Math.ceil(this.getViewY(longRect.y));
            longRect2.height = (long)Math.ceil(this.getViewHeight(longRect.height));
            if (this.isBottomBased()) {
                longRect2.y -= longRect2.height;
            }
            return longRect2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectionListener
    implements ChartSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void selectionModeChanged(int n, int n2) {
        }

        @Override
        public void selectionBoundsChanged(Rectangle rectangle, Rectangle rectangle2) {
        }

        @Override
        public void highlightedItemsChanged(List<ItemSelection> list, List<ItemSelection> list2, List<ItemSelection> list3) {
            this.refreshSelection(list2, list3);
        }

        @Override
        public void selectedItemsChanged(List<ItemSelection> list, List<ItemSelection> list2, List<ItemSelection> list3) {
            this.refreshSelection(list2, list3);
        }

        private void refreshSelection(List<ItemSelection> list, List<ItemSelection> list2) {
            ItemPainter itemPainter;
            ChartItem chartItem;
            Rectangle rectangle = new Rectangle();
            if (!list2.isEmpty() && list2.get(0) != null) {
                for (ItemSelection itemSelection : list2) {
                    chartItem = itemSelection.getItem();
                    itemPainter = ChartComponent.this.paintersModel.getPainter(chartItem);
                    if (!itemPainter.supportsHovering(chartItem)) continue;
                    if (rectangle.isEmpty()) {
                        rectangle.setBounds(Utils.checkedRectangle(itemPainter.getSelectionBounds(itemSelection, ChartComponent.this.getChartContext(chartItem))));
                        continue;
                    }
                    rectangle.add(Utils.checkedRectangle(itemPainter.getSelectionBounds(itemSelection, ChartComponent.this.getChartContext(chartItem))));
                }
            }
            if (!rectangle.isEmpty()) {
                ChartComponent.this.invalidateImage(rectangle);
                ChartComponent.this.paintImmediately(rectangle);
                rectangle = new Rectangle();
            }
            if (!list.isEmpty() && list.get(0) != null) {
                for (ItemSelection itemSelection : list) {
                    chartItem = itemSelection.getItem();
                    itemPainter = ChartComponent.this.paintersModel.getPainter(chartItem);
                    if (!itemPainter.supportsHovering(chartItem)) continue;
                    if (rectangle.isEmpty()) {
                        rectangle.setBounds(Utils.checkedRectangle(itemPainter.getSelectionBounds(itemSelection, ChartComponent.this.getChartContext(chartItem))));
                        continue;
                    }
                    rectangle.add(Utils.checkedRectangle(itemPainter.getSelectionBounds(itemSelection, ChartComponent.this.getChartContext(chartItem))));
                }
            }
            if (!rectangle.isEmpty()) {
                ChartComponent.this.invalidateImage(rectangle);
                ChartComponent.this.paintImmediately(rectangle);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PaintersModelListener
    implements PaintersListener {
        private PaintersModelListener() {
        }

        @Override
        public void paintersChanged() {
            ChartComponent.this.paintersChanged();
        }

        @Override
        public void paintersChanged(List<ItemPainter> list) {
            ChartComponent.this.paintersChanged(list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ItemsModelListener
    implements ItemsListener {
        private ItemsModelListener() {
        }

        @Override
        public void itemsAdded(List<ChartItem> list) {
            ChartComponent.this.itemsAdded(list);
        }

        @Override
        public void itemsRemoved(List<ChartItem> list) {
            ChartComponent.this.itemsRemoved(list);
        }

        @Override
        public void itemsChanged(List<ChartItemChange> list) {
            ChartComponent.this.itemsChanged(list);
        }
    }
}

