/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.AttributeMap;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.DayDateRange;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTaskHandleUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTask
extends AbstractTaskContainer
implements ITask {
    public static final String DEFAULT_TASK_KIND = "task";
    private String repositoryUrl;
    private String taskKind = "task";
    private final String taskId;
    private String owner;
    private boolean active = false;
    private String summary;
    private String priority = ITask.PriorityLevel.getDefault().toString();
    private boolean isNotifiedIncoming = false;
    private boolean reminded = false;
    private final Set<AbstractTaskContainer> containers = new HashSet<AbstractTaskContainer>();
    private String lastReadTimeStamp;
    private boolean synchronizing;
    private boolean submitting;
    private ITask.SynchronizationState synchronizationState = ITask.SynchronizationState.SYNCHRONIZED;
    private IStatus status = null;
    private boolean stale = false;
    private Date completionDate = null;
    private Date creationDate = null;
    private Date modificationDate = null;
    private DateRange scheduledForDate = null;
    private Date dueDate = null;
    private String notes = "";
    private int estimatedTimeHours = 1;
    private boolean markReadPending;
    protected String taskKey;
    private AttributeMap attributeMap;
    private boolean changed;

    public AbstractTask(String repositoryUrl, String taskId, String summary) {
        super(RepositoryTaskHandleUtil.getHandle(repositoryUrl, taskId));
        this.repositoryUrl = repositoryUrl;
        this.taskId = taskId;
        this.summary = summary;
    }

    @Override
    public final String getHandleIdentifier() {
        return super.getHandleIdentifier();
    }

    @Deprecated
    public abstract boolean isLocal();

    @Override
    public abstract String getConnectorKind();

    @Deprecated
    public String getLastReadTimeStamp() {
        return this.lastReadTimeStamp;
    }

    @Deprecated
    public void setLastReadTimeStamp(String lastReadTimeStamp) {
        this.lastReadTimeStamp = lastReadTimeStamp;
    }

    public void setSynchronizationState(ITask.SynchronizationState syncState) {
        Assert.isNotNull((Object)((Object)syncState));
        this.synchronizationState = syncState;
    }

    @Override
    public ITask.SynchronizationState getSynchronizationState() {
        return this.synchronizationState;
    }

    public boolean isSynchronizing() {
        return this.synchronizing;
    }

    public void setSynchronizing(boolean sychronizing) {
        this.synchronizing = sychronizing;
    }

    public boolean isNotified() {
        return this.isNotifiedIncoming;
    }

    public void setNotified(boolean notified) {
        this.isNotifiedIncoming = notified;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        if (!this.areEqual(this.owner, owner)) {
            String oldValue = this.owner;
            this.owner = owner;
            this.firePropertyChange("owner", oldValue, owner);
        }
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void setStatus(IStatus status) {
        this.status = status;
    }

    @Override
    public final String getTaskId() {
        return this.taskId;
    }

    @Override
    public final String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    @Override
    public final void setHandleIdentifier(String handleIdentifier) {
        throw new RuntimeException("Cannot set the handle identifier of a task, set repository URL instead.");
    }

    public final void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
        super.setHandleIdentifier(RepositoryTaskHandleUtil.getHandle(repositoryUrl, this.taskId));
    }

    @Override
    public String getTaskKey() {
        return this.taskKey == null ? this.taskId : this.taskKey;
    }

    @Deprecated
    public boolean isSubmitting() {
        return this.submitting;
    }

    @Deprecated
    public void setSubmitting(boolean submitting) {
        this.submitting = submitting;
    }

    @Override
    public String toString() {
        return this.summary;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AbstractTask) {
            return this.getHandleIdentifier().equals(((ITask)obj).getHandleIdentifier());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.taskId.hashCode();
    }

    @Override
    public boolean isCompleted() {
        return this.completionDate != null;
    }

    @Deprecated
    public void setCompleted(boolean completed) {
        this.completionDate = completed ? new Date() : null;
    }

    @Override
    public String getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(String priority) {
        if (!this.areEqual(this.priority, priority)) {
            String oldValue = this.priority;
            this.priority = priority;
            this.firePropertyChange("priority", oldValue, priority);
        }
    }

    public String getNotes() {
        if (this.notes == null) {
            this.notes = "";
        }
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Deprecated
    public int getEstimateTimeHours() {
        return this.getEstimatedTimeHours();
    }

    public int getEstimatedTimeHours() {
        return this.estimatedTimeHours;
    }

    public void setEstimatedTimeHours(int estimated) {
        this.estimatedTimeHours = estimated;
    }

    void addParentContainer(AbstractTaskContainer container) {
        this.containers.add(container);
    }

    void removeParentContainer(AbstractTaskContainer container) {
        this.containers.remove(container);
    }

    public Set<AbstractTaskContainer> getParentContainers() {
        return new HashSet<AbstractTaskContainer>(this.containers);
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public Date getCompletionDate() {
        return this.completionDate;
    }

    public void setScheduledForDate(DateRange reminderDate) {
        this.scheduledForDate = reminderDate;
    }

    public DateRange getScheduledForDate() {
        return this.scheduledForDate;
    }

    public boolean isReminded() {
        return this.reminded;
    }

    public void setReminded(boolean reminded) {
        this.reminded = reminded;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        if (!this.areEqual(this.creationDate, creationDate)) {
            Date oldValue = this.creationDate;
            this.creationDate = creationDate;
            this.firePropertyChange("creationDate", oldValue, creationDate);
        }
    }

    @Override
    public void setSummary(String summary) {
        Assert.isNotNull((Object)summary);
        if (!this.areEqual(this.summary, summary)) {
            String oldValue = this.summary;
            this.summary = summary;
            this.firePropertyChange("summary", oldValue, summary);
        }
    }

    @Override
    public void setCompletionDate(Date completionDate) {
        if (!this.areEqual(this.completionDate, completionDate)) {
            Date oldValue = this.completionDate;
            this.completionDate = completionDate;
            this.firePropertyChange("completionDate", oldValue, completionDate);
        }
    }

    private boolean areEqual(Object oldValue, Object newValue) {
        return oldValue != null ? oldValue.equals(newValue) : oldValue == newValue;
    }

    private void firePropertyChange(String key, Object oldValue, Object newValue) {
        this.changed = true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    @Deprecated
    public boolean isPastReminder() {
        if (this.isCompleted() || this.scheduledForDate == null || !(this.getScheduledForDate() instanceof DayDateRange)) {
            return false;
        }
        return this.scheduledForDate.getEndDate().compareTo(TaskActivityUtil.getCalendar()) < 0;
    }

    @Override
    public String getTaskKind() {
        return this.taskKind;
    }

    @Override
    public void setTaskKind(String taskKind) {
        if (!this.areEqual(this.taskKind, taskKind)) {
            String oldValue = this.taskKind;
            this.taskKind = taskKind;
            this.firePropertyChange("taskKind", oldValue, taskKind);
        }
    }

    @Override
    public int compareTo(IRepositoryElement taskListElement) {
        return this.summary.compareTo(((AbstractTask)taskListElement).summary);
    }

    @Override
    public Date getDueDate() {
        return this.dueDate;
    }

    @Override
    public void setDueDate(Date date) {
        if (!this.areEqual(this.dueDate, date)) {
            Date oldValue = this.dueDate;
            this.dueDate = date;
            this.firePropertyChange("dueDate", oldValue, date);
        }
    }

    @Deprecated
    public boolean isStale() {
        return this.stale;
    }

    @Deprecated
    public void setStale(boolean stale) {
        this.stale = stale;
    }

    @Override
    public Date getModificationDate() {
        return this.modificationDate;
    }

    @Override
    public void setModificationDate(Date modificationDate) {
        if (!this.areEqual(this.modificationDate, modificationDate)) {
            Date oldValue = this.modificationDate;
            this.modificationDate = modificationDate;
            this.firePropertyChange("modificationDate", oldValue, modificationDate);
        }
    }

    public boolean isMarkReadPending() {
        return this.markReadPending;
    }

    public void setMarkReadPending(boolean markReadPending) {
        this.markReadPending = markReadPending;
    }

    @Override
    public void setTaskKey(String taskKey) {
        if (!this.areEqual(this.taskKey, taskKey)) {
            String oldValue = this.taskKey;
            this.taskKey = taskKey;
            this.firePropertyChange("taskKey", oldValue, taskKey);
        }
    }

    @Override
    public synchronized String getAttribute(String key) {
        return this.attributeMap != null ? this.attributeMap.getAttribute(key) : null;
    }

    @Override
    public synchronized Map<String, String> getAttributes() {
        if (this.attributeMap != null) {
            return this.attributeMap.getAttributes();
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(String key, String value) {
        String oldValue;
        AbstractTask abstractTask = this;
        synchronized (abstractTask) {
            if (this.attributeMap == null) {
                this.attributeMap = new AttributeMap();
            }
            if (this.areEqual(oldValue = this.attributeMap.getAttribute(key), value)) {
                return;
            }
            this.attributeMap.setAttribute(key, value);
        }
        this.firePropertyChange(key, oldValue, value);
    }

    @Override
    public void setUrl(String url) {
        String oldValue = this.getUrl();
        if (!this.areEqual(oldValue, url)) {
            super.setUrl(url);
            this.firePropertyChange("url", oldValue, url);
        }
    }
}

