/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.client.config;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.netbeans.modules.mobility.end2end.classdata.AbstractService;
import org.netbeans.modules.mobility.end2end.classdata.ClassData;
import org.netbeans.modules.mobility.end2end.classdata.MethodData;
import org.netbeans.modules.mobility.end2end.classdata.OperationData;
import org.netbeans.modules.mobility.end2end.classdata.PortData;
import org.netbeans.modules.mobility.end2end.classdata.TypeData;
import org.netbeans.modules.mobility.end2end.classdata.WSDLService;
import org.netbeans.modules.mobility.end2end.client.config.ClassDescriptor;
import org.netbeans.modules.mobility.end2end.client.config.ClientConfiguration;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.mobility.end2end.client.config.ServerConfiguration;
import org.openide.ErrorManager;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationWriter {
    private static final String TYPE = "type";
    private static final String NAME = "name";

    private ConfigurationWriter() {
    }

    public static synchronized void write(OutputStream outputStream, Configuration configuration) throws Exception {
        Document document = XMLUtil.createDocument((String)"wsclientconfig", null, null, null);
        Element element = document.getDocumentElement();
        element.setAttribute("version", "1.0");
        String string = configuration.getServiceType();
        element.setAttribute("serviceType", string);
        element.appendChild(ConfigurationWriter.serializeClient(document, configuration.getClientConfiguration()));
        if (!"jsr-172".equals(configuration.getServiceType())) {
            element.appendChild(ConfigurationWriter.serializeServer(document, configuration.getServerConfigutation()));
        }
        element.appendChild(ConfigurationWriter.serializeServices(document, configuration.getServices(), string));
        try {
            XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private static Node serializeClient(Document document, ClientConfiguration clientConfiguration) {
        Element element = document.createElement("client");
        Element element2 = document.createElement("project");
        Text text = document.createTextNode(clientConfiguration.getProjectName());
        element2.appendChild(text);
        element.appendChild(element2);
        Element element3 = document.createElement("class");
        ClassDescriptor classDescriptor = clientConfiguration.getClassDescriptor();
        element3.setAttribute(TYPE, classDescriptor.getType());
        element3.setAttribute("location", classDescriptor.getLocation());
        element.appendChild(element3);
        Properties properties = clientConfiguration.getProperties();
        Set<Object> set = properties.keySet();
        for (String string : set) {
            String string2 = properties.getProperty(string);
            Element element4 = document.createElement("property");
            element4.setAttribute(NAME, string);
            element4.setAttribute("value", string2);
            element.appendChild(element4);
        }
        return element;
    }

    private static Node serializeServer(Document document, ServerConfiguration serverConfiguration) {
        Element element = document.createElement("server");
        Element element2 = document.createElement("project");
        element2.setAttribute("path", serverConfiguration.getProjectPath());
        Text text = document.createTextNode(serverConfiguration.getProjectName());
        element2.appendChild(text);
        element.appendChild(element2);
        Element element3 = document.createElement("class");
        ClassDescriptor classDescriptor = serverConfiguration.getClassDescriptor();
        element3.setAttribute(TYPE, classDescriptor.getType());
        element3.setAttribute("location", classDescriptor.getLocation());
        element3.setAttribute("mapping", classDescriptor.getMapping());
        element.appendChild(element3);
        Properties properties = serverConfiguration.getProperties();
        Set<Object> set = properties.keySet();
        for (String string : set) {
            String string2 = properties.getProperty(string);
            Element element4 = document.createElement("property");
            element4.setAttribute(NAME, string);
            element4.setAttribute("value", string2);
            element.appendChild(element4);
        }
        return element;
    }

    private static Node serializeServices(Document document, List<AbstractService> list, String string) {
        Element element = document.createElement("services");
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Element element2;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            List<ClassData> list2;
            AbstractService abstractService;
            Element element3 = document.createElement("service");
            if ("class".equals(string)) {
                abstractService = list.get(i);
                list2 = abstractService.getData();
                for (ClassData classData : list2) {
                    object9 = document.createElement("class");
                    object9.setAttribute(TYPE, classData.getType());
                    object8 = classData.getOperations();
                    object7 = object8.iterator();
                    while (object7.hasNext()) {
                        object6 = object7.next();
                        object5 = document.createElement("method");
                        object5.setAttribute(NAME, ((MethodData)object6).getName());
                        element2 = document.createElement("return");
                        element2.setAttribute(TYPE, ((MethodData)object6).getReturnType());
                        object5.appendChild(element2);
                        object4 = ((MethodData)object6).getParameterTypes();
                        object3 = object4.iterator();
                        while (object3.hasNext()) {
                            object2 = object3.next();
                            object = document.createElement("param");
                            object.setAttribute(NAME, ((TypeData)object2).getName());
                            object.setAttribute(TYPE, ((TypeData)object2).getType());
                            object5.appendChild((Node)object);
                        }
                        object9.appendChild((Node)object5);
                    }
                    element3.appendChild((Node)object9);
                }
                element.appendChild(element3);
                continue;
            }
            if ("wsdlClass".equals(string)) {
                abstractService = (WSDLService)list.get(i);
                element3.setAttribute("url", ((WSDLService)abstractService).getUrl());
                element3.setAttribute("file", ((WSDLService)abstractService).getFile());
                element3.setAttribute(NAME, ((WSDLService)abstractService).getName());
                element3.setAttribute(TYPE, ((WSDLService)abstractService).getType());
                list2 = abstractService.getData();
                for (ClassData classData : list2) {
                    object9 = (PortData)classData;
                    object8 = document.createElement("port");
                    object8.setAttribute(TYPE, ((ClassData)object9).getType());
                    object8.setAttribute(NAME, ((PortData)object9).getName());
                    object7 = ((ClassData)object9).getOperations();
                    object6 = object7.iterator();
                    while (object6.hasNext()) {
                        object5 = (OperationData)object6.next();
                        element2 = document.createElement("operation");
                        element2.setAttribute("method", ((OperationData)object5).getMethodName());
                        element2.setAttribute(NAME, ((MethodData)object5).getName());
                        object4 = document.createElement("return");
                        object4.setAttribute(TYPE, ((MethodData)object5).getReturnType());
                        element2.appendChild((Node)object4);
                        object3 = ((MethodData)object5).getParameterTypes();
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            object = (TypeData)object2.next();
                            Element element4 = document.createElement("param");
                            element4.setAttribute(NAME, ((TypeData)object).getName());
                            element4.setAttribute(TYPE, ((TypeData)object).getType());
                            element2.appendChild(element4);
                        }
                        object8.appendChild(element2);
                    }
                    element3.appendChild((Node)object8);
                }
                element.appendChild(element3);
                continue;
            }
            if (!"jsr-172".equals(string)) continue;
            abstractService = (WSDLService)list.get(i);
            element3.setAttribute("url", ((WSDLService)abstractService).getUrl());
            element3.setAttribute("file", ((WSDLService)abstractService).getFile());
            element.appendChild(element3);
        }
        return element;
    }
}

