/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.classdata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.e2e.classdata.FieldData;
import org.netbeans.modules.mobility.e2e.classdata.MethodData;
import org.netbeans.modules.mobility.e2e.classdata.MethodParameter;
import org.netbeans.modules.mobility.javon.JavonProfileProvider;
import org.netbeans.modules.mobility.javon.JavonSerializer;
import org.netbeans.modules.mobility.javon.Traversable;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDataRegistry {
    public static final String DEFAULT_PROFILE = "default";
    public static final String ALL_JAVA_PROFILE = "alljava";
    private List<ClasspathInfo> classpaths;
    private Set<ClassData> typeMap = null;
    private Map<String, ClassData> baseClasses = null;
    private Map<ClassData, Integer> idMapping = new HashMap<ClassData, Integer>();
    private JavonProfileProvider profileProvider;
    private static final Comparator<ClassData> inheritanceComparator = new Comparator<ClassData>(){

        @Override
        public int compare(ClassData classData, ClassData classData2) {
            if (classData.isArray() || classData2.isArray()) {
                return 0;
            }
            if (classData.isPrimitive() || classData2.isPrimitive()) {
                return 0;
            }
            if (classData.getParent().getFullyQualifiedName().equals(classData2.getFullyQualifiedName())) {
                return 1;
            }
            if (classData2.getParent().getFullyQualifiedName().equals(classData.getFullyQualifiedName())) {
                return -1;
            }
            return 0;
        }
    };

    public static JavonSerializer findSupportingSerializer(TypeMirror typeMirror, JavonProfileProvider javonProfileProvider, Traversable traversable, Map<String, ClassData> map) {
        for (JavonSerializer javonSerializer : javonProfileProvider.getSerializers()) {
            if (!javonSerializer.isTypeSupported(traversable, typeMirror, map)) continue;
            return javonSerializer;
        }
        return null;
    }

    public static ClassDataRegistry getRegistry(String string, List<ClasspathInfo> list) {
        return new ClassDataRegistry(string, list);
    }

    private ClassDataRegistry(String string, List<ClasspathInfo> list) {
        this.classpaths = list;
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(JavonProfileProvider.class));
        ArrayList arrayList = new ArrayList(result.allInstances());
        for (JavonProfileProvider javonProfileProvider : arrayList) {
            if (!string.equals(javonProfileProvider.getName())) continue;
            this.profileProvider = javonProfileProvider;
            break;
        }
        if (this.profileProvider == null) {
            return;
        }
    }

    public ClassData getClassData(String string) {
        if (this.baseClasses == null) {
            this.updateClassDataTree();
        }
        return this.baseClasses.get(string);
    }

    public Map<String, ClassData> getBaseClasses() {
        if (this.baseClasses == null) {
            this.updateClassDataTree();
        }
        return Collections.unmodifiableMap(this.baseClasses);
    }

    public Set<String> getBasePackages() {
        if (this.baseClasses == null) {
            this.updateClassDataTree();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (ClassData classData : this.baseClasses.values()) {
            String string = classData.getFullyQualifiedName();
            int n = string.lastIndexOf(46);
            hashSet.add(n > 0 ? string.substring(0, n) : "");
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public boolean isRegisteredType(ClassData classData) {
        if (this.typeMap == null) {
            this.updateClassDataTree();
        }
        return this.typeMap.contains(classData);
    }

    public Set<ClassData> getClassesForPackage(String string) {
        if (this.typeMap == null) {
            this.updateClassDataTree();
        }
        HashSet<ClassData> hashSet = new HashSet<ClassData>();
        for (ClassData classData : this.typeMap) {
            if (!classData.getPackage().equals(string)) continue;
            hashSet.add(classData);
        }
        return hashSet;
    }

    public Set<ClassData> getBaseClassesForPackage(String string) {
        if (this.baseClasses == null) {
            this.updateClassDataTree();
        }
        HashSet<ClassData> hashSet = new HashSet<ClassData>();
        int n = string.length() + 1;
        Set<String> set = this.baseClasses.keySet();
        for (String string2 : set) {
            if (!string2.startsWith(string) || string2.indexOf(46, n) >= 0) continue;
            hashSet.add(this.baseClasses.get(string2));
        }
        return hashSet;
    }

    public JavonSerializer getTypeSerializer(ClassData classData) {
        return classData.getSerializer();
    }

    public void updateClassDataTree() {
        if (this.typeMap == null) {
            this.typeMap = new HashSet<ClassData>();
        }
        if (this.baseClasses == null) {
            this.baseClasses = new HashMap<String, ClassData>();
        }
        int n = 1;
        for (ClasspathInfo classpathInfo : this.classpaths) {
            try {
                TraversingTask traversingTask = new TraversingTask(this.profileProvider, classpathInfo);
                JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]).runWhenScanFinished((Task)traversingTask, false).get();
                this.idMapping = new HashMap<ClassData, Integer>();
                for (ClassData classData : this.typeMap) {
                    this.idMapping.put(classData, n);
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Set<ClassData> getRegisteredTypes() {
        if (this.typeMap == null) {
            this.updateClassDataTree();
        }
        return Collections.unmodifiableSet(this.typeMap);
    }

    public Set<ClassData> getReturnTypes() {
        if (this.typeMap == null) {
            this.updateClassDataTree();
        }
        HashSet<ClassData> hashSet = new HashSet<ClassData>();
        for (ClassData classData : this.typeMap) {
            for (MethodData methodData : classData.getMethods()) {
                hashSet.add(methodData.getReturnType());
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Set<ClassData> getParameterTypes() {
        if (this.typeMap == null) {
            this.updateClassDataTree();
        }
        HashSet<ClassData> hashSet = new HashSet<ClassData>();
        for (ClassData classData : this.typeMap) {
            for (MethodData methodData : classData.getMethods()) {
                hashSet.addAll(methodData.getReturnType().getParameterTypes());
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public int getRegisteredTypeId(ClassData classData) {
        if (this.typeMap == null) {
            this.updateClassDataTree();
        }
        return this.idMapping.get(classData);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TraversingTask
    implements CancellableTask<CompilationController>,
    Traversable {
        private ClasspathInfo cpi;
        private JavonProfileProvider profileProvider;
        private static final int RETURN_TYPES = 1;
        private static final int PARAMETERS_TYPES = 2;
        private int status;

        public TraversingTask(JavonProfileProvider javonProfileProvider, ClasspathInfo classpathInfo) {
            this.profileProvider = javonProfileProvider;
            this.cpi = classpathInfo;
            if (ClassDataRegistry.this.typeMap == null) {
                ClassDataRegistry.this.typeMap = new HashSet();
            }
        }

        public void cancel() {
        }

        public void run(CompilationController compilationController) throws Exception {
            Set set = this.cpi.getClassIndex().getDeclaredTypes("", ClassIndex.NameKind.PREFIX, EnumSet.of(ClassIndex.SearchScope.SOURCE));
            for (ElementHandle elementHandle : set) {
                TypeElement typeElement = (TypeElement)elementHandle.resolve((CompilationInfo)compilationController);
                ClassData classData = null;
                if (typeElement != null) {
                    classData = this.getServiceType(typeElement.asType());
                }
                if (classData == null) continue;
                ClassDataRegistry.this.baseClasses.put(classData.getFullyQualifiedName(), classData);
            }
        }

        private ClassData getServiceType(TypeMirror typeMirror) {
            if (TypeKind.DECLARED == typeMirror.getKind()) {
                Object object;
                Object object2;
                TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                String string = typeElement.getQualifiedName().toString();
                string = string.length() == typeElement.getSimpleName().toString().length() ? "" : string.substring(0, string.lastIndexOf(46));
                JavonSerializer javonSerializer = ClassDataRegistry.findSupportingSerializer(typeMirror, this.profileProvider, this, new HashMap<String, ClassData>());
                ArrayList<MethodData> arrayList = new ArrayList<MethodData>(0);
                ArrayList<MethodData> arrayList2 = new ArrayList<MethodData>(0);
                for (ExecutableElement object32 : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                    boolean variableElement;
                    if (!object32.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                    boolean hashMap = true;
                    object2 = new HashMap<String, ClassData>();
                    object = this.traverseType(object32.getReturnType(), (Map<String, ClassData>)object2);
                    if (object != null) {
                        ClassDataRegistry.this.typeMap.add(object);
                        variableElement = true;
                    } else {
                        variableElement = false;
                    }
                    ArrayList<MethodParameter> arrayList3 = new ArrayList<MethodParameter>();
                    ArrayList<MethodParameter> arrayList4 = new ArrayList<MethodParameter>();
                    for (VariableElement variableElement2 : object32.getParameters()) {
                        object2 = new HashMap<String, ClassData>();
                        ClassData classData = this.traverseType(variableElement2.asType(), (Map<String, ClassData>)object2);
                        if (classData != null) {
                            ClassDataRegistry.this.typeMap.add(classData);
                            arrayList3.add(new MethodParameter(variableElement2.getSimpleName().toString(), classData));
                            hashMap = true;
                            continue;
                        }
                        hashMap = false;
                        arrayList4.add(new MethodParameter(variableElement2.getSimpleName().toString(), ((Object)variableElement2.asType()).toString()));
                    }
                    if (variableElement && hashMap) {
                        arrayList.add(new MethodData(typeElement.getQualifiedName().toString(), object32.getSimpleName().toString(), (ClassData)object, arrayList3));
                        continue;
                    }
                    arrayList2.add(new MethodData(typeElement.getQualifiedName().toString(), object32.getSimpleName().toString(), ((Object)object32.getReturnType()).toString(), arrayList3, variableElement, arrayList4));
                }
                if (arrayList.size() == 0) {
                    return null;
                }
                ArrayList arrayList5 = new ArrayList(0);
                for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
                    HashMap<String, ClassData> hashMap = new HashMap<String, ClassData>();
                    object2 = this.traverseType(variableElement.asType(), hashMap);
                    if (object2 == null) continue;
                    object = new FieldData(((ClassData)object2).getName(), (ClassData)object2);
                    if (variableElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                        ((FieldData)object).setModifier(ClassData.Modifier.PUBLIC);
                    }
                    if (variableElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
                        ((FieldData)object).setModifier(ClassData.Modifier.PRIVATE);
                    }
                    arrayList5.add(object);
                }
                ClassData classData = new ClassData(string, typeElement.getSimpleName().toString(), false, (List<FieldData>)arrayList5, arrayList, javonSerializer, arrayList2);
                return classData;
            }
            return null;
        }

        @Override
        public ClassData traverseType(TypeMirror typeMirror, Map<String, ClassData> map) {
            for (JavonSerializer javonSerializer : this.profileProvider.getSerializers()) {
                if (!javonSerializer.isTypeSupported(this, typeMirror, map)) continue;
                ClassData classData = javonSerializer.getType(this, typeMirror, map);
                return classData;
            }
            return null;
        }

        @Override
        public boolean isTypeSupported(TypeMirror typeMirror, Map<String, ClassData> map) {
            return ClassDataRegistry.findSupportingSerializer(typeMirror, this.profileProvider, this, map) != null;
        }

        @Override
        public JavonSerializer registerType(ClassData classData) {
            if (classData.getSerializer() == null) {
                return null;
            }
            ClassDataRegistry.this.typeMap.add(classData);
            return classData.getSerializer();
        }

        private String displayClassData(ClassData classData) {
            StringBuffer stringBuffer = new StringBuffer(classData.getFullyQualifiedName() + "\n\n");
            for (FieldData object : classData.getFields()) {
                stringBuffer.append((Object)((Object)object.getModifier()) + " " + object.getType() + " " + object.getName() + "\n");
            }
            stringBuffer.append("\n");
            for (MethodData methodData : classData.getMethods()) {
                stringBuffer.append(methodData.getReturnType() + " " + methodData.getName() + "(");
                int n = 0;
                for (MethodParameter methodParameter : methodData.getParameters()) {
                    stringBuffer.append(methodParameter.getType().getFullyQualifiedName() + " " + methodParameter.getName());
                    if (n < methodData.getParameters().size() - 1) {
                        stringBuffer.append(",");
                    } else {
                        stringBuffer.append(")\n");
                    }
                    ++n;
                }
            }
            return stringBuffer.toString();
        }
    }
}

