/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataUtil;
import org.netbeans.modules.dlight.indicators.DataRowToTimeSeries;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultDataRowToTimeSeries
implements DataRowToTimeSeries {
    private final int dataLength;
    private final Map<String, Integer> columnToIndex;

    public DefaultDataRowToTimeSeries(DataTableMetadata.Column[][] columnArray) {
        this.dataLength = columnArray.length;
        this.columnToIndex = Collections.unmodifiableMap(DefaultDataRowToTimeSeries.buildColumnToIndexMap(columnArray));
    }

    @Override
    public float[] getData(DataRow dataRow) {
        float[] fArray = null;
        for (String string : dataRow.getColumnNames()) {
            Integer n = this.columnToIndex.get(string);
            if (n == null) continue;
            if (fArray == null) {
                fArray = new float[this.dataLength];
            }
            fArray[n.intValue()] = DataUtil.toFloat((Object)dataRow.getData(string));
        }
        return fArray;
    }

    @Override
    public Map<String, String> getDetails() {
        return Collections.emptyMap();
    }

    private static Map<String, Integer> buildColumnToIndexMap(DataTableMetadata.Column[][] columnArray) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < columnArray.length; ++i) {
            for (DataTableMetadata.Column column : columnArray[i]) {
                hashMap.put(column.getColumnName(), i);
            }
        }
        return hashMap;
    }
}

