/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.indicators.Aggregation;
import org.netbeans.modules.dlight.indicators.DataRowToTimeSeries;
import org.netbeans.modules.dlight.indicators.DetailDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.graph.TimeSeriesIndicatorConfigurationAccessor;
import org.netbeans.modules.dlight.util.ValueFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeSeriesIndicatorConfiguration
extends IndicatorConfiguration {
    private String title = "";
    private int scale = 100;
    private final List<TimeSeriesDescriptor> seriesDescriptors = new ArrayList<TimeSeriesDescriptor>();
    private final List<DetailDescriptor> detailDescriptors = new ArrayList<DetailDescriptor>();
    private DataRowToTimeSeries dataRowHandler;
    private long granularity = 1000000000L;
    private Aggregation aggr = Aggregation.LAST;
    private ValueFormatter formatter;
    private boolean lastNonNull = true;

    public TimeSeriesIndicatorConfiguration(IndicatorMetadata indicatorMetadata, int n) {
        super(indicatorMetadata, n, true);
    }

    public String getID() {
        return "DLightTimeSeriesIndicatorConfigurationID";
    }

    public void setTitle(String string) {
        this.title = string;
    }

    private String getTitle() {
        return this.title;
    }

    public void setGraphScale(int n) {
        this.scale = n;
    }

    private int getGraphScale() {
        return this.scale;
    }

    public void addTimeSeriesDescriptors(TimeSeriesDescriptor ... timeSeriesDescriptorArray) {
        this.seriesDescriptors.addAll(Arrays.asList(timeSeriesDescriptorArray));
    }

    private List<TimeSeriesDescriptor> getTimeSeriesDescriptors() {
        return Collections.unmodifiableList(this.seriesDescriptors);
    }

    public void addDetailDescriptors(DetailDescriptor ... detailDescriptorArray) {
        this.detailDescriptors.addAll(Arrays.asList(detailDescriptorArray));
    }

    private List<DetailDescriptor> getDetailDescriptors() {
        return Collections.unmodifiableList(this.detailDescriptors);
    }

    public void setDataRowHandler(DataRowToTimeSeries dataRowToTimeSeries) {
        this.dataRowHandler = dataRowToTimeSeries;
    }

    private DataRowToTimeSeries getDataRowHandler() {
        return this.dataRowHandler;
    }

    public void setLabelFormatter(ValueFormatter valueFormatter) {
        this.formatter = valueFormatter;
    }

    private ValueFormatter getLabelRenderer() {
        return this.formatter;
    }

    public void setAggregation(Aggregation aggregation) {
        this.aggr = aggregation;
    }

    private Aggregation getAggregation() {
        return this.aggr;
    }

    public void setGranularity(long l) {
        this.granularity = l;
    }

    private long getGranularity() {
        return this.granularity;
    }

    public void setLastNonNull(boolean bl) {
        this.lastNonNull = bl;
    }

    private boolean getLastNonNull() {
        return this.lastNonNull;
    }

    static {
        TimeSeriesIndicatorConfigurationAccessor.setDefault(new TimeSeriesIndicatorConfigurationAccessorImpl());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TimeSeriesIndicatorConfigurationAccessorImpl
    extends TimeSeriesIndicatorConfigurationAccessor {
        private TimeSeriesIndicatorConfigurationAccessorImpl() {
        }

        @Override
        public String getTitle(TimeSeriesIndicatorConfiguration timeSeriesIndicatorConfiguration) {
            return timeSeriesIndicatorConfiguration.getTitle();
        }

        @Override
        public int getGraphScale(TimeSeriesIndicatorConfiguration timeSeriesIndicatorConfiguration) {
            return timeSeriesIndicatorConfiguration.getGraphScale();
        }

        @Override
        public List<TimeSeriesDescriptor> getTimeSeriesDescriptors(TimeSeriesIndicatorConfiguration timeSeriesIndicatorConfiguration) {
            return timeSeriesIndicatorConfiguration.getTimeSeriesDescriptors();
        }

        @Override
        public List<DetailDescriptor> getDetailDescriptors(TimeSeriesIndicatorConfiguration timeSeriesIndicatorConfiguration) {
            return timeSeriesIndicatorConfiguration.getDetailDescriptors();
        }

        @Override
        public DataRowToTimeSeries getDataRowHandler(TimeSeriesIndicatorConfiguration timeSeriesIndicatorConfiguration) {
            return timeSeriesIndicatorConfiguration.getDataRowHandler();
        }

        @Override
        public ValueFormatter getLabelRenderer(TimeSeriesIndicatorConfiguration timeSeriesIndicatorConfiguration) {
            return timeSeriesIndicatorConfiguration.getLabelRenderer();
        }

        @Override
        public long getGranularity(TimeSeriesIndicatorConfiguration timeSeriesIndicatorConfiguration) {
            return timeSeriesIndicatorConfiguration.getGranularity();
        }

        @Override
        public Aggregation getAggregation(TimeSeriesIndicatorConfiguration timeSeriesIndicatorConfiguration) {
            return timeSeriesIndicatorConfiguration.getAggregation();
        }

        @Override
        public boolean getLastNonNull(TimeSeriesIndicatorConfiguration timeSeriesIndicatorConfiguration) {
            return timeSeriesIndicatorConfiguration.getLastNonNull();
        }
    }
}

