/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.JarClassLoader;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.ProxyClassLoader;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StandardModule
extends Module {
    private final File jar;
    private File physicalJar = null;
    private Manifest manifest;
    private static final Map<File, Set<File>> extensionOwners = new HashMap<File, Set<File>>();
    private static final Set<File> moduleJARs = new HashSet<File>();
    private Set<File> localeVariants = null;
    private Set<File> plainExtensions = null;
    private Set<File> localeExtensions = null;
    private Set<File> patches = null;
    private Properties localizedProps;
    private transient boolean released;
    private transient int releaseCount = 0;
    private static PermissionCollection modulePermissions;

    public StandardModule(ModuleManager moduleManager, Events events, File file, Object object, boolean bl, boolean bl2, boolean bl3) throws IOException {
        super(moduleManager, events, object, bl, bl2, bl3);
        this.jar = file;
        this.loadManifest();
        this.parseManifest();
        this.findExtensionsAndVariants(this.manifest);
        Set<File> set = extensionOwners.get(file);
        if (set != null) {
            Util.err.warning("module " + file + " was incorrectly placed in the Class-Path of other JARs " + set + "; please use OpenIDE-Module-Module-Dependencies instead");
        }
        moduleJARs.add(file);
    }

    @Override
    public Manifest getManifest() {
        if (this.manifest == null) {
            try {
                this.loadManifest();
            }
            catch (IOException iOException) {
                Util.err.log(Level.WARNING, "While loading manifest for " + (Object)((Object)this), iOException);
                this.manifest = new Manifest();
            }
        }
        return this.manifest;
    }

    @Override
    public void releaseManifest() {
        this.manifest = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLocalizedAttribute(String string) {
        int n;
        String string2;
        Object object;
        String string3 = this.getManifest().getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
        boolean bl = false;
        if (string3 != null) {
            Object object2;
            if (this.classloader != null) {
                if (string3.endsWith(".properties")) {
                    bl = true;
                    object2 = string3.substring(0, string3.length() - 11).replace('/', '.');
                    try {
                        object = NbBundle.getBundle((String)object2, (Locale)Locale.getDefault(), (ClassLoader)this.classloader);
                        try {
                            return ((ResourceBundle)object).getString(string);
                        }
                        catch (MissingResourceException missingResourceException) {
                        }
                    }
                    catch (MissingResourceException missingResourceException) {
                        string2 = ((String)object2).replace('.', '/') + ".properties";
                        Exceptions.attachMessage((Throwable)missingResourceException, (String)("#149833: failed to find " + (String)object2 + " in locale " + Locale.getDefault() + " in " + this.classloader + " for " + this.jar + "; resource lookup of " + string2 + " -> " + this.classloader.getResource(string2)));
                        Exceptions.printStackTrace((Throwable)missingResourceException);
                    }
                } else {
                    Util.err.warning("cannot efficiently load non-*.properties OpenIDE-Module-Localizing-Bundle: " + string3);
                }
            }
            if (!bl) {
                block19: {
                    if (this.localizedProps == null) {
                        Util.err.log(Level.FINE, "Trying to get localized attr {0} from disabled module {1}", new Object[]{string, this.getCodeNameBase()});
                        try {
                            if (this.jar != null && this.jar.isFile()) {
                                object2 = new JarFile(this.jar, false);
                                try {
                                    this.loadLocalizedProps((JarFile)object2, this.getManifest());
                                    break block19;
                                }
                                finally {
                                    ((ZipFile)object2).close();
                                }
                            }
                            Util.err.log(Level.FINE, "Cannot get localized attr {0} from module {1} (missing or deleted JAR file: {2})", new Object[]{string, this.getCodeNameBase(), this.jar});
                        }
                        catch (IOException iOException) {
                            Util.err.log(Level.WARNING, this.jar.getAbsolutePath(), iOException);
                        }
                    }
                }
                if (this.localizedProps != null && (object2 = this.localizedProps.getProperty(string)) != null) {
                    return object2;
                }
            }
        }
        if ((n = string.lastIndexOf(47)) == -1) {
            return NbBundle.getLocalizedValue((Attributes)this.getManifest().getMainAttributes(), (Attributes.Name)new Attributes.Name(string));
        }
        object = string.substring(0, n);
        string2 = string.substring(n + 1);
        Attributes attributes = this.getManifest().getAttributes((String)object);
        if (attributes != null) {
            return NbBundle.getLocalizedValue((Attributes)attributes, (Attributes.Name)new Attributes.Name(string2));
        }
        return null;
    }

    @Override
    public boolean isFixed() {
        return false;
    }

    @Override
    public File getJarFile() {
        return this.jar;
    }

    private void ensurePhysicalJar() throws IOException {
        if (this.reloadable && this.physicalJar == null) {
            this.physicalJar = Util.makeTempJar(this.jar);
        }
    }

    private void destroyPhysicalJar() {
        if (this.physicalJar != null) {
            if (this.physicalJar.isFile()) {
                if (!this.physicalJar.delete()) {
                    Util.err.warning("temporary JAR " + this.physicalJar + " not currently deletable.");
                } else {
                    Util.err.fine("deleted: " + this.physicalJar);
                }
            }
            this.physicalJar = null;
        } else {
            Util.err.fine("no physicalJar to delete for " + (Object)((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManifest() throws IOException {
        block8: {
            Util.err.fine("loading manifest of " + this.jar);
            File file = null;
            try {
                if (this.reloadable) {
                    file = this.physicalJar;
                    this.ensurePhysicalJar();
                    file = this.physicalJar;
                    JarFile jarFile = new JarFile(this.physicalJar, false);
                    try {
                        Manifest manifest = jarFile.getManifest();
                        if (manifest == null) {
                            throw new IOException("No manifest found in " + this.physicalJar);
                        }
                        this.manifest = manifest;
                        break block8;
                    }
                    finally {
                        jarFile.close();
                    }
                }
                file = this.jar;
                this.manifest = this.getManager().loadManifest(this.jar);
            }
            catch (IOException iOException) {
                if (file != null) {
                    Exceptions.attachMessage((Throwable)iOException, (String)("While loading manifest from: " + file));
                }
                throw iOException;
            }
        }
    }

    private void findExtensionsAndVariants(Manifest manifest) {
        Iterator<File> iterator;
        String string;
        Object object2;
        assert (this.jar != null) : "Cannot load extensions from classpath module " + this.getCodeNameBase();
        this.localeVariants = null;
        List<File> list = Util.findLocaleVariantsOf(this.jar);
        if (!list.isEmpty()) {
            this.localeVariants = new HashSet<File>(list);
        }
        this.plainExtensions = null;
        this.localeExtensions = null;
        String string2 = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (string2 != null) {
            object2 = new StringTokenizer(string2);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                Set<File> set;
                string = ((StringTokenizer)object2).nextToken();
                if (new File(string).isAbsolute() || string.indexOf("../") != -1) {
                    Util.err.warning("Class-Path value " + string + " from " + this.jar + " is illegal according to the Java Extension Mechanism: must be relative and not move up directories");
                }
                if ((set = extensionOwners.get(iterator = new File(this.jar.getParentFile(), string.replace('/', File.separatorChar)))) == null) {
                    HashSet<File> hashSet = new HashSet<File>(2);
                    hashSet.add(this.jar);
                    extensionOwners.put((File)((Object)iterator), (Set<File>)hashSet);
                } else if (!set.contains(this.jar)) {
                    set.add(this.jar);
                    this.events.log("extensionMultiplyLoaded", iterator, set);
                }
                if (moduleJARs.contains(iterator)) {
                    Util.err.warning("Class-Path value " + string + " from " + this.jar + " illegally refers to another module; use OpenIDE-Module-Module-Dependencies instead");
                }
                if (this.plainExtensions == null) {
                    this.plainExtensions = new HashSet<File>();
                }
                this.plainExtensions.add((File)((Object)iterator));
                list = Util.findLocaleVariantsOf(iterator);
                if (list.isEmpty()) continue;
                if (this.localeExtensions == null) {
                    this.localeExtensions = new HashSet<File>();
                }
                this.localeExtensions.addAll(list);
            }
        }
        object2 = new File(new File(this.jar.getParentFile(), "patches"), this.getCodeNameBase().replace('.', '-'));
        this.scanForPatches((File)object2);
        string = System.getProperty("netbeans.patches." + this.getCodeNameBase());
        if (string != null) {
            iterator = new StringTokenizer(string, File.pathSeparator);
            while (((StringTokenizer)((Object)iterator)).hasMoreTokens()) {
                String string3 = ((StringTokenizer)((Object)iterator)).nextToken();
                File file = new File(string3);
                if (!file.exists()) continue;
                if (this.patches == null) {
                    this.patches = new HashSet<File>(15);
                }
                this.patches.add(file);
            }
        }
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.fine("localeVariants of " + this.jar + ": " + this.localeVariants);
            Util.err.fine("plainExtensions of " + this.jar + ": " + this.plainExtensions);
            Util.err.fine("localeExtensions of " + this.jar + ": " + this.localeExtensions);
            Util.err.fine("patches of " + this.jar + ": " + this.patches);
        }
        if (this.patches != null) {
            for (File file : this.patches) {
                this.events.log("patch", file);
            }
        }
    }

    private void scanForPatches(File file) {
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles(Util.jarFilter());
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (this.patches == null) {
                    this.patches = new HashSet<File>(5);
                }
                this.patches.add(file2);
            }
        } else {
            Util.err.warning("Could not search for patches in " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalizedProps(JarFile jarFile, Manifest manifest) throws IOException {
        String string = manifest.getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
        if (string != null) {
            String string2;
            int n;
            Object object;
            ZipEntry zipEntry = jarFile.getEntry(string);
            if (zipEntry != null) {
                this.localizedProps = new Properties();
                object = jarFile.getInputStream(zipEntry);
                try {
                    this.localizedProps.load((InputStream)object);
                }
                finally {
                    ((InputStream)object).close();
                }
            }
            if ((n = string.lastIndexOf(46)) == -1) {
                object = string;
                string2 = "";
            } else {
                object = string.substring(0, n);
                string2 = string.substring(n);
            }
            List<Util.FileWithSuffix> list = Util.findLocaleVariantsWithSuffixesOf(this.jar);
            Collections.reverse(list);
            for (Util.FileWithSuffix fileWithSuffix : list) {
                File file = fileWithSuffix.file;
                String string3 = fileWithSuffix.suffix;
                String string4 = (String)object + string3 + string2;
                JarFile jarFile2 = new JarFile(file, false);
                try {
                    ZipEntry zipEntry2 = jarFile2.getEntry(string4);
                    if (zipEntry2 == null) continue;
                    if (this.localizedProps == null) {
                        this.localizedProps = new Properties();
                    }
                    InputStream inputStream = jarFile2.getInputStream(zipEntry2);
                    try {
                        this.localizedProps.load(inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                finally {
                    jarFile2.close();
                }
            }
            if (this.localizedProps == null) {
                throw new IOException("Could not find localizing bundle: " + string);
            }
        }
    }

    @Override
    public List<File> getAllJars() {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.patches != null) {
            arrayList.addAll(this.patches);
        }
        if (this.physicalJar != null) {
            arrayList.add(this.physicalJar);
        } else if (this.jar != null) {
            arrayList.add(this.jar);
        }
        if (this.plainExtensions != null) {
            arrayList.addAll(this.plainExtensions);
        }
        if (this.localeVariants != null) {
            arrayList.addAll(this.localeVariants);
        }
        if (this.localeExtensions != null) {
            arrayList.addAll(this.localeExtensions);
        }
        return arrayList;
    }

    @Override
    public void setReloadable(boolean bl) {
        this.getManager().assertWritable();
        if (this.reloadable != bl) {
            this.reloadable = bl;
            this.getManager().fireReloadable(this);
        }
    }

    @Override
    public void reload() throws IOException {
        this.destroyPhysicalJar();
        String string = this.getCodeNameBase();
        this.localizedProps = null;
        this.loadManifest();
        this.parseManifest();
        this.findExtensionsAndVariants(this.manifest);
        String string2 = this.getCodeNameBase();
        if (!string.equals(string2)) {
            throw new InvalidException("Code name base changed during reload: " + string + " -> " + string2);
        }
    }

    @Override
    protected void classLoaderUp(Set<Module> set) throws IOException {
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.fine("classLoaderUp on " + (Object)((Object)this) + " with parents " + set);
        }
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(set.size() + 1);
        arrayList.add(Module.class.getClassLoader());
        for (Module module : set) {
            Module.PackageExport[] packageExportArray = module.getPublicPackages();
            if (packageExportArray != null && packageExportArray.length == 0) {
                boolean bl = false;
                for (Dependency dependency : this.getDependenciesArray()) {
                    if (dependency.getType() != 1 || dependency.getComparison() != 2 || !dependency.getName().equals(module.getCodeName())) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
            }
            ClassLoader classLoader = module.getClassLoader();
            if (module.isFixed() && arrayList.contains(classLoader)) {
                Util.err.log(Level.FINE, "#24996: skipping duplicate classloader from {0}", (Object)module);
                continue;
            }
            arrayList.add(classLoader);
        }
        ArrayList arrayList2 = new ArrayList(3);
        if (this.patches != null) {
            arrayList2.addAll(this.patches);
        }
        if (this.reloadable) {
            this.ensurePhysicalJar();
            arrayList2.add(this.physicalJar);
        } else {
            arrayList2.add(this.jar);
        }
        if (this.localeVariants != null) {
            arrayList2.addAll(this.localeVariants);
        }
        if (this.localeExtensions != null) {
            arrayList2.addAll(this.localeExtensions);
        }
        if (this.plainExtensions != null) {
            arrayList2.addAll(this.plainExtensions);
        }
        this.getManager().refineClassLoader(this, arrayList);
        try {
            this.classloader = new OneModuleClassLoader(arrayList2, arrayList.toArray(new ClassLoader[arrayList.size()]));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (IOException)new IOException(illegalArgumentException.toString()).initCause(illegalArgumentException);
        }
    }

    @Override
    protected void classLoaderDown() {
        if (this.classloader instanceof ProxyClassLoader) {
            ((ProxyClassLoader)this.classloader).destroy();
        }
        this.classloader = null;
        Util.err.fine("classLoaderDown on " + (Object)((Object)this) + ": releaseCount=" + this.releaseCount + " released=" + this.released);
        this.released = false;
    }

    @Override
    protected void cleanup() {
        if (this.isEnabled()) {
            throw new IllegalStateException("cleanup on enabled module: " + (Object)((Object)this));
        }
        if (this.classloader != null) {
            throw new IllegalStateException("cleanup on module with classloader: " + (Object)((Object)this));
        }
        if (!this.released) {
            Util.err.fine("Warning: not all resources associated with module " + this.jar + " were successfully released.");
            this.released = true;
        } else {
            Util.err.fine("All resources associated with module " + this.jar + " were successfully released.");
        }
        this.destroyPhysicalJar();
    }

    @Override
    public void destroy() {
        moduleJARs.remove(this.jar);
    }

    @Override
    public String toString() {
        String string = "StandardModule:" + this.getCodeNameBase() + " jarFile: " + this.jar.getAbsolutePath();
        if (!this.isValid()) {
            string = string + "[invalid]";
        }
        return string;
    }

    private static synchronized PermissionCollection getAllPermission() {
        if (modulePermissions == null) {
            modulePermissions = new Permissions();
            modulePermissions.add(new AllPermission());
            modulePermissions.setReadOnly();
        }
        return modulePermissions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OneModuleClassLoader
    extends JarClassLoader
    implements Util.ModuleProvider {
        private int rc;

        public OneModuleClassLoader(List<File> list, ClassLoader[] classLoaderArray) throws IllegalArgumentException {
            super(list, classLoaderArray, false, StandardModule.this);
            this.rc = StandardModule.this.releaseCount++;
        }

        @Override
        public Module getModule() {
            return StandardModule.this;
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codeSource) {
            return StandardModule.getAllPermission();
        }

        @Override
        protected String findLibrary(String string) {
            String string2 = System.mapLibraryName(string);
            File file = new File(new File(StandardModule.this.jar.getParentFile(), "lib"), string2);
            if (file.isFile()) {
                return file.getAbsolutePath();
            }
            return null;
        }

        @Override
        protected boolean shouldDelegateResource(String string, ClassLoader classLoader) {
            if (!super.shouldDelegateResource(string, classLoader)) {
                return false;
            }
            Module module = classLoader instanceof Util.ModuleProvider ? ((Util.ModuleProvider)((Object)classLoader)).getModule() : null;
            return StandardModule.this.getManager().shouldDelegateResource(StandardModule.this, module, string);
        }

        public String toString() {
            return "ModuleCL@" + Integer.toHexString(System.identityHashCode(this)) + "[" + StandardModule.this.getCodeNameBase() + "]";
        }

        protected void finalize() throws Throwable {
            super.finalize();
            Util.err.fine("Finalize for " + this + ": rc=" + this.rc + " releaseCount=" + StandardModule.this.releaseCount + " released=" + StandardModule.this.released);
            if (this.rc == StandardModule.this.releaseCount) {
                StandardModule.this.released = true;
            } else {
                Util.err.fine("Now resources for " + StandardModule.this.getCodeNameBase() + " have been released.");
            }
        }
    }
}

