/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.xref;

import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CsmReferenceResolver {
    private static final CsmReferenceResolver DEFAULT = new Default();

    protected CsmReferenceResolver() {
    }

    public static CsmReferenceResolver getDefault() {
        return DEFAULT;
    }

    public abstract CsmReference findReference(CsmFile var1, int var2);

    public CsmReference findReference(Node node) {
        JEditorPane jEditorPane;
        assert (node != null) : "activatedNode must be not null";
        EditorCookie editorCookie = (EditorCookie)node.getCookie(EditorCookie.class);
        if (editorCookie != null && (jEditorPane = CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)editorCookie)) != null) {
            int n = jEditorPane.getSelectionStart();
            CsmFile csmFile = CsmUtilities.getCsmFile((Node)node, (boolean)false);
            if (csmFile != null) {
                return this.findReference(csmFile, n);
            }
        }
        return null;
    }

    public CsmReference findReference(Document document, int n) {
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)document, (boolean)false);
        if (csmFile != null) {
            return this.findReference(csmFile, n);
        }
        return null;
    }

    public abstract Scope fastCheckScope(CsmReference var1);

    public abstract boolean isKindOf(CsmReference var1, Set<CsmReferenceKind> var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Default
    extends CsmReferenceResolver {
        private final Lookup.Result<CsmReferenceResolver> res = Lookup.getDefault().lookupResult(CsmReferenceResolver.class);

        Default() {
        }

        @Override
        public CsmReference findReference(CsmFile csmFile, int n) {
            for (CsmReferenceResolver csmReferenceResolver : this.res.allInstances()) {
                CsmReference csmReference = csmReferenceResolver.findReference(csmFile, n);
                if (csmReference == null) continue;
                return csmReference;
            }
            return null;
        }

        @Override
        public CsmReference findReference(Node node) {
            for (CsmReferenceResolver csmReferenceResolver : this.res.allInstances()) {
                CsmReference csmReference = csmReferenceResolver.findReference(node);
                if (csmReference == null) continue;
                return csmReference;
            }
            return null;
        }

        @Override
        public CsmReference findReference(Document document, int n) {
            for (CsmReferenceResolver csmReferenceResolver : this.res.allInstances()) {
                CsmReference csmReference = csmReferenceResolver.findReference(document, n);
                if (csmReference == null) continue;
                return csmReference;
            }
            return null;
        }

        @Override
        public Scope fastCheckScope(CsmReference csmReference) {
            for (CsmReferenceResolver csmReferenceResolver : this.res.allInstances()) {
                Scope scope = csmReferenceResolver.fastCheckScope(csmReference);
                if (scope == Scope.UNKNOWN) continue;
                return scope;
            }
            return Scope.UNKNOWN;
        }

        @Override
        public boolean isKindOf(CsmReference csmReference, Set<CsmReferenceKind> set) {
            for (CsmReferenceResolver csmReferenceResolver : this.res.allInstances()) {
                if (!csmReferenceResolver.isKindOf(csmReference, set)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Scope {
        LOCAL,
        FILE_LOCAL,
        GLOBAL,
        UNKNOWN;

    }
}

