/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.syntaxerr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.modelutil.NamedEntity;
import org.netbeans.modules.cnd.modelutil.NamedEntityOptions;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CsmErrorProvider
implements NamedEntity {
    private static final boolean ENABLE = CndUtils.getBoolean((String)"cnd.csm.errors", (boolean)true);
    private static final boolean ASYNC = CndUtils.getBoolean((String)"cnd.csm.errors.async", (boolean)true);
    private static CsmErrorProvider DEFAULT = ASYNC ? new AsynchronousMerger() : new SynchronousMerger();

    public final void getErrors(Request request, Response response) {
        if (this.validate(request)) {
            this.doGetErrors(request, response);
        }
        response.done();
    }

    protected boolean validate(Request request) {
        return NamedEntityOptions.instance().isEnabled((NamedEntity)this) && !request.isCancelled();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    protected abstract void doGetErrors(Request var1, Response var2);

    public static boolean disableAsLibraryHeaderFile(CsmFile csmFile) {
        return CndUtils.isReleaseMode() && csmFile != null && csmFile.isHeaderFile() && csmFile.getProject() != null && csmFile.getProject().isArtificial();
    }

    public static final synchronized CsmErrorProvider getDefault() {
        return DEFAULT;
    }

    private static boolean isPartial(CsmFile csmFile, Set<CsmFile> set) {
        if (set.contains(csmFile)) {
            return false;
        }
        set.add(csmFile);
        Collection<CsmReference> collection = CsmIncludeHierarchyResolver.getDefault().getIncludes(csmFile);
        for (CsmReference csmReference : collection) {
            CsmSelect.CsmFilter csmFilter;
            Iterator<CsmOffsetableDeclaration> iterator;
            if (csmReference == null) continue;
            int n = csmReference.getStartOffset();
            CsmFile csmFile2 = csmReference.getContainingFile();
            if (csmFile2 == null || !(CsmSelect.hasDeclarations(csmFile2) ? (iterator = CsmSelect.getDeclarations(csmFile2, csmFilter = CsmSelect.getFilterBuilder().createOffsetFilter(n))).hasNext() : CsmErrorProvider.isPartial(csmFile2, set))) continue;
            return true;
        }
        return false;
    }

    private static class AsynchronousMerger
    extends BaseMerger {
        private AsynchronousMerger() {
        }

        public void getErrorsImpl(final Request request, final Response response) {
            ArrayList<RequestProcessor.Task> arrayList = new ArrayList<RequestProcessor.Task>();
            for (final CsmErrorProvider csmErrorProvider : this.res.allInstances()) {
                if (request.isCancelled()) break;
                RequestProcessor.Task task = RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        if (!request.isCancelled()) {
                            try {
                                csmErrorProvider.getErrors(request, response);
                            }
                            catch (AssertionError assertionError) {
                                ((Throwable)((Object)assertionError)).printStackTrace();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                });
                arrayList.add(task);
            }
            for (RequestProcessor.Task task : arrayList) {
                task.waitFinished();
            }
        }
    }

    private static class SynchronousMerger
    extends BaseMerger {
        private SynchronousMerger() {
        }

        public void getErrorsImpl(Request request, Response response) {
            for (CsmErrorProvider csmErrorProvider : this.res.allInstances()) {
                if (request.isCancelled()) break;
                csmErrorProvider.getErrors(request, response);
            }
        }
    }

    private static abstract class BaseMerger
    extends CsmErrorProvider {
        protected final Lookup.Result<CsmErrorProvider> res = Lookup.getDefault().lookupResult(CsmErrorProvider.class);

        protected abstract void getErrorsImpl(Request var1, Response var2);

        protected boolean validate(Request request) {
            return ENABLE;
        }

        public void doGetErrors(Request request, Response response) {
            if (!CsmErrorProvider.isPartial(request.getFile(), new HashSet())) {
                this.getErrorsImpl(request, response);
            }
        }

        public String getName() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static interface Response {
        public void addError(CsmErrorInfo var1);

        public void done();
    }

    public static interface Request {
        public CsmFile getFile();

        public boolean isCancelled();

        public Document getDocument();
    }
}

