/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.spi.model.services.CsmSelectProvider;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmSelect {
    private static CsmSelectProvider DEFAULT = new Default();

    public static CsmFilterBuilder getFilterBuilder() {
        return CsmSelect.getDefault().getFilterBuilder();
    }

    public static Iterator<CsmMacro> getMacros(CsmFile csmFile, CsmFilter csmFilter) {
        return CsmSelect.getDefault().getMacros(csmFile, csmFilter);
    }

    public static Iterator<CsmInclude> getIncludes(CsmFile csmFile, CsmFilter csmFilter) {
        return CsmSelect.getDefault().getIncludes(csmFile, csmFilter);
    }

    public static boolean hasDeclarations(CsmFile csmFile) {
        return CsmSelect.getDefault().hasDeclarations(csmFile);
    }

    public static Iterator<CsmOffsetableDeclaration> getDeclarations(CsmFile csmFile, CsmFilter csmFilter) {
        return CsmSelect.getDefault().getDeclarations(csmFile, csmFilter);
    }

    public static Iterator<CsmVariable> getStaticVariables(CsmFile csmFile, CsmFilter csmFilter) {
        return CsmSelect.getDefault().getStaticVariables(csmFile, csmFilter);
    }

    public static Iterator<CsmFunction> getStaticFunctions(CsmFile csmFile, CsmFilter csmFilter) {
        return CsmSelect.getDefault().getStaticFunctions(csmFile, csmFilter);
    }

    public static Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespace csmNamespace, CsmFilter csmFilter) {
        return CsmSelect.getDefault().getDeclarations(csmNamespace, csmFilter);
    }

    public static Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespaceDefinition csmNamespaceDefinition, CsmFilter csmFilter) {
        return CsmSelect.getDefault().getDeclarations(csmNamespaceDefinition, csmFilter);
    }

    public static Iterator<CsmMember> getClassMembers(CsmClass csmClass, CsmFilter csmFilter) {
        return CsmSelect.getDefault().getClassMembers(csmClass, csmFilter);
    }

    public static Iterator<CsmFunction> getFunctions(CsmProject csmProject, CharSequence charSequence) {
        if (charSequence.length() > 1 && charSequence.charAt(0) == ':' && charSequence.charAt(1) == ':') {
            charSequence = charSequence.subSequence(2, charSequence.length());
        }
        ArrayList<CsmFunction> arrayList = new ArrayList<CsmFunction>();
        CsmSelect.getFunctions(csmProject, charSequence, arrayList, new LinkedHashSet<CsmProject>());
        return arrayList.iterator();
    }

    private static void getFunctions(CsmProject csmProject, CharSequence charSequence, Collection<CsmFunction> collection, Collection<CsmProject> collection2) {
        if (!collection2.contains(csmProject)) {
            Iterator iterator;
            collection2.add(csmProject);
            int n = -1;
            for (int i = charSequence.length() - 2; i > 1; --i) {
                if (charSequence.charAt(i) != ':' || charSequence.charAt(i + 1) != ':') continue;
                n = i;
                break;
            }
            if (n == -1) {
                iterator = CsmSelect.getFilterBuilder().createCompoundFilter(CsmSelect.getFilterBuilder().createKindFilter(CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION), CsmSelect.getFilterBuilder().createNameFilter(charSequence, true, true, false));
                CsmSelect.getFunctions(CsmSelect.getDeclarations(csmProject.getGlobalNamespace(), (CsmFilter)((Object)iterator)), collection);
            } else {
                iterator = charSequence.subSequence(0, n);
                CharSequence charSequence2 = charSequence.subSequence(n + 2, charSequence.length());
                CsmNamespace csmNamespace = csmProject.findNamespace((CharSequence)((Object)iterator));
                CsmFilter csmFilter = CsmSelect.getFilterBuilder().createCompoundFilter(CsmSelect.getFilterBuilder().createKindFilter(CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION), CsmSelect.getFilterBuilder().createNameFilter(charSequence2, true, true, false));
                if (csmNamespace != null) {
                    CsmSelect.getFunctions(CsmSelect.getDeclarations(csmNamespace, csmFilter), collection);
                }
                for (CsmClassifier csmClassifier : csmProject.findClassifiers(iterator)) {
                    if (!CsmKindUtilities.isClass((CsmObject)csmClassifier)) continue;
                    CsmSelect.getFunctions(CsmSelect.getClassMembers((CsmClass)csmClassifier, csmFilter), collection);
                }
            }
            for (CharSequence charSequence2 : csmProject.getLibraries()) {
                CsmSelect.getFunctions((CsmProject)charSequence2, charSequence, collection, collection2);
            }
        }
    }

    private static void getFunctions(Iterator<? extends CsmOffsetableDeclaration> iterator, Collection<CsmFunction> collection) {
        while (iterator.hasNext()) {
            CsmOffsetableDeclaration csmOffsetableDeclaration = iterator.next();
            if (!CsmKindUtilities.isFunction((CsmObject)csmOffsetableDeclaration)) continue;
            collection.add((CsmFunction)csmOffsetableDeclaration);
        }
    }

    private CsmSelect() {
    }

    private static CsmSelectProvider getDefault() {
        return DEFAULT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Default
    implements CsmSelectProvider {
        private final Lookup.Result<CsmSelectProvider> res = Lookup.getDefault().lookupResult(CsmSelectProvider.class);
        private static final boolean FIX_SERVICE = true;
        private CsmSelectProvider fixedSelector;

        Default() {
        }

        private CsmSelectProvider getService() {
            CsmSelectProvider csmSelectProvider = this.fixedSelector;
            if (csmSelectProvider == null) {
                Iterator iterator = this.res.allInstances().iterator();
                if (iterator.hasNext()) {
                    CsmSelectProvider csmSelectProvider2;
                    csmSelectProvider = csmSelectProvider2 = (CsmSelectProvider)iterator.next();
                }
                if (csmSelectProvider != null) {
                    this.fixedSelector = csmSelectProvider;
                }
            }
            return csmSelectProvider;
        }

        @Override
        public CsmFilterBuilder getFilterBuilder() {
            CsmSelectProvider csmSelectProvider = this.getService();
            if (csmSelectProvider != null) {
                return csmSelectProvider.getFilterBuilder();
            }
            return null;
        }

        @Override
        public Iterator<CsmMacro> getMacros(CsmFile csmFile, CsmFilter csmFilter) {
            CsmSelectProvider csmSelectProvider = this.getService();
            if (csmSelectProvider != null) {
                return csmSelectProvider.getMacros(csmFile, csmFilter);
            }
            return null;
        }

        @Override
        public Iterator<CsmInclude> getIncludes(CsmFile csmFile, CsmFilter csmFilter) {
            CsmSelectProvider csmSelectProvider = this.getService();
            if (csmSelectProvider != null) {
                return csmSelectProvider.getIncludes(csmFile, csmFilter);
            }
            return null;
        }

        @Override
        public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespace csmNamespace, CsmFilter csmFilter) {
            CsmSelectProvider csmSelectProvider = this.getService();
            if (csmSelectProvider != null) {
                return csmSelectProvider.getDeclarations(csmNamespace, csmFilter);
            }
            return null;
        }

        @Override
        public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmFile csmFile, CsmFilter csmFilter) {
            CsmSelectProvider csmSelectProvider = this.getService();
            if (csmSelectProvider != null) {
                return csmSelectProvider.getDeclarations(csmFile, csmFilter);
            }
            return null;
        }

        @Override
        public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespaceDefinition csmNamespaceDefinition, CsmFilter csmFilter) {
            CsmSelectProvider csmSelectProvider = this.getService();
            if (csmSelectProvider != null) {
                return csmSelectProvider.getDeclarations(csmNamespaceDefinition, csmFilter);
            }
            return null;
        }

        @Override
        public Iterator<CsmMember> getClassMembers(CsmClass csmClass, CsmFilter csmFilter) {
            CsmSelectProvider csmSelectProvider = this.getService();
            if (csmSelectProvider != null) {
                return csmSelectProvider.getClassMembers(csmClass, csmFilter);
            }
            return null;
        }

        @Override
        public Iterator<CsmVariable> getStaticVariables(CsmFile csmFile, CsmFilter csmFilter) {
            CsmSelectProvider csmSelectProvider = this.getService();
            if (csmSelectProvider != null) {
                return csmSelectProvider.getStaticVariables(csmFile, csmFilter);
            }
            return null;
        }

        @Override
        public Iterator<CsmFunction> getStaticFunctions(CsmFile csmFile, CsmFilter csmFilter) {
            CsmSelectProvider csmSelectProvider = this.getService();
            if (csmSelectProvider != null) {
                return csmSelectProvider.getStaticFunctions(csmFile, csmFilter);
            }
            return null;
        }

        @Override
        public boolean hasDeclarations(CsmFile csmFile) {
            CsmSelectProvider csmSelectProvider = this.getService();
            if (csmSelectProvider != null) {
                return csmSelectProvider.hasDeclarations(csmFile);
            }
            return csmFile.getDeclarations().isEmpty();
        }
    }

    public static interface CsmFilterBuilder {
        public CsmFilter createKindFilter(CsmDeclaration.Kind ... var1);

        public CsmFilter createNameFilter(CharSequence var1, boolean var2, boolean var3, boolean var4);

        public CsmFilter createOffsetFilter(int var1, int var2);

        public CsmFilter createOffsetFilter(int var1);

        public CsmFilter createCompoundFilter(CsmFilter var1, CsmFilter var2);

        public CsmFilter createNameFilter(NameAcceptor var1);
    }

    public static interface NameAcceptor {
        public boolean accept(CharSequence var1);
    }

    public static interface CsmFilter {
    }
}

