/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.ruby.platform.gems.Gem;
import org.openide.util.NbBundle;

final class GemUISupport {
    private GemUISupport() {
    }

    static String getGemHTMLDescriptionForTextPane(Gem gem) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<h2>");
        stringBuilder.append(gem.getName());
        stringBuilder.append("</h2>\n");
        String string = gem.getInstalledVersionsAsString();
        String string2 = gem.getAvailableVersionsAsString();
        if (string != null && string2 != null) {
            stringBuilder.append(GemUISupport.h3(GemUISupport.getMessage("GemUISupport.InstalledVersion")));
            stringBuilder.append(string);
            stringBuilder.append(GemUISupport.h3(GemUISupport.getMessage("GemUISupport.AvailableVersion")));
            stringBuilder.append(string2);
            stringBuilder.append("<br>");
        } else {
            stringBuilder.append("<h3>");
            String string3 = string;
            if (string3 == null) {
                string3 = string2;
            }
            if (string3.indexOf(44) == -1) {
                stringBuilder.append(GemUISupport.getMessage("GemUISupport.Version"));
            } else {
                stringBuilder.append(GemUISupport.getMessage("GemUISupport.Versions"));
            }
            stringBuilder.append("</h3>");
            stringBuilder.append(string3);
        }
        if (gem.getDescription() != null) {
            stringBuilder.append(GemUISupport.h3(GemUISupport.getMessage("GemUISupport.Description")));
            stringBuilder.append(gem.getHTMLDescription());
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private static String h3(String string) {
        return "<h3>" + string + "</h3>";
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(GemUISupport.class, (String)string);
    }

    static class GemListRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public GemListRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            StringBuilder stringBuilder = new StringBuilder(100);
            Gem gem = (Gem)object;
            stringBuilder.append("<html><b>");
            stringBuilder.append(gem.getName());
            stringBuilder.append("</b>");
            if (gem.getInstalledVersionsAsString() != null) {
                stringBuilder.append(" (");
                stringBuilder.append(gem.getInstalledVersionsAsString());
                if (gem.getAvailableVersionsAsString() != null) {
                    stringBuilder.append(" => ").append(gem.getAvailableVersionsAsString());
                }
                stringBuilder.append(") ");
            }
            if (gem.getDescription() != null) {
                stringBuilder.append(": ");
                stringBuilder.append(gem.getDescription());
            }
            stringBuilder.append("</html>");
            this.setText(stringBuilder.toString());
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }
}

