/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.windows.OutputListener;

public final class OutputProcessor {
    public static final Logger LOGGER = Logger.getLogger(OutputListener.class.getName());

    public static boolean open(final FileObject fileObject, final int n) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    OutputProcessor.open(fileObject, n);
                }
            });
            return true;
        }
        try {
            StyledDocument styledDocument;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (editorCookie != null && lineCookie != null && (styledDocument = editorCookie.openDocument()) != null) {
                int n2 = n;
                if (n2 < 1) {
                    n2 = 1;
                }
                try {
                    Line.Set set = lineCookie.getLineSet();
                    Line line = set.getCurrent(n2 - 1);
                    if (line != null) {
                        line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                        return true;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if ((styledDocument = (OpenCookie)dataObject.getCookie(OpenCookie.class)) != null) {
                styledDocument.open();
                return true;
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return false;
    }
}

