/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.wizards.shortcut;

import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class ShortcutWizard
extends WizardDescriptor {
    private static final Logger LOG = Logger.getLogger(ShortcutWizard.class.getName());
    private static final String PROP_CONTENTS = "wizdata.contents";
    static final String PROP_DISPLAY_NAME = "wizdata.displayName";
    static final String PROP_SHOW_CUST = "wizdata.show.cust";
    static final String PROP_SHOW_MENU = "wizdata.show.menu";
    static final String PROP_SHOW_TOOL = "wizdata.show.tool";
    static final String PROP_SHOW_KEYB = "wizdata.show.keyb";
    static final String PROP_FOLDER_MENU = "wizdata.folder.menu";
    static final String PROP_FOLDER_TOOL = "wizdata.folder.tool";
    static final String PROP_STROKE = "wizdata.stroke";
    private final AntProjectCookie project;
    private final Element target;
    private final ShortcutIterator it;

    public static void show(AntProjectCookie antProjectCookie, Element element) {
        ShortcutWizard shortcutWizard = new ShortcutWizard(antProjectCookie, element, new ShortcutIterator());
        DialogDisplayer.getDefault().createDialog((DialogDescriptor)shortcutWizard).setVisible(true);
        if (shortcutWizard.getValue().equals(WizardDescriptor.FINISH_OPTION)) {
            try {
                shortcutWizard.finish();
            }
            catch (IOException iOException) {
                AntModule.err.notify((Throwable)iOException);
            }
        }
    }

    public static void remove(AntProjectCookie antProjectCookie, Element element) {
        File file;
        FileObject fileObject = FileUtil.getConfigFile((String)"Actions/Build");
        if (fileObject != null && (file = antProjectCookie.getFile()) != null) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (!ShortcutWizard.isAntScript(fileObject2)) continue;
                try {
                    Element element2;
                    Document exception = XMLUtil.parse((InputSource)new InputSource(fileObject2.getURL().toString()), (boolean)false, (boolean)false, null, null);
                    NodeList nodeList = exception.getElementsByTagName("ant");
                    if (nodeList.getLength() != 1 || !(element2 = (Element)nodeList.item(0)).getAttribute("antfile").equals(file.getAbsolutePath()) || !element2.getAttribute("target").equals(element.getAttribute("name"))) continue;
                    ShortcutWizard.doRemove(fileObject2);
                    return;
                }
                catch (Exception exception) {
                    LOG.log(Level.INFO, "Failed to parse or remove " + fileObject2, exception);
                }
            }
            String string = NbBundle.getMessage(ShortcutWizard.class, (String)"MSG_delete_all_shortcuts");
            String string2 = NbBundle.getMessage(ShortcutWizard.class, (String)"TITLE_delete_all_shortcuts");
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)string, string2, 2)).equals(NotifyDescriptor.OK_OPTION)) {
                for (FileObject fileObject3 : fileObject.getChildren()) {
                    if (!ShortcutWizard.isAntScript(fileObject3)) continue;
                    try {
                        ShortcutWizard.doRemove(fileObject3);
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.INFO, "Failed to remove " + fileObject3, iOException);
                    }
                }
            }
            return;
        }
        Toolkit.getDefaultToolkit().beep();
    }

    private static boolean isAntScript(FileObject fileObject) {
        try {
            return DataObject.find((FileObject)fileObject).getLookup().lookup(AntProjectCookie.class) != null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return fileObject.hasExt("xml");
        }
    }

    private static void doRemove(FileObject fileObject) throws IOException {
        for (String string : new String[]{"Menu", "Toolbars", "Shortcuts", "Keymaps"}) {
            FileObject fileObject2 = FileUtil.getConfigFile((String)string);
            if (fileObject2 == null) continue;
            for (FileObject fileObject3 : NbCollections.iterable((Enumeration)fileObject2.getChildren(true))) {
                DataObject dataObject;
                try {
                    dataObject = DataObject.find((FileObject)fileObject3);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    LOG.log(Level.INFO, "Loading " + fileObject3, dataObjectNotFoundException);
                    continue;
                }
                if (!(dataObject instanceof DataShadow) || ((DataShadow)dataObject).getOriginal().getPrimaryFile() != fileObject) continue;
                ShortcutWizard.delete(fileObject3);
            }
        }
        ShortcutWizard.delete(fileObject);
    }

    private static void delete(FileObject fileObject) throws IOException {
        Object object = fileObject.getAttribute("removeWritables");
        if (object instanceof Callable) {
            try {
                ((Callable)object).call();
            }
            catch (Exception exception) {
                throw (IOException)new IOException("Could not delete " + fileObject + ": " + exception.toString()).initCause(exception);
            }
        } else {
            throw new IOException("Could not delete " + fileObject);
        }
    }

    ShortcutWizard(AntProjectCookie antProjectCookie, Element element, ShortcutIterator shortcutIterator) {
        this.project = antProjectCookie;
        this.target = element;
        this.it = shortcutIterator;
        shortcutIterator.initialize(this);
        this.setPanelsAndSettings(shortcutIterator, (Object)this);
        this.setTitle(NbBundle.getMessage(ShortcutWizard.class, (String)"TITLE_wizard"));
        this.putProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        String string = element.getAttribute("description");
        this.putProperty(PROP_DISPLAY_NAME, string);
    }

    String getContents() {
        String string = (String)this.getProperty(PROP_CONTENTS);
        if (string == null) {
            string = this.generateContents();
            this.putContents(string);
        }
        return string;
    }

    void putContents(String string) {
        this.putProperty(PROP_CONTENTS, string);
    }

    private String generateContents() {
        try {
            Document document = XMLUtil.createDocument((String)"project", null, null, null);
            Element element = document.getDocumentElement();
            String string = (String)this.getProperty(PROP_DISPLAY_NAME);
            if (string != null && string.length() > 0) {
                element.setAttribute("name", string);
            }
            element.setAttribute("default", "run");
            Element element2 = document.createElement("target");
            element2.setAttribute("name", "run");
            Element element3 = document.createElement("ant");
            element3.setAttribute("antfile", this.project.getFile().getAbsolutePath());
            element3.setAttribute("inheritall", "false");
            element3.setAttribute("target", this.target.getAttribute("name"));
            element2.appendChild(element3);
            element.appendChild(element2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
            XMLUtil.write((Document)document, (OutputStream)byteArrayOutputStream, (String)"UTF-8");
            return byteArrayOutputStream.toString("UTF-8");
        }
        catch (IOException iOException) {
            AntModule.err.notify((Throwable)iOException);
            return "";
        }
    }

    void finish() throws IOException {
        final FileObject fileObject = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)"Actions/Build");
        fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject fileObject3;
                String string = FileUtil.findFreeFileName((FileObject)fileObject, (String)ShortcutWizard.this.getTargetBaseName(), (String)"xml") + ".xml";
                FileObject fileObject2 = fileObject.createData(string);
                OutputStream outputStream = fileObject2.getOutputStream();
                try {
                    outputStream.write(ShortcutWizard.this.getContents().getBytes("UTF-8"));
                    fileObject3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    outputStream.close();
                    throw throwable;
                }
                outputStream.close();
                DataObject dataObject = DataObject.find((FileObject)fileObject2);
                if (ShortcutWizard.this.it.showing(ShortcutWizard.PROP_SHOW_MENU)) {
                    ShortcutWizard.this.makeShadow((DataFolder)ShortcutWizard.this.getProperty(ShortcutWizard.PROP_FOLDER_MENU), dataObject);
                }
                if (ShortcutWizard.this.it.showing(ShortcutWizard.PROP_SHOW_TOOL)) {
                    ShortcutWizard.this.makeShadow((DataFolder)ShortcutWizard.this.getProperty(ShortcutWizard.PROP_FOLDER_TOOL), dataObject);
                }
                if (ShortcutWizard.this.it.showing(ShortcutWizard.PROP_SHOW_KEYB)) {
                    fileObject3 = FileUtil.getConfigFile((String)"Shortcuts");
                    String string2 = Utilities.keyToString((KeyStroke)((KeyStroke)ShortcutWizard.this.getProperty(ShortcutWizard.PROP_STROKE)));
                    DataShadow.create((DataFolder)DataFolder.findFolder((FileObject)fileObject3), (String)string2, (DataObject)dataObject);
                }
            }
        });
    }

    private void makeShadow(DataFolder dataFolder, DataObject dataObject) throws IOException {
        DataShadow dataShadow = DataShadow.create((DataFolder)dataFolder, (DataObject)dataObject);
        assert (dataShadow.getFolder() == dataFolder);
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>(Arrays.asList(dataFolder.getChildren()));
        if (arrayList.remove(dataShadow)) {
            arrayList.add((DataObject)dataShadow);
            dataFolder.setOrder(arrayList.toArray(new DataObject[arrayList.size()]));
        } else {
            LOG.warning("#175981: could not find " + dataShadow + " among " + arrayList);
        }
    }

    String getTargetBaseName() {
        String string = "";
        Document document = this.project.getDocument();
        if (document != null) {
            string = document.getDocumentElement().getAttribute("name");
        }
        return (string + '-' + this.target.getAttribute("name")).replaceAll("[^a-zA-Z0-9_-]", "-");
    }
}

