/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.core.startup.Main;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

final class TimableEventQueue
extends EventQueue
implements Runnable {
    private static final Logger LOG = Logger.getLogger(TimableEventQueue.class.getName());
    private static final RequestProcessor RP = new RequestProcessor("Timeable Event Queue Watch Dog", 1, true);
    private static final int QUANTUM;
    private static final int REPORT;
    private static final int PAUSE;
    private final RequestProcessor.Task TIMEOUT = RP.create((Runnable)this);
    private volatile long ignoreTill;
    private volatile long start;
    private volatile ActionListener stoppable;
    private volatile boolean isWaitCursor;

    public TimableEventQueue() {
        this.TIMEOUT.setPriority(1);
    }

    static void initialize() {
        try {
            Mutex.EVENT.writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    Thread.currentThread().setContextClassLoader(Main.getModuleSystem().getManager().getClassLoader());
                    Toolkit.getDefaultToolkit().getSystemEventQueue().push(new TimableEventQueue());
                    LOG.fine("Initialization done");
                    return null;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(AWTEvent aWTEvent) {
        try {
            this.tick("dispatchEvent");
            super.dispatchEvent(aWTEvent);
        }
        finally {
            this.done();
        }
    }

    private void done() {
        ActionListener actionListener;
        this.TIMEOUT.cancel();
        LOG.log(Level.FINE, "isWait cursor {0}", this.isWaitCursor);
        long l = this.isWaitCursor ? (long)(REPORT * 10) : (long)REPORT;
        this.isWaitCursor = false;
        long l2 = System.currentTimeMillis() - this.start;
        if (l2 > (long)QUANTUM) {
            LOG.log(Level.FINE, "done, timer stopped, took {0}", l2);
            if (l2 > l) {
                LOG.log(Level.WARNING, "too much time in AWT thread {0}", this.stoppable);
                actionListener = this.stoppable;
                if (actionListener != null) {
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                        actionListener.actionPerformed(new ActionEvent(dataOutputStream, 0, "write"));
                        dataOutputStream.close();
                        if (dataOutputStream.size() > 0) {
                            Object[] objectArray = new Object[]{byteArrayOutputStream.toByteArray(), l2};
                            Logger.getLogger("org.netbeans.ui.performance").log(Level.CONFIG, "Slowness detected", objectArray);
                        } else {
                            LOG.log(Level.WARNING, "no snapshot taken");
                        }
                        this.stoppable = null;
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                    this.ignoreTill = System.currentTimeMillis() + (long)PAUSE;
                }
            }
        } else {
            LOG.log(Level.FINEST, "done, timer stopped, took {0}", l2);
        }
        if ((actionListener = this.stoppable) != null) {
            actionListener.actionPerformed(new ActionEvent(this, 0, "cancel"));
            this.stoppable = null;
        }
    }

    private void tick(String string) {
        this.start = System.currentTimeMillis();
        if (this.start >= this.ignoreTill && WindowManager.getDefault().getMainWindow().isShowing()) {
            LOG.log(Level.FINEST, "tick, schedule a timer for {0}", string);
            this.TIMEOUT.schedule(QUANTUM);
        }
    }

    public void run() {
        if (this.stoppable != null) {
            LOG.log(Level.WARNING, "Still previous controller {0}", this.stoppable);
            return;
        }
        Runnable runnable = (Runnable)TimableEventQueue.createSelfSampler();
        if (runnable != null) {
            runnable.run();
            this.stoppable = (ActionListener)((Object)runnable);
        }
        this.isWaitCursor |= TimableEventQueue.isWaitCursor();
    }

    private static Object createSelfSampler() {
        FileObject fileObject = FileUtil.getConfigFile((String)"Actions/Profile/org-netbeans-modules-profiler-actions-SelfSamplerAction.instance");
        if (fileObject == null) {
            return null;
        }
        Action action = (Action)fileObject.getAttribute("delegate");
        if (action == null) {
            return null;
        }
        return action.getValue("logger-awt");
    }

    private static boolean isWaitCursor() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component != null) {
            if (component.getCursor().getType() == 3) {
                LOG.finer("wait cursor on focus owner");
                return true;
            }
            Window window = SwingUtilities.windowForComponent(component);
            if (window != null && window.getCursor().getType() == 3) {
                LOG.finer("wait cursor on window");
                return true;
            }
        }
        for (Frame frame : Frame.getFrames()) {
            if (frame.getCursor().getType() != 3) continue;
            LOG.finer("wait cursor on frame");
            return true;
        }
        LOG.finest("no wait cursor");
        return false;
    }

    static {
        int n = 10000;
        int n2 = 20000;
        if (!$assertionsDisabled) {
            n = 100;
            if (100 <= 0) {
                throw new AssertionError();
            }
        }
        if (!$assertionsDisabled) {
            n2 = 3000;
            if (3000 <= 0) {
                throw new AssertionError();
            }
        }
        QUANTUM = Integer.getInteger("org.netbeans.core.TimeableEventQueue.quantum", n);
        REPORT = Integer.getInteger("org.netbeans.core.TimeableEventQueue.report", n2);
        PAUSE = Integer.getInteger("org.netbeans.core.TimeableEventQueue.pause", 15000);
    }
}

