/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.j2ee.archive.project.ArchiveProjectProperties;
import org.openide.ErrorManager;

public final class VisualPropertySupport {
    private final String WRONG_TYPE = ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/customizer/Bundle").getString("WrongType");
    private ArchiveProjectProperties apProperties;
    private HashMap component2property;
    private ComponentListener componentListener;
    private int comboType;
    private String[] comboValues;

    public VisualPropertySupport(ArchiveProjectProperties archiveProjectProperties) {
        this.apProperties = archiveProjectProperties;
        this.component2property = new HashMap(10);
        this.componentListener = new ComponentListener();
    }

    public void register(JComboBox jComboBox, String[] stringArray, String[] stringArray2, String string) {
        this.comboType = 1;
        this.comboValues = (String[])stringArray2.clone();
        String string2 = (String)this.getAsType(string, String.class);
        this.component2property.put(jComboBox, string);
        jComboBox.removeAllItems();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            jComboBox.addItem(stringArray[i]);
            if (!stringArray2[i].equals(string2)) continue;
            n = i;
        }
        if (n < jComboBox.getItemCount()) {
            jComboBox.setSelectedIndex(n);
        }
        jComboBox.removeActionListener(this.componentListener);
        jComboBox.addActionListener(this.componentListener);
    }

    private static String readValue(JCheckBox jCheckBox) {
        return jCheckBox.isSelected() ? "true" : "false";
    }

    private static String readValue(Document document) {
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
            return "";
        }
    }

    private static String readValue(JComboBox jComboBox) {
        return (String)jComboBox.getSelectedItem();
    }

    private Object getAsType(String string, Class clazz) {
        return this.getAsType(string, clazz, true);
    }

    private Object getAsType(String string, Class clazz, boolean bl) {
        Object object = this.apProperties.get(string);
        if (object == null || clazz.isInstance(object)) {
            return object;
        }
        if (bl) {
            throw new IllegalArgumentException("Value of property: " + string + " exbected to be: " + clazz.getName() + " but was: " + object.getClass().getName() + "!");
        }
        return this.WRONG_TYPE;
    }

    private class ComponentListener
    implements ActionListener,
    DocumentListener {
        private ComponentListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = (String)VisualPropertySupport.this.component2property.get(object);
            if (string != null) {
                if (object instanceof JCheckBox) {
                    VisualPropertySupport.this.apProperties.put(string, VisualPropertySupport.readValue((JCheckBox)object));
                } else if (object instanceof JComboBox) {
                    if (((JComboBox)object).getItemCount() == 0) {
                        return;
                    }
                    switch (VisualPropertySupport.this.comboType) {
                        case 0: {
                            VisualPropertySupport.this.apProperties.put(string, VisualPropertySupport.readValue((JComboBox)object));
                            break;
                        }
                        case 1: {
                            VisualPropertySupport.this.apProperties.put(string, VisualPropertySupport.this.comboValues[((JComboBox)object).getSelectedIndex()]);
                        }
                    }
                }
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            String string = (String)VisualPropertySupport.this.component2property.get(document);
            if (string != null) {
                VisualPropertySupport.this.apProperties.put(string, VisualPropertySupport.readValue(document));
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }
    }
}

