/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.EqualsHintCustomiser;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualsHint
extends AbstractHint {
    static final String KEY_DELEGATE = "delegate";
    static final String KEY_ARRAY_EQUALS = "EqualsArray";
    static final String KEY_INCOMPATIBLE_EQUALS = "EqualsIncompabile";
    private static final String ERASURE_PREFS_KEY = "eguals-hint-erasure";
    private static EqualsHint DELEGATE;
    private static EqualsHint ARRAY_EQUALS;
    private static EqualsHint INCOMPABILE_EQUALS;
    private String kind;

    public EqualsHint(String string) {
        super(true, false, AbstractHint.HintSeverity.WARNING, "array-equals");
        this.kind = string;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(EqualsHint.class, (String)("DSC_" + this.kind));
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.METHOD_INVOCATION);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        Object object;
        Object bl;
        Object object2;
        if (this.kind != KEY_DELEGATE || !EqualsHint.getArrayEquals().isEnabled() && !EqualsHint.getIncompatibleEquals().isEnabled()) {
            return null;
        }
        if (!this.getTreeKinds().contains((Object)treePath.getLeaf().getKind())) {
            return null;
        }
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)treePath.getLeaf();
        if (methodInvocationTree.getMethodSelect().getKind() != Tree.Kind.MEMBER_SELECT) {
            return null;
        }
        Name name = ((MemberSelectTree)methodInvocationTree.getMethodSelect()).getIdentifier();
        if (!name.contentEquals("equals")) {
            return null;
        }
        TypeElement typeElement = compilationInfo.getElements().getTypeElement("java.lang.Object");
        if (typeElement == null) {
            return null;
        }
        Object object5 = null;
        for (ExecutableElement object42 : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!object42.getSimpleName().contentEquals("equals") || object42.getParameters().size() != 1 || object42.getParameters().get(0).asType().getKind() != TypeKind.DECLARED) continue;
            object5 = object42;
            break;
        }
        if (object5 == null) {
            return null;
        }
        Element element = compilationInfo.getTrees().getElement(treePath);
        if (element == null || element.getKind() != ElementKind.METHOD) {
            return null;
        }
        if (!object5.equals(element) && !compilationInfo.getElements().overrides((ExecutableElement)element, (ExecutableElement)object5, (TypeElement)element.getEnclosingElement())) {
            return null;
        }
        LinkedList<ErrorDescription> linkedList = new LinkedList<ErrorDescription>();
        TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror(new TreePath(new TreePath(treePath, methodInvocationTree.getMethodSelect()), ((MemberSelectTree)methodInvocationTree.getMethodSelect()).getExpression()));
        if (EqualsHint.getArrayEquals().isEnabled() && typeMirror != null && typeMirror.getKind() == TypeKind.ARRAY && (object2 = compilationInfo.getTreeUtilities().findNameSpan((MemberSelectTree)methodInvocationTree.getMethodSelect())) != null) {
            bl = NbBundle.getMessage(EqualsHint.class, (String)"ERR_ARRAY_EQUALS");
            object = Arrays.asList(new ReplaceFixImpl(compilationInfo.getJavaSource(), TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), true), new ReplaceFixImpl(compilationInfo.getJavaSource(), TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), false));
            linkedList.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)bl, (List)object, (FileObject)compilationInfo.getFileObject(), (int)object2[0], (int)object2[1]));
        }
        if (EqualsHint.getIncompatibleEquals().isEnabled()) {
            boolean bl2;
            object2 = compilationInfo.getTrees().getTypeMirror(new TreePath(treePath, methodInvocationTree.getArguments().get(0)));
            if (EqualsHint.getErasure(this.getPreferences(null))) {
                bl = compilationInfo.getTypes();
                object2 = bl.erasure((TypeMirror)object2);
                typeMirror = bl.erasure(typeMirror);
            }
            boolean bl3 = bl2 = compilationInfo.getTypeUtilities().isCastable(typeMirror, (TypeMirror)object2) || compilationInfo.getTypeUtilities().isCastable((TypeMirror)object2, typeMirror);
            if (!bl2 && (object = compilationInfo.getTreeUtilities().findNameSpan((MemberSelectTree)methodInvocationTree.getMethodSelect())) != null) {
                String string = NbBundle.getMessage(EqualsHint.class, (String)"ERR_INCOMPATIBLE_EQUALS");
                linkedList.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)string, (FileObject)compilationInfo.getFileObject(), (int)object[0], (int)object[1]));
            }
        }
        return linkedList;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return new EqualsHintCustomiser(preferences);
    }

    static void setErasure(Preferences preferences, boolean bl) {
        preferences.putBoolean(ERASURE_PREFS_KEY, bl);
    }

    static boolean getErasure(Preferences preferences) {
        return preferences.getBoolean(ERASURE_PREFS_KEY, true);
    }

    @Override
    public String getId() {
        return EqualsHint.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(EqualsHint.class, (String)("DN_" + this.kind));
    }

    @Override
    public void cancel() {
    }

    public static synchronized EqualsHint getDelegate() {
        if (DELEGATE == null) {
            DELEGATE = new EqualsHint(KEY_DELEGATE);
        }
        return DELEGATE;
    }

    public static synchronized EqualsHint getArrayEquals() {
        if (ARRAY_EQUALS == null) {
            ARRAY_EQUALS = new EqualsHint(KEY_ARRAY_EQUALS);
        }
        return ARRAY_EQUALS;
    }

    public static synchronized EqualsHint getIncompatibleEquals() {
        if (INCOMPABILE_EQUALS == null) {
            INCOMPABILE_EQUALS = new EqualsHint(KEY_INCOMPATIBLE_EQUALS);
        }
        return INCOMPABILE_EQUALS;
    }

    static final class ReplaceFixImpl
    implements Fix {
        private JavaSource js;
        private TreePathHandle what;
        private boolean arraysEquals;

        public ReplaceFixImpl(JavaSource javaSource, TreePathHandle treePathHandle, boolean bl) {
            this.js = javaSource;
            this.what = treePathHandle;
            this.arraysEquals = bl;
        }

        public String getText() {
            return NbBundle.getMessage(EqualsHint.class, (String)(this.arraysEquals ? "FIX_ReplaceWithArraysEquals" : "FIX_ReplaceWithInstanceEquals"));
        }

        public ChangeInfo implement() throws Exception {
            this.computeResult().commit();
            return null;
        }

        boolean isArraysEquals() {
            return this.arraysEquals;
        }

        private ModificationResult computeResult() throws Exception {
            return this.js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws Exception {
                    ExpressionTree expressionTree;
                    workingCopy.toPhase(JavaSource.Phase.PARSED);
                    TreePath treePath = ReplaceFixImpl.this.what.resolve((CompilationInfo)workingCopy);
                    if (treePath == null) {
                        return;
                    }
                    MethodInvocationTree methodInvocationTree = (MethodInvocationTree)treePath.getLeaf();
                    MemberSelectTree memberSelectTree = (MemberSelectTree)methodInvocationTree.getMethodSelect();
                    TypeElement typeElement = workingCopy.getElements().getTypeElement("java.util.Arrays");
                    if (typeElement == null) {
                        return;
                    }
                    if (ReplaceFixImpl.this.arraysEquals) {
                        MemberSelectTree memberSelectTree2 = workingCopy.getTreeMaker().MemberSelect(workingCopy.getTreeMaker().QualIdent((Element)typeElement), (CharSequence)"equals");
                        LinkedList<ExpressionTree> linkedList = new LinkedList<ExpressionTree>();
                        linkedList.add(memberSelectTree.getExpression());
                        linkedList.add(methodInvocationTree.getArguments().get(0));
                        expressionTree = workingCopy.getTreeMaker().MethodInvocation(Collections.emptyList(), (ExpressionTree)memberSelectTree2, linkedList);
                    } else {
                        expressionTree = workingCopy.getTreeMaker().Binary(Tree.Kind.EQUAL_TO, memberSelectTree.getExpression(), methodInvocationTree.getArguments().get(0));
                    }
                    workingCopy.rewrite((Tree)methodInvocationTree, (Tree)expressionTree);
                }
            });
        }
    }
}

