/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.AssignmentToItself;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationAsSuperInterface
extends AbstractHint {
    private static final List<Fix> NO_FIXES = Collections.emptyList();
    private Set<Tree.Kind> KINDS = Collections.singleton(Tree.Kind.CLASS);

    public AnnotationAsSuperInterface() {
        super(true, true, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return this.KINDS;
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        Tree tree = treePath.getLeaf();
        if (tree.getKind() != Tree.Kind.CLASS) {
            return null;
        }
        ClassTree classTree = (ClassTree)tree;
        Element element = compilationInfo.getTrees().getElement(treePath);
        if (element == null || !(element instanceof TypeElement)) {
            return null;
        }
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        TypeElement typeElement = (TypeElement)element;
        List<? extends TypeMirror> list = typeElement.getInterfaces();
        Types types = compilationInfo.getTypes();
        for (TypeMirror typeMirror : list) {
            Element element2 = types.asElement(typeMirror);
            if (element2 == null || element2.getKind() != ElementKind.ANNOTATION_TYPE) continue;
            Tree tree2 = this.findTreeForAnnotation(classTree, element2);
            tree2 = tree2 == null ? classTree : tree2;
            arrayList.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(AnnotationAsSuperInterface.class, (String)"HNT_AnnotationAsSuperInterface", (Object)element2.getSimpleName().toString()), NO_FIXES, (FileObject)compilationInfo.getFileObject(), (int)((int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), tree2)), (int)((int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), tree2))));
        }
        return arrayList;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return "AnnotationAsSuperInterface";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(AssignmentToItself.class, (String)"LBL_AnnotationAsSuperInterface");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(AssignmentToItself.class, (String)"DSC_AnnotationAsSuperInterface");
    }

    private Tree findTreeForAnnotation(ClassTree classTree, Element element) {
        String string = element.getSimpleName().toString();
        for (Tree tree : classTree.getImplementsClause()) {
            if (!tree.toString().endsWith(string)) continue;
            return tree;
        }
        return null;
    }
}

