/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public class JavadocAndSourceRootDetection {
    private static final int HOW_MANY_DIRS_TO_TRAVERSE_DEEP = 5;
    private static final Logger LOG = Logger.getLogger(JavadocAndSourceRootDetection.class.getName());
    static final Pattern JAVA_FILE;
    static final Pattern PACKAGE_INFO;

    private JavadocAndSourceRootDetection() {
    }

    public static FileObject findJavadocRoot(FileObject fileObject) {
        Parameters.notNull((CharSequence)"baseFolder", (Object)fileObject);
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException("baseFolder must be folder - " + fileObject);
        }
        return JavadocAndSourceRootDetection.findJavadocRoot(fileObject, 0);
    }

    public static FileObject findSourceRoot(FileObject fileObject) {
        Parameters.notNull((CharSequence)"fo", (Object)fileObject);
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException("fo must be folder - " + fileObject);
        }
        FileObject fileObject2 = JavadocAndSourceRootDetection.findJavaSourceFile(fileObject, 0);
        if (fileObject2 != null) {
            return JavadocAndSourceRootDetection.findPackageRoot(fileObject2);
        }
        return null;
    }

    public static FileObject findPackageRoot(FileObject fileObject) {
        if ("java".equals(fileObject.getExt())) {
            return JavadocAndSourceRootDetection.findJavaPackage(fileObject);
        }
        if ("class".equals(fileObject.getExt())) {
            return JavadocAndSourceRootDetection.findClassPackage(fileObject);
        }
        throw new IllegalArgumentException("only java or class files accepted " + fileObject);
    }

    private static FileObject findJavadocRoot(FileObject fileObject, int n) {
        FileObject fileObject2 = fileObject.getFileObject("package-list", null);
        if (fileObject2 != null) {
            return fileObject;
        }
        if (n == 5) {
            return null;
        }
        for (FileObject fileObject3 : fileObject.getChildren()) {
            if (!fileObject3.isFolder() || (fileObject3 = JavadocAndSourceRootDetection.findJavadocRoot(fileObject3, n + 1)) == null) continue;
            return fileObject3;
        }
        return null;
    }

    private static FileObject findJavaSourceFile(FileObject fileObject, int n) {
        if (n == 999) {
            return null;
        }
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (!fileObject2.isData() || !"java".equals(fileObject2.getExt())) continue;
            return fileObject2;
        }
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (!fileObject2.isFolder() || (fileObject2 = JavadocAndSourceRootDetection.findJavaSourceFile(fileObject2, n + 1)) == null) continue;
            return fileObject2;
        }
        return null;
    }

    private static FileObject findJavaPackage(FileObject fileObject) {
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream()));
            ((Reader)bufferedReader).mark(2);
            char[] cArray = new char[2];
            ((Reader)bufferedReader).read(cArray, 0, 2);
            if (cArray[0] == '\u00ff' && cArray[1] == '\u00fe') {
                ((Reader)bufferedReader).close();
                bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream(), "Unicode"));
            } else {
                ((Reader)bufferedReader).reset();
            }
            StringBuilder stringBuilder = new StringBuilder((int)fileObject.getSize());
            char[] cArray2 = new char[stringBuilder.length() + 1];
            while ((n = bufferedReader.read(cArray2)) != -1) {
                stringBuilder.append(cArray2, 0, n);
            }
            Matcher matcher = (fileObject.getNameExt().equals("package-info.java") ? PACKAGE_INFO : JAVA_FILE).matcher(stringBuilder);
            if (matcher.matches()) {
                String string = matcher.group(1);
                LOG.log(Level.FINE, "Found package declaration {0} in {1}", new Object[]{string, fileObject});
                return JavadocAndSourceRootDetection.getPackageRoot(fileObject, string);
            }
            return null;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    private static FileObject getPackageRoot(FileObject fileObject, String string) {
        String string2 = '/' + string.replace('.', '/') + '/' + fileObject.getNameExt();
        String string3 = fileObject.getPath();
        if (string3.endsWith(string2)) {
            FileObject fileObject2 = fileObject.getParent();
            String string4 = string3.substring(0, string3.length() - string2.length());
            while (!fileObject2.getPath().equals(string4)) {
                fileObject2 = fileObject2.getParent();
            }
            return fileObject2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final FileObject findClassPackage(FileObject fileObject) {
        block6: {
            FileObject fileObject2;
            InputStream inputStream = fileObject.getInputStream();
            try {
                ClassFile classFile = new ClassFile(inputStream, false);
                ClassName className = classFile.getName();
                fileObject2 = JavadocAndSourceRootDetection.getPackageRoot(fileObject, className.getPackage());
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    break block6;
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            inputStream.close();
            return fileObject2;
        }
        return null;
    }

    static {
        String string = "(?:(?://[^\n]*\n)|(?:/\\*.*?\\*/)|\\s)";
        String string2 = "(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)";
        String string3 = "package" + string + "+(" + string2 + "(?:\\." + string2 + ")*)" + string + "*;";
        JAVA_FILE = Pattern.compile("(?ms)" + string + "*" + string3 + ".*", 40);
        PACKAGE_INFO = Pattern.compile("(?ms)(?:.*" + string + ")?" + string3 + string + "*", 40);
    }
}

