/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.project.BrokenReferencesCustomizer;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokenReferencesModel
extends AbstractListModel {
    private String[] props;
    private String[] platformsProps;
    private AntProjectHelper helper;
    private ReferenceHelper resolver;
    private List<OneReference> references;
    public static final int REF_TYPE_PROJECT = 1;
    public static final int REF_TYPE_FILE = 2;
    public static final int REF_TYPE_LIBRARY = 3;
    public static final int REF_TYPE_PLATFORM = 4;
    public static final int REF_TYPE_LIBRARY_CONTENT = 5;
    public static final int REF_TYPE_VARIABLE = 6;
    public static final int REF_TYPE_VARIABLE_CONTENT = 7;

    public BrokenReferencesModel(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, String[] stringArray, String[] stringArray2) {
        this.props = stringArray;
        this.platformsProps = stringArray2;
        this.resolver = referenceHelper;
        this.helper = antProjectHelper;
        this.references = new ArrayList<OneReference>();
        this.refresh();
    }

    public void refresh() {
        LinkedHashSet<OneReference> linkedHashSet = new LinkedHashSet<OneReference>();
        Set<OneReference> set = BrokenReferencesModel.getReferences(this.helper, this.resolver, this.helper.getStandardPropertyEvaluator(), this.props, false);
        linkedHashSet.addAll(set);
        set = BrokenReferencesModel.getPlatforms(this.helper.getStandardPropertyEvaluator(), this.platformsProps, false);
        linkedHashSet.addAll(set);
        BrokenReferencesModel.updateReferencesList(this.references, linkedHashSet);
        this.fireContentsChanged(this, 0, this.getSize());
    }

    @Override
    public Object getElementAt(int n) {
        String string;
        OneReference oneReference = this.getOneReference(n);
        switch (oneReference.type) {
            case 3: {
                string = "LBL_BrokenLinksCustomizer_BrokenLibrary";
                break;
            }
            case 5: {
                string = "LBL_BrokenLinksCustomizer_BrokenLibraryContent";
                break;
            }
            case 1: {
                string = "LBL_BrokenLinksCustomizer_BrokenProjectReference";
                break;
            }
            case 2: {
                string = "LBL_BrokenLinksCustomizer_BrokenFileReference";
                break;
            }
            case 6: {
                string = "LBL_BrokenLinksCustomizer_BrokenVariable";
                break;
            }
            case 7: {
                string = "LBL_BrokenLinksCustomizer_BrokenVariableContent";
                break;
            }
            case 4: {
                string = "LBL_BrokenLinksCustomizer_BrokenPlatform";
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        return NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)string, (Object)oneReference.getDisplayID());
    }

    public String getDesciption(int n) {
        String string;
        OneReference oneReference = this.getOneReference(n);
        switch (oneReference.type) {
            case 3: {
                string = "LBL_BrokenLinksCustomizer_BrokenLibraryDesc";
                break;
            }
            case 5: {
                string = "LBL_BrokenLinksCustomizer_BrokenLibraryContentDesc";
                break;
            }
            case 1: {
                string = "LBL_BrokenLinksCustomizer_BrokenProjectReferenceDesc";
                break;
            }
            case 2: {
                string = "LBL_BrokenLinksCustomizer_BrokenFileReferenceDesc";
                break;
            }
            case 6: {
                string = "LBL_BrokenLinksCustomizer_BrokenVariableReferenceDesc";
                break;
            }
            case 7: {
                string = "LBL_BrokenLinksCustomizer_BrokenVariableContentDesc";
                break;
            }
            case 4: {
                string = "LBL_BrokenLinksCustomizer_BrokenPlatformDesc";
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        return NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)string, (Object)oneReference.getDisplayID());
    }

    public OneReference getOneReference(int n) {
        assert (n >= 0 && n < this.references.size());
        return this.references.get(n);
    }

    public boolean isBroken(int n) {
        return this.references.get(n).broken;
    }

    @Override
    public int getSize() {
        return this.references.size();
    }

    public static boolean isBroken(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, PropertyEvaluator propertyEvaluator, String[] stringArray, String[] stringArray2) {
        Set<OneReference> set = BrokenReferencesModel.getReferences(antProjectHelper, referenceHelper, propertyEvaluator, stringArray, true);
        if (set.size() > 0) {
            return true;
        }
        set = BrokenReferencesModel.getPlatforms(propertyEvaluator, stringArray2, true);
        return set.size() > 0;
    }

    private static Set<OneReference> getReferences(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, PropertyEvaluator propertyEvaluator, String[] stringArray, boolean bl) {
        Object object;
        String string;
        Object object2;
        int n;
        Object object3;
        String string2;
        Object object4;
        LinkedHashSet<OneReference> linkedHashSet = new LinkedHashSet<OneReference>();
        StringBuffer stringBuffer = new StringBuffer();
        Library[] libraryArray = LibraryManager.getDefault().getLibraries();
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        Object object5 = stringArray;
        int n2 = ((String[])object5).length;
        for (int i = 0; i < n2; ++i) {
            String string3;
            int n3;
            object4 = object5[i];
            string2 = propertyEvaluator.getProperty((String)object4);
            if (string2 == null) continue;
            object3 = PropertyUtils.tokenizePath((String)string2);
            String[] stringArray2 = object3;
            n = stringArray2.length;
            for (n3 = 0; n3 < n; ++n3) {
                object2 = stringArray2[n3];
                if (!(((String)object2).startsWith("${file.reference.") || ((String)object2).startsWith("${project.") || ((String)object2).startsWith("${libs.") || ((String)object2).startsWith("${var."))) {
                    stringBuffer.append((String)object2);
                    continue;
                }
                if (((String)object2).startsWith("${project.")) {
                    string = ((String)object2).substring(2, ((String)object2).indexOf(125));
                    linkedHashSet.add(new OneReference(1, string, true));
                } else {
                    int n4 = 3;
                    if (((String)object2).startsWith("${file.reference")) {
                        n4 = 2;
                    } else if (((String)object2).startsWith("${var")) {
                        n4 = 6;
                    }
                    string3 = ((String)object2).substring(2, ((String)object2).length() - 1);
                    linkedHashSet.add(new OneReference(n4, string3, true));
                }
                if (bl) break;
            }
            if (linkedHashSet.size() > 0 && bl) break;
            String object22 = editableProperties.getProperty((String)object4);
            if (object22 == null) continue;
            String[] stringArray3 = PropertyUtils.tokenizePath((String)object22);
            n3 = stringArray3.length;
            for (int j = 0; j < n3; ++j) {
                string = stringArray3[j];
                if (string.startsWith("${file.reference.")) {
                    string = editableProperties.getProperty(string.substring(2, string.length() - 1));
                }
                if (string == null || !string.startsWith("${var.") || (string3 = propertyEvaluator.evaluate(string)).startsWith("${var.") || ((File)(object = BrokenReferencesModel.getFile(antProjectHelper, propertyEvaluator, string3))).exists()) continue;
                linkedHashSet.add(new OneReference(7, string, true));
            }
        }
        if ((object5 = propertyEvaluator.getProperties()) == null) {
            throw new IllegalArgumentException("Properies mapping could not be computed (e.g. due to a circular definition). Evaluator: " + propertyEvaluator.toString());
        }
        for (Map.Entry entry : object5.entrySet()) {
            object4 = (String)entry.getKey();
            string2 = (String)entry.getValue();
            if (((String)object4).startsWith("project.")) {
                if ("project.license".equals(object4) || ((File)(object3 = BrokenReferencesModel.getFile(antProjectHelper, propertyEvaluator, string2))).exists() || stringBuffer.indexOf(string2) == -1) continue;
                linkedHashSet.add(new OneReference(1, (String)object4, true));
                continue;
            }
            if (!((String)object4).startsWith("file.reference")) continue;
            object3 = BrokenReferencesModel.getFile(antProjectHelper, propertyEvaluator, string2);
            String string4 = editableProperties.getProperty((String)object4);
            int n5 = n = string4 != null ? (int)(string4.startsWith("${var.") ? 1 : 0) : 0;
            if (((File)object3).exists() || stringBuffer.indexOf(string2) == -1 || n != 0) continue;
            linkedHashSet.add(new OneReference(2, (String)object4, true));
        }
        HashSet hashSet = new HashSet();
        Pattern pattern = Pattern.compile("\\$\\{(libs\\.[-._a-zA-Z0-9]+\\.classpath)\\}");
        for (String string5 : stringArray) {
            String string6 = editableProperties.getProperty(string5);
            if (string6 == null) continue;
            for (String string3 : PropertyUtils.tokenizePath((String)string6)) {
                object = pattern.matcher(string3);
                if (!((Matcher)object).matches()) continue;
                hashSet.add(((Matcher)object).group(1));
            }
        }
        object4 = hashSet.iterator();
        block6: while (object4.hasNext()) {
            String string6 = (String)object4.next();
            String string7 = string6.substring(5, string6.length() - 10);
            Library library = referenceHelper.findLibrary(string7);
            if (library == null) {
                linkedHashSet.add(new OneReference(3, string6, true));
                continue;
            }
            for (URI uRI : library.getURIContent("classpath")) {
                object2 = LibrariesSupport.getArchiveFile((URI)uRI);
                if (object2 == null) {
                    object2 = uRI;
                }
                if (null != (string = LibrariesSupport.resolveLibraryEntryFileObject((URL)library.getManager().getLocation(), (URI)object2)) || BrokenReferencesModel.canResolveEvaluatedUri(antProjectHelper.getStandardPropertyEvaluator(), library.getManager().getLocation(), (URI)object2)) continue;
                linkedHashSet.add(new OneReference(5, string6, true));
                continue block6;
            }
        }
        return linkedHashSet;
    }

    private static boolean canResolveEvaluatedUri(PropertyEvaluator propertyEvaluator, URL uRL, URI uRI) {
        if (uRI.isAbsolute()) {
            return false;
        }
        String string = LibrariesSupport.convertURIToFilePath((URI)uRI);
        String string2 = propertyEvaluator.evaluate(string);
        if (string2.equals(string)) {
            return false;
        }
        URI uRI2 = LibrariesSupport.convertFilePathToURI((String)string2);
        return null != LibrariesSupport.resolveLibraryEntryFileObject((URL)uRL, (URI)uRI2);
    }

    private static File getFile(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, String string) {
        if (antProjectHelper != null) {
            return new File(antProjectHelper.resolvePath(string));
        }
        File file = new File(string);
        if (!file.exists()) {
            String string2 = propertyEvaluator.getProperty("basedir");
            assert (string2 != null);
            file = new File(new File(string2), string);
        }
        return file;
    }

    private static Set<OneReference> getPlatforms(PropertyEvaluator propertyEvaluator, String[] stringArray, boolean bl) {
        LinkedHashSet<OneReference> linkedHashSet = new LinkedHashSet<OneReference>();
        for (String string : stringArray) {
            String string2 = propertyEvaluator.getProperty(string);
            if (string2 == null) continue;
            if (!BrokenReferencesModel.existPlatform(string2)) {
                if (propertyEvaluator.getProperty(string + ".description") != null) {
                    string2 = propertyEvaluator.getProperty(string + ".description");
                }
                linkedHashSet.add(new OneReference(4, string2, true));
            }
            if (linkedHashSet.size() > 0 && bl) break;
        }
        return linkedHashSet;
    }

    private static void updateReferencesList(List<OneReference> list, Set<OneReference> set) {
        for (OneReference oneReference : list) {
            if (set.contains(oneReference)) {
                oneReference.broken = true;
                continue;
            }
            oneReference.broken = false;
        }
        for (OneReference oneReference : set) {
            if (list.contains(oneReference)) continue;
            list.add(oneReference);
        }
    }

    private static boolean existPlatform(String string) {
        if (string.equals("default_platform")) {
            return true;
        }
        for (JavaPlatform javaPlatform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            if (!string.equals(javaPlatform.getProperties().get("platform.ant.name")) || javaPlatform.getInstallFolders().size() <= 0) continue;
            return true;
        }
        return false;
    }

    void updateReference(int n, File file) {
        this.updateReference0(n, file);
        OneReference oneReference = this.getOneReference(n);
        if (oneReference.getType() != 2) {
            return;
        }
        for (int i = 0; i < this.getSize(); ++i) {
            File file2;
            if (!this.isBroken(i) || i == n || (oneReference = this.getOneReference(i)).getType() != 2 || !(file2 = new File(file.getParentFile(), oneReference.getDisplayID())).exists()) continue;
            this.updateReference0(i, file2);
        }
    }

    private void updateReference0(int n, File file) {
        Project project;
        final String string = this.getOneReference(n).ID;
        FileObject fileObject = this.helper.getProjectDirectory();
        File file2 = FileUtil.toFile((FileObject)fileObject);
        final String string2 = file.getAbsolutePath();
        try {
            project = ProjectManager.getDefault().findProject(fileObject);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            project = null;
        }
        final Project project2 = project;
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                EditableProperties editableProperties = BrokenReferencesModel.this.helper.getProperties("nbproject/private/private.properties");
                if (!string2.equals(editableProperties.getProperty(string))) {
                    editableProperties.setProperty(string, string2);
                    BrokenReferencesModel.this.helper.putProperties("nbproject/private/private.properties", editableProperties);
                }
                if (project2 != null) {
                    try {
                        ProjectManager.getDefault().saveProject(project2);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
        });
    }

    LibraryManager getProjectLibraryManager() {
        return this.resolver.getProjectLibraryManager() != null ? this.resolver.getProjectLibraryManager() : LibraryManager.getDefault();
    }

    public static class OneReference {
        private int type;
        private boolean broken;
        private String ID;

        public OneReference(int n, String string, boolean bl) {
            this.type = n;
            this.ID = string;
            this.broken = bl;
        }

        public int getType() {
            return this.type;
        }

        public String getDisplayID() {
            switch (this.type) {
                case 3: 
                case 5: {
                    return this.ID.substring(5, this.ID.length() - 10);
                }
                case 1: {
                    return this.ID.substring(8);
                }
                case 2: {
                    return this.ID.substring(15);
                }
                case 4: {
                    return this.ID;
                }
                case 6: {
                    return this.ID.substring(4, this.ID.indexOf("}"));
                }
                case 7: {
                    return this.ID.substring(6, this.ID.indexOf("}")) + this.ID.substring(this.ID.indexOf("}") + 1);
                }
            }
            assert (false);
            return this.ID;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof OneReference)) {
                return false;
            }
            OneReference oneReference = (OneReference)object;
            return this.type == oneReference.type && this.ID.equals(oneReference.ID);
        }

        public int hashCode() {
            int n = 7 * this.type;
            n = 31 * n + this.ID.hashCode();
            return n;
        }
    }
}

