/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CsmRefactoringUtils {
    public static final boolean REFACTORING_EXTRA = CndUtils.getBoolean((String)"cnd.refactoring.extra", (boolean)false);

    private CsmRefactoringUtils() {
    }

    public static boolean isElementInOpenProject(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        return OpenProjects.getDefault().isProjectOpen(project);
    }

    public static boolean isRefactorable(FileObject fileObject) {
        return fileObject == null || FileUtil.getArchiveFile((FileObject)fileObject) == null && fileObject.canWrite();
    }

    public static CsmObject convertToCsmObjectIfNeeded(CsmObject csmObject) {
        CsmFunction csmFunction;
        if (CsmKindUtilities.isInclude((CsmObject)csmObject)) {
            csmObject = ((CsmInclude)csmObject).getIncludeFile();
        } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject) && (csmFunction = CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)csmObject))) != null) {
            csmObject = csmFunction;
        }
        return csmObject;
    }

    public static Collection<CsmProject> getContextCsmProjects(CsmObject csmObject) {
        HashSet<CsmProject> hashSet = new HashSet<CsmProject>();
        CsmFile csmFile = null;
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            csmFile = ((CsmOffsetable)csmObject).getContainingFile();
        } else if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            csmFile = (CsmFile)csmObject;
        }
        CsmProject csmProject = null;
        if (csmFile != null) {
            csmProject = csmFile.getProject();
            hashSet.add(csmProject);
        } else if (CsmKindUtilities.isNamespace((Object)csmObject)) {
            hashSet.add(((CsmNamespace)csmObject).getProject());
        }
        return hashSet;
    }

    public static Collection<CsmProject> getRelatedCsmProjects(CsmObject csmObject, CsmProject csmProject) {
        Collection<Object> collection = Collections.emptyList();
        if (csmProject != null) {
            collection = Collections.singleton(csmProject);
        } else {
            Collection collection2 = CsmModelAccessor.getModel().projects();
            collection = new HashSet(collection2);
        }
        return collection;
    }

    public static Collection<Project> getContextProjects(CsmObject csmObject) {
        Collection<CsmProject> collection = CsmRefactoringUtils.getContextCsmProjects(csmObject);
        ArrayList<Project> arrayList = new ArrayList<Project>();
        for (CsmProject csmProject : collection) {
            if (csmProject == null) continue;
            Object object = csmProject.getPlatformProject();
            if (object instanceof NativeProject) {
                object = ((NativeProject)object).getProject();
            }
            if (!(object instanceof Project)) continue;
            arrayList.add((Project)object);
        }
        return arrayList;
    }

    public static CsmObject getReferencedElement(CsmObject csmObject) {
        if (csmObject instanceof CsmReference) {
            return CsmRefactoringUtils.getReferencedElement(((CsmReference)csmObject).getReferencedObject());
        }
        return csmObject;
    }

    public static String getSimpleText(CsmObject csmObject) {
        String string = "";
        if (csmObject != null) {
            if (CsmKindUtilities.isNamedElement((CsmObject)csmObject)) {
                string = ((Object)((CsmNamedElement)csmObject).getName()).toString();
            } else if (CsmKindUtilities.isStatement((CsmObject)csmObject)) {
                string = ((Object)((CsmStatement)csmObject).getText()).toString();
            } else if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
                string = ((Object)((CsmOffsetable)csmObject).getText()).toString();
            }
        }
        return string;
    }

    public static FileObject getFileObject(CsmObject csmObject) {
        CsmFile csmFile = null;
        if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            csmFile = (CsmFile)csmObject;
        } else if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            csmFile = ((CsmOffsetable)csmObject).getContainingFile();
        }
        return csmFile == null ? null : CsmUtilities.getFileObject((CsmFile)csmFile);
    }

    public static CsmObject findContextObject(Lookup lookup) {
        CsmObject csmObject = (CsmObject)lookup.lookup(CsmObject.class);
        if (csmObject == null) {
            Node node;
            CsmUID csmUID = (CsmUID)lookup.lookup(CsmUID.class);
            if (csmUID != null) {
                csmObject = (CsmObject)csmUID.getObject();
            }
            if (csmObject == null && (node = (Node)lookup.lookup(Node.class)) != null) {
                csmObject = CsmReferenceResolver.getDefault().findReference(node);
            }
        }
        return csmObject;
    }

    public static <T extends CsmObject> CsmUID<T> getHandler(T t) {
        return t == null ? null : UIDs.get(t);
    }

    public static <T> T getObject(CsmUID<T> csmUID) {
        return (T)(csmUID == null ? null : csmUID.getObject());
    }

    public static boolean isSupportedReference(CsmObject csmObject) {
        return csmObject != null;
    }

    public static String getHtml(CsmObject csmObject) {
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return CsmRefactoringUtils.getHtml((CsmOffsetable)csmObject);
        }
        if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            return CsmDisplayUtilities.htmlize((CharSequence)((Object)((CsmFile)csmObject).getName()).toString());
        }
        return csmObject.toString();
    }

    public static CsmFile getCsmFile(CsmObject csmObject) {
        if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            return (CsmFile)csmObject;
        }
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return ((CsmOffsetable)csmObject).getContainingFile();
        }
        return null;
    }

    public static Collection<CsmFunction> getConstructors(CsmClass csmClass) {
        ArrayList<CsmFunction> arrayList = new ArrayList<CsmFunction>();
        CsmSelect.CsmFilterBuilder csmFilterBuilder = CsmSelect.getFilterBuilder();
        CsmSelect.CsmFilter csmFilter = csmFilterBuilder.createCompoundFilter(csmFilterBuilder.createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION}), csmFilterBuilder.createNameFilter(csmClass.getName(), true, true, false));
        Iterator iterator = CsmSelect.getClassMembers((CsmClass)csmClass, (CsmSelect.CsmFilter)csmFilter);
        while (iterator.hasNext()) {
            CsmMember csmMember = (CsmMember)iterator.next();
            if (!CsmKindUtilities.isConstructor((CsmObject)csmMember)) continue;
            arrayList.add((CsmFunction)((CsmConstructor)csmMember));
        }
        return arrayList;
    }

    public static CsmObject getEnclosingElement(CsmObject csmObject) {
        assert (csmObject != null);
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return CsmRefactoringUtils.findInnerFileObject((CsmOffsetable)csmObject);
        }
        return null;
    }

    static boolean isLangContainerFeature(CsmObject csmObject) {
        assert (csmObject != null);
        return CsmKindUtilities.isFunction((CsmObject)csmObject) || CsmKindUtilities.isClass((CsmObject)csmObject) || CsmKindUtilities.isEnum((CsmObject)csmObject) || CsmKindUtilities.isNamespaceDefinition((CsmObject)csmObject) || CsmKindUtilities.isFile((CsmObject)csmObject);
    }

    private static String getHtml(CsmOffsetable csmOffsetable) {
        CsmFile csmFile = csmOffsetable.getContainingFile();
        CloneableEditorSupport cloneableEditorSupport = CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
        BaseDocument baseDocument = null;
        String string = null;
        if (cloneableEditorSupport != null && cloneableEditorSupport.getDocument() instanceof BaseDocument) {
            baseDocument = (BaseDocument)cloneableEditorSupport.getDocument();
            try {
                int n = csmOffsetable.getStartOffset();
                int n2 = csmOffsetable.getEndOffset();
                int n3 = 1;
                if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetable) || CsmKindUtilities.isEnum((CsmObject)csmOffsetable)) {
                    n2 = n;
                    n3 = 0;
                } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmOffsetable)) {
                    n2 = ((CsmFunctionDefinition)csmOffsetable).getBody().getStartOffset() - 1;
                } else if (CsmKindUtilities.isClass((CsmObject)csmOffsetable)) {
                    n2 = ((CsmClass)csmOffsetable).getLeftBracketOffset() - 1;
                }
                int n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                int n5 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n2) + n3;
                string = CsmDisplayUtilities.getLineHtml((int)n4, (int)n5, (int)-1, (int)-1, (BaseDocument)baseDocument);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (string == null) {
            string = CsmDisplayUtilities.htmlize((CharSequence)((Object)csmOffsetable.getText()).toString());
        }
        return string;
    }

    private static boolean isInObject(CsmObject csmObject, int n) {
        if (!CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return false;
        }
        CsmOffsetable csmOffsetable = (CsmOffsetable)csmObject;
        return csmOffsetable.getStartOffset() <= n && n <= csmOffsetable.getEndOffset();
    }

    public static boolean isBeforeObject(CsmObject csmObject, int n) {
        if (!CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return false;
        }
        CsmOffsetable csmOffsetable = (CsmOffsetable)csmObject;
        return n < csmOffsetable.getStartOffset();
    }

    public static CsmObject findInnerFileObject(CsmFile csmFile, int n) {
        assert (csmFile != null) : "can't be null file in findInnerFileObject";
        CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createOffsetFilter(n);
        CsmDeclaration csmDeclaration = CsmRefactoringUtils.findInnerDeclaration(CsmSelect.getDeclarations((CsmFile)csmFile, (CsmSelect.CsmFilter)csmFilter), n);
        return csmDeclaration;
    }

    private static CsmDeclaration findInnerDeclaration(Iterator<? extends CsmDeclaration> iterator, int n) {
        CsmDeclaration csmDeclaration = null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                CsmDeclaration csmDeclaration2 = iterator.next();
                assert (csmDeclaration2 != null) : "can't be null declaration";
                if (CsmRefactoringUtils.isInObject((CsmObject)csmDeclaration2, n) && CsmRefactoringUtils.isLangContainerFeature((CsmObject)csmDeclaration2)) {
                    csmDeclaration = CsmRefactoringUtils.findInnerDeclaration(csmDeclaration2, n);
                    if (csmDeclaration != null) {
                        return csmDeclaration;
                    }
                    return csmDeclaration2;
                }
                if (!CsmRefactoringUtils.isBeforeObject((CsmObject)csmDeclaration2, n)) continue;
                break;
            }
        }
        return csmDeclaration;
    }

    private static CsmDeclaration findInnerDeclaration(CsmDeclaration csmDeclaration, int n) {
        assert (CsmRefactoringUtils.isInObject((CsmObject)csmDeclaration, n)) : "must be in outDecl object!";
        Iterator iterator = null;
        if (CsmKindUtilities.isNamespace((Object)csmDeclaration)) {
            CsmNamespace csmNamespace = (CsmNamespace)csmDeclaration;
            iterator = csmNamespace.getDeclarations().iterator();
        } else if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmDeclaration)) {
            iterator = ((CsmNamespaceDefinition)csmDeclaration).getDeclarations().iterator();
        } else if (CsmKindUtilities.isClass((CsmObject)csmDeclaration)) {
            CsmClass csmClass = (CsmClass)csmDeclaration;
            iterator = csmClass.getMembers().iterator();
        } else if (CsmKindUtilities.isEnum((CsmObject)csmDeclaration)) {
            CsmEnum csmEnum = (CsmEnum)csmDeclaration;
            iterator = csmEnum.getEnumerators().iterator();
        }
        return CsmRefactoringUtils.findInnerDeclaration(iterator, n);
    }

    private static CsmObject findInnerFileObject(CsmOffsetable csmOffsetable) {
        CsmObject csmObject = CsmRefactoringUtils.findInnerFileObject(csmOffsetable.getContainingFile(), csmOffsetable.getStartOffset() - 1);
        if (csmObject == null) {
            csmObject = csmOffsetable.getContainingFile();
        }
        return csmObject;
    }
}

