/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.introduce;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.refactoring.introduce.ErrorLabel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class IntroduceVariablePanel
extends JPanel {
    private static final int ACCESS_PUBLIC = 1;
    private static final int ACCESS_PROTECTED = 2;
    private static final int ACCESS_PRIVATE = 4;
    private boolean introduceConstant;
    private JButton btnOk;
    private ButtonGroup accessGroup;
    private JRadioButton accessPrivate;
    private JRadioButton accessProtected;
    private JRadioButton accessPublic;
    private JCheckBox declareFinal;
    private JLabel errorLabel;
    private JLabel lblAccess;
    private JLabel lblName;
    private JTextField name;
    private JCheckBox replaceAll;
    private CsmVisibility testAccess;

    public IntroduceVariablePanel(int n, String string, boolean bl, JButton jButton) {
        this.btnOk = jButton;
        this.initComponents();
        this.introduceConstant = bl;
        this.lblAccess.setVisible(bl);
        this.accessPublic.setVisible(bl);
        this.accessProtected.setVisible(bl);
        this.accessPrivate.setVisible(bl);
        Preferences preferences = this.getPreferences(bl);
        if (n == 1) {
            this.replaceAll.setEnabled(false);
            this.replaceAll.setSelected(false);
        } else {
            this.replaceAll.setEnabled(true);
            this.replaceAll.setText(this.replaceAll.getText() + " (" + n + ")");
            this.replaceAll.setSelected(preferences.getBoolean("replaceAll", true));
        }
        this.declareFinal.setEnabled(!bl);
        this.declareFinal.setSelected(bl ? true : preferences.getBoolean("declareFinal", true));
        if (!bl) {
            int n2 = preferences.getInt("accessModifier", 1);
            switch (n2) {
                case 1: {
                    this.accessPublic.setSelected(true);
                    break;
                }
                case 2: {
                    this.accessProtected.setSelected(true);
                    break;
                }
                case 4: {
                    this.accessPrivate.setSelected(true);
                }
            }
        }
        if (bl) {
            this.name.setText(string.toUpperCase());
        } else {
            this.name.setText(string);
        }
        if (this.name != null && string.trim().length() > 0) {
            this.name.setCaretPosition(string.length());
            this.name.setSelectionStart(0);
            this.name.setSelectionEnd(string.length());
        }
    }

    private Preferences getPreferences(boolean bl) {
        return NbPreferences.forModule(IntroduceVariablePanel.class).node(bl ? "introduceConstant" : "introduceVariable");
    }

    private JLabel createErrorLabel() {
        ErrorLabel.Validator validator = new ErrorLabel.Validator(){

            public String validate(String string) {
                if (null == string || string.length() == 0) {
                    return "";
                }
                if (!CndLexerUtilities.isCppIdentifier((CharSequence)string)) {
                    return IntroduceVariablePanel.this.getDefaultErrorMessage(string);
                }
                return null;
            }
        };
        final ErrorLabel errorLabel = new ErrorLabel(this.name.getDocument(), validator);
        errorLabel.addPropertyChangeListener("isValid", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                IntroduceVariablePanel.this.btnOk.setEnabled(errorLabel.isInputTextValid());
            }
        });
        return errorLabel;
    }

    String getDefaultErrorMessage(String string) {
        return "'" + string + "' is not a valid identifier";
    }

    private void initComponents() {
        this.accessGroup = new ButtonGroup();
        this.lblName = new JLabel();
        this.name = new JTextField();
        this.replaceAll = new JCheckBox();
        this.declareFinal = new JCheckBox();
        this.lblAccess = new JLabel();
        this.accessPublic = new JRadioButton();
        this.accessProtected = new JRadioButton();
        this.accessPrivate = new JRadioButton();
        this.errorLabel = this.createErrorLabel();
        this.lblName.setLabelFor(this.name);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getBundle(IntroduceVariablePanel.class).getString("LBL_Name"));
        this.name.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.replaceAll, (String)NbBundle.getBundle(IntroduceVariablePanel.class).getString("LBL_ReplaceAll"));
        this.replaceAll.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.declareFinal, (String)NbBundle.getBundle(IntroduceVariablePanel.class).getString("LBL_DeclareFinal"));
        this.declareFinal.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.lblAccess, (String)NbBundle.getMessage(IntroduceVariablePanel.class, (String)"LBL_Access"));
        this.accessGroup.add(this.accessPublic);
        this.accessPublic.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.accessPublic, (String)NbBundle.getMessage(IntroduceVariablePanel.class, (String)"LBL_public"));
        this.accessPublic.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessProtected);
        Mnemonics.setLocalizedText((AbstractButton)this.accessProtected, (String)NbBundle.getMessage(IntroduceVariablePanel.class, (String)"LBL_protected"));
        this.accessProtected.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessPrivate);
        Mnemonics.setLocalizedText((AbstractButton)this.accessPrivate, (String)NbBundle.getMessage(IntroduceVariablePanel.class, (String)"LBL_private"));
        this.accessPrivate.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)NbBundle.getMessage(IntroduceVariablePanel.class, (String)"IntroduceVariablePanel.errorLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.errorLabel, -1, 486, Short.MAX_VALUE).add((Component)this.replaceAll).add((Component)this.declareFinal).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblAccess).add((Component)this.lblName)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.name, -1, 425, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.accessPublic).addPreferredGap(0).add((Component)this.accessProtected).addPreferredGap(0).add((Component)this.accessPrivate))))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblName).add((Component)this.name, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblAccess).add((Component)this.accessPublic).add((Component)this.accessProtected).add((Component)this.accessPrivate)).addPreferredGap(0).add((Component)this.declareFinal).addPreferredGap(0).add((Component)this.replaceAll).addPreferredGap(0, 32, Short.MAX_VALUE).add((Component)this.errorLabel).addContainerGap()));
        this.name.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_Name"));
        this.replaceAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_ReplaceAllOccurences"));
        this.declareFinal.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_DeclareFinal"));
        this.accessPublic.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_Public"));
        this.accessProtected.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_Protected"));
        this.accessPrivate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_Private"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_Dialog"));
    }

    public String getVariableName() {
        return this.name.getText();
    }

    public boolean isReplaceAll() {
        boolean bl = this.replaceAll.isSelected();
        this.getPreferences(this.introduceConstant).putBoolean("replaceAll", bl);
        return bl;
    }

    public boolean isDeclareFinal() {
        boolean bl = this.declareFinal.isSelected();
        this.getPreferences(this.introduceConstant).putBoolean("declareFinal", bl);
        return bl;
    }

    public CsmVisibility getAccess() {
        CsmVisibility csmVisibility;
        int n;
        if (this.testAccess != null) {
            return this.testAccess;
        }
        if (this.accessPublic.isSelected()) {
            n = 1;
            csmVisibility = CsmVisibility.PUBLIC;
        } else if (this.accessProtected.isSelected()) {
            n = 2;
            csmVisibility = CsmVisibility.PROTECTED;
        } else {
            n = 4;
            csmVisibility = CsmVisibility.PRIVATE;
        }
        this.getPreferences(this.introduceConstant).putInt("accessModifier", n);
        return csmVisibility;
    }

    void setVariableName(String string) {
        this.name.setText(string);
    }

    void setDeclareFinal(boolean bl) {
        this.declareFinal.setSelected(bl);
    }

    void setReplaceAll(boolean bl) {
        this.replaceAll.setSelected(bl);
    }

    void setAccess(CsmVisibility csmVisibility) {
        this.testAccess = csmVisibility;
    }
}

