/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type {
    protected Type() {
    }

    protected static void append(StringBuilder sb, String prefix, List<? extends Type> types, String suffix) {
        sb.append(prefix);
        String sep = "";
        for (Type type : types) {
            sb.append(sep);
            sb.append(type);
            sep = ", ";
        }
        sb.append(suffix);
    }

    protected static void appendIfNotEmpty(StringBuilder sb, String prefix, List<? extends Type> types, String suffix) {
        if (types != null && types.size() > 0) {
            Type.append(sb, prefix, types, suffix);
        }
    }

    public static class WildcardType
    extends Type {
        public final String kind;
        public final Type boundType;

        public WildcardType() {
            this(null, null);
        }

        public WildcardType(String kind, Type boundType) {
            this.kind = kind;
            this.boundType = boundType;
        }

        public String toString() {
            if (this.kind == null) {
                return "?";
            }
            return "? " + this.kind + " " + this.boundType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeArgType
    extends Type {
        public final String name;
        public final Type classBound;
        public final List<Type> interfaceBounds;

        public TypeArgType(String name, Type classBound, List<Type> interfaceBounds) {
            this.name = name;
            this.classBound = classBound;
            this.interfaceBounds = interfaceBounds;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name);
            String sep = " extends ";
            if (this.classBound != null) {
                sb.append(sep);
                sb.append(this.classBound);
                sep = " & ";
            }
            if (this.interfaceBounds != null) {
                for (Type bound : this.interfaceBounds) {
                    sb.append(sep);
                    sb.append(bound);
                    sep = " & ";
                }
            }
            return sb.toString();
        }
    }

    public static class InnerClassType
    extends Type {
        public final Type outerType;
        public final Type innerType;

        public InnerClassType(Type outerType, Type innerType) {
            this.outerType = outerType;
            this.innerType = innerType;
        }

        public String toString() {
            return this.outerType + "." + this.innerType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassType
    extends Type {
        public final String name;
        public final List<Type> typeArgs;

        public ClassType(String name, List<Type> typeArgs) {
            this.name = name;
            this.typeArgs = typeArgs;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name);
            ClassType.appendIfNotEmpty(sb, "<", this.typeArgs, ">");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassSigType
    extends Type {
        public final List<Type> typeArgTypes;
        public final Type superclassType;
        public final List<Type> superinterfaceTypes;

        public ClassSigType(List<Type> typeArgTypes, Type superclassType, List<Type> superinterfaceTypes) {
            this.typeArgTypes = typeArgTypes;
            this.superclassType = superclassType;
            this.superinterfaceTypes = superinterfaceTypes;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            ClassSigType.appendIfNotEmpty(sb, "<", this.typeArgTypes, ">");
            if (this.superclassType != null) {
                sb.append(" extends ");
                sb.append(this.superclassType);
            }
            ClassSigType.appendIfNotEmpty(sb, " implements ", this.superinterfaceTypes, "");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodType
    extends Type {
        public final List<? extends Type> typeArgTypes;
        public final List<? extends Type> argTypes;
        public final Type returnType;
        public final List<? extends Type> throwsTypes;

        public MethodType(List<? extends Type> argTypes, Type resultType) {
            this(null, argTypes, resultType, null);
        }

        public MethodType(List<? extends Type> typeArgTypes, List<? extends Type> argTypes, Type returnType, List<? extends Type> throwsTypes) {
            this.typeArgTypes = typeArgTypes;
            this.argTypes = argTypes;
            this.returnType = returnType;
            this.throwsTypes = throwsTypes;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            MethodType.appendIfNotEmpty(sb, "<", this.typeArgTypes, "> ");
            sb.append(this.returnType);
            MethodType.append(sb, " (", this.argTypes, ")");
            MethodType.appendIfNotEmpty(sb, " throws ", this.throwsTypes, "");
            return sb.toString();
        }
    }

    public static class ArrayType
    extends Type {
        public final Type elemType;

        public ArrayType(Type elemType) {
            this.elemType = elemType;
        }

        public String toString() {
            return this.elemType + "[]";
        }
    }

    public static class SimpleType
    extends Type {
        public final String name;

        public SimpleType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

