/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APTFileCacheEntry {
    private final Map<Integer, IncludeData> cache;
    private final Map<Integer, Boolean> evalData;
    private final CharSequence filePath;
    private final boolean serial;
    private static volatile int includeHits = 0;
    private static volatile int evalHits = 0;

    private APTFileCacheEntry(CharSequence charSequence, boolean bl, Map<Integer, IncludeData> map, Map<Integer, Boolean> map2) {
        assert (charSequence != null);
        this.filePath = charSequence;
        this.serial = bl;
        this.cache = map;
        this.evalData = map2;
    }

    static APTFileCacheEntry toSerial(APTFileCacheEntry aPTFileCacheEntry) {
        return new APTFileCacheEntry(aPTFileCacheEntry.filePath, true, new HashMap<Integer, IncludeData>(aPTFileCacheEntry.cache), new HashMap<Integer, Boolean>(aPTFileCacheEntry.evalData));
    }

    static APTFileCacheEntry createConcurrentEntry(CharSequence charSequence) {
        return APTFileCacheEntry.create(charSequence, false);
    }

    static APTFileCacheEntry createSerialEntry(CharSequence charSequence) {
        return APTFileCacheEntry.create(charSequence, true);
    }

    private static APTFileCacheEntry create(CharSequence charSequence, boolean bl) {
        return new APTFileCacheEntry(charSequence, bl, bl ? new HashMap() : new ConcurrentHashMap(), bl ? new HashMap() : new ConcurrentHashMap());
    }

    public boolean isSerial() {
        return this.serial;
    }

    APTMacroMap.State getPostIncludeMacroState(APTInclude aPTInclude) {
        IncludeData includeData = this.getIncludeData(aPTInclude);
        assert (includeData != null);
        if (includeData.postIncludeMacroState != null && APTTraceFlags.TRACE_APT_CACHE && this.needTraceValue(++includeHits)) {
            System.err.println("INCLUDE HIT " + includeHits + " cache for line:" + aPTInclude.getToken().getLine() + " in " + this.filePath);
        }
        return includeData.postIncludeMacroState;
    }

    void setPostIncludeMacroState(APTInclude aPTInclude, APTMacroMap.State state) {
        IncludeData includeData = this.getIncludeData(aPTInclude);
        assert (includeData.postIncludeMacroState == null);
        includeData.postIncludeMacroState = state;
    }

    Object getIncludeLock(APTInclude aPTInclude) {
        return this.getIncludeData(aPTInclude);
    }

    Boolean getEvalResult(APT aPT) {
        Boolean bl = this.evalData.get(aPT.getOffset());
        if (APTTraceFlags.TRACE_APT_CACHE && bl != null && this.needTraceValue(evalHits++)) {
            System.err.println("EVAL HIT " + evalHits + " cache for line:" + aPT.getToken().getLine() + " as " + bl + " in " + this.filePath);
        }
        return bl;
    }

    void setEvalResult(APT aPT, boolean bl) {
        this.evalData.put(aPT.getOffset(), bl);
    }

    private IncludeData getIncludeData(APTInclude aPTInclude) {
        Integer n = aPTInclude.getOffset();
        IncludeData includeData = this.cache.get(n);
        if (includeData == null) {
            IncludeData includeData2;
            includeData = new IncludeData(null);
            IncludeData includeData3 = includeData2 = this.serial ? this.cache.put(n, includeData) : ((ConcurrentMap)this.cache).putIfAbsent(n, includeData);
            if (includeData2 != null) {
                includeData = includeData2;
            }
        }
        return includeData;
    }

    public CharSequence getFilePath() {
        return this.filePath;
    }

    public String toString() {
        return "APT cache for " + this.filePath;
    }

    private boolean needTraceValue(int n) {
        return n % 10 == 0;
    }

    private static final class IncludeData {
        private volatile APTMacroMap.State postIncludeMacroState;

        public IncludeData(APTMacroMap.State state) {
            this.postIncludeMacroState = state;
        }
    }
}

