/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.utils.cache.TextCache;
import org.netbeans.modules.cnd.utils.cache.TinyCharSequence;

public class APTBaseToken
implements APTToken {
    private static final long serialVersionUID = 2834353662691067170L;
    protected int line;
    protected CharSequence text = null;
    protected int col;
    protected int type;
    private int offset;

    public APTBaseToken() {
    }

    public APTBaseToken(APTToken aPTToken) {
        this(aPTToken, aPTToken.getType());
    }

    public APTBaseToken(APTToken aPTToken, int n) {
        this.setColumn(aPTToken.getColumn());
        this.setFilename(aPTToken.getFilename());
        this.setLine(aPTToken.getLine());
        this.text = aPTToken.getTextID();
        assert (this.text instanceof TinyCharSequence);
        this.setType(n);
        this.setOffset(aPTToken.getOffset());
        this.setEndOffset(aPTToken.getEndOffset());
        this.setEndColumn(aPTToken.getEndColumn());
        this.setEndLine(aPTToken.getEndLine());
        this.setTextID(aPTToken.getTextID());
    }

    public APTBaseToken(String string) {
        this.setText(string);
    }

    public final int getType() {
        return this.type;
    }

    public final void setType(int n) {
        this.type = n;
    }

    public String getFilename() {
        return null;
    }

    public void setFilename(String string) {
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    public int getEndOffset() {
        return this.getOffset() + this.getTextID().length();
    }

    public void setEndOffset(int n) {
    }

    public final CharSequence getTextID() {
        return this.text;
    }

    public final void setTextID(CharSequence charSequence) {
        this.text = TextCache.getManager().getString(charSequence);
    }

    public final String getText() {
        return ((Object)this.text).toString();
    }

    public final void setText(String string) {
        this.text = TextCache.getManager().getString((CharSequence)string);
    }

    public final int getLine() {
        return this.line;
    }

    public final void setLine(int n) {
        this.line = n;
    }

    public final int getColumn() {
        return this.col;
    }

    public final void setColumn(int n) {
        this.col = n;
    }

    public String toString() {
        return "[\"" + this.getTextID() + "\",<" + this.getType() + ">,line=" + this.getLine() + ",col=" + this.getColumn() + "]" + ",offset=" + this.getOffset() + ",file=" + this.getFilename();
    }

    public int getEndColumn() {
        return this.getColumn() + this.getTextID().length();
    }

    public void setEndColumn(int n) {
    }

    public int getEndLine() {
        return this.getLine();
    }

    public void setEndLine(int n) {
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        APTBaseToken aPTBaseToken = (APTBaseToken)object;
        if (this.getType() != aPTBaseToken.getType()) {
            return false;
        }
        if (this.getOffset() != aPTBaseToken.getOffset()) {
            return false;
        }
        return this.text.equals(aPTBaseToken.text);
    }

    public int hashCode() {
        int n = 5;
        n = 23 * n + this.getType();
        n = 23 * n + this.offset;
        n = 23 * n + this.text.hashCode();
        return n;
    }
}

