/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import org.apache.lucene.search.BooleanQuery;
import org.netbeans.modules.maven.indexer.api.NBArtifactInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.search.OpenArtifactInfo;
import org.netbeans.modules.maven.search.SearchSetupPanel;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.netbeans.spi.quicksearch.SearchRequest;
import org.netbeans.spi.quicksearch.SearchResponse;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenRepoProvider
implements SearchProvider {
    private static final String NOT_SHOW_AGAIN = "notShowAgain";
    private static final String SEARCH_ENABLED = "searchEnabled";
    private static final SearchSetup sSetup = new SearchSetup();

    public void evaluate(SearchRequest searchRequest, SearchResponse searchResponse) {
        Object object;
        Object object2;
        Object object32;
        List list = RepositoryQueries.getLoadedContexts();
        Preferences preferences = NbPreferences.forModule(MavenRepoProvider.class);
        if (list.size() == 0 && !preferences.getBoolean(SEARCH_ENABLED, false)) {
            if (!preferences.getBoolean(NOT_SHOW_AGAIN, false)) {
                searchResponse.addResult((Runnable)sSetup, NbBundle.getMessage(MavenRepoProvider.class, (String)"LBL_SearchSetup"), NbBundle.getMessage(MavenRepoProvider.class, (String)"TIP_SearchSetup"), null);
            }
            return;
        }
        List list2 = null;
        try {
            list2 = RepositoryQueries.find(this.getQuery(searchRequest), (RepositoryInfo[])new RepositoryInfo[0]);
        }
        catch (BooleanQuery.TooManyClauses tooManyClauses) {
            return;
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(new Comp(searchRequest.getText()));
        for (Object object32 : list2) {
            object2 = object32.getGroupId() + " : " + object32.getArtifactId();
            object = (List)treeMap.get(object2);
            if (object == null) {
                object = new ArrayList();
                treeMap.put((String)object2, object);
            }
            object.add(object32);
        }
        Set set = treeMap.entrySet();
        object32 = set.iterator();
        while (object32.hasNext()) {
            object2 = (Map.Entry)object32.next();
            object = new NBArtifactInfo((String)object2.getKey());
            object.addAlVersionInfos((Collection)object2.getValue());
            if (searchResponse.addResult((Runnable)new OpenArtifactInfo((NBArtifactInfo)object), object.getName())) continue;
            return;
        }
    }

    List<QueryField> getQuery(SearchRequest searchRequest) {
        ArrayList<QueryField> arrayList = new ArrayList<QueryField>();
        String string = searchRequest.getText();
        String[] stringArray = string.split(" ");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("groupId");
        arrayList2.add("artifactId");
        arrayList2.add("version");
        arrayList2.add("name");
        arrayList2.add("description");
        arrayList2.add("classes");
        for (String string2 : stringArray) {
            for (String string3 : arrayList2) {
                QueryField queryField = new QueryField();
                queryField.setField(string3);
                queryField.setValue(string2);
                arrayList.add(queryField);
            }
        }
        return arrayList;
    }

    private static class SearchSetup
    implements Runnable {
        private SearchSetup() {
        }

        public void run() {
            SearchSetupPanel searchSetupPanel = new SearchSetupPanel();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)searchSetupPanel, NbBundle.getBundle(MavenRepoProvider.class).getString("TIT_SearchSetup"));
            dialogDescriptor.setOptionType(0);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (object == DialogDescriptor.YES_OPTION || searchSetupPanel.isNotAgainChecked()) {
                Preferences preferences = NbPreferences.forModule(MavenRepoProvider.class);
                if (object == DialogDescriptor.YES_OPTION) {
                    preferences.putBoolean(MavenRepoProvider.SEARCH_ENABLED, true);
                }
                if (searchSetupPanel.isNotAgainChecked()) {
                    preferences.putBoolean(MavenRepoProvider.NOT_SHOW_AGAIN, true);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Comp
    implements Comparator<String> {
        private String query;

        public Comp(String string) {
            this.query = string;
        }

        @Override
        public int compare(String string, String string2) {
            int n = string.indexOf(this.query);
            int n2 = string2.indexOf(this.query);
            if (n >= 0 || n2 >= 0) {
                if (n < 0) {
                    return 1;
                }
                if (n2 < 0) {
                    return -1;
                }
                return string.compareTo(string2);
            }
            return string.compareTo(string2);
        }
    }
}

