/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.extras.api.support.dragging;

import java.awt.Component;
import java.awt.Point;
import java.awt.Shape;
import org.netbeans.modules.dlight.extras.api.support.dragging.Draggable;

public abstract class AbstractDraggable
implements Draggable {
    private final Component component;
    private boolean dragging;
    private int draggingShift;
    private Draggable leftBound;
    private Draggable rightBound;

    public AbstractDraggable(Component component) {
        this.component = component;
    }

    public final void setLeftBound(Draggable draggable) {
        this.leftBound = draggable;
    }

    public final void setRightBound(Draggable draggable) {
        this.rightBound = draggable;
    }

    public abstract int getPosition();

    protected abstract void setPosition(int var1, boolean var2);

    protected abstract Shape getShape();

    public final boolean containsPoint(Point point) {
        return this.getShape().contains(point);
    }

    public final void startDragging(Point point) {
        if (!this.dragging) {
            this.dragging = true;
            this.draggingShift = this.getPosition() - point.x;
        }
    }

    public final void dragTo(Point point, boolean bl) {
        if (this.dragging) {
            int n = this.leftBound == null ? 0 : this.leftBound.getPosition();
            int n2 = this.rightBound == null ? this.component.getWidth() - 1 : this.rightBound.getPosition();
            int n3 = point.x + this.draggingShift;
            if (n3 < n) {
                n3 = n;
            } else if (n2 < n3) {
                n3 = n2;
            }
            this.setPosition(n3, bl);
        }
    }

    public final void finishDragging() {
        if (this.dragging) {
            this.dragging = false;
        }
    }
}

