/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.annotationsupport;

import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.dlight.annotationsupport.FileAnnotationInfo;

public final class LineAnnotationInfo {
    private static String SPACES = "                               ";
    private FileAnnotationInfo fileAnnotationInfo;
    private int line;
    private long offset;
    private long lineOffset = -1L;
    private String annotation;
    private String tooltip;
    private String[] columns;
    private String[] notFormatedColumns;
    private Position position;
    private int y1;
    private int y2;

    public LineAnnotationInfo(FileAnnotationInfo fileAnnotationInfo) {
        this.fileAnnotationInfo = fileAnnotationInfo;
        this.annotation = null;
    }

    public int getLine() {
        if (this.line < 0) {
            try {
                this.line = Utilities.getLineOffset((BaseDocument)((BaseDocument)this.getFileAnnotationInfo().getEditorPane().getDocument()), (int)((int)this.offset));
                ++this.line;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return this.line;
    }

    public long getOffset() {
        if (this.offset < 0L) {
            Element element = this.fileAnnotationInfo.getEditorPane().getDocument().getDefaultRootElement().getElement(this.line - 1);
            this.offset = element.getStartOffset();
        }
        return this.offset;
    }

    public long getLineOffset() {
        if (this.lineOffset <= 0L) {
            try {
                Element element = this.fileAnnotationInfo.getEditorPane().getDocument().getDefaultRootElement().getElement(this.getLine() - 1);
                this.lineOffset = element.getStartOffset();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return 0L;
            }
        }
        return this.lineOffset;
    }

    public Position getPosition() {
        if (this.position == null) {
            try {
                this.position = this.fileAnnotationInfo.getEditorPane().getDocument().createPosition((int)this.getLineOffset());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return this.position;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public String getAnnotation() {
        this.annotation = "";
        int n = 0;
        for (String string : this.getColumns()) {
            int n2 = this.getFileAnnotationInfo().getMaxColumnWidth()[n];
            String string2 = SPACES.substring(0, n2 - string.length()) + string;
            if (this.annotation.length() > 0) {
                this.annotation = this.annotation + " | ";
            }
            this.annotation = this.annotation + string2;
            ++n;
        }
        return this.annotation;
    }

    public void setOffset(long l) {
        this.offset = l;
    }

    public FileAnnotationInfo getFileAnnotationInfo() {
        return this.fileAnnotationInfo;
    }

    public void setFileAnnotationInfo(FileAnnotationInfo fileAnnotationInfo) {
        this.fileAnnotationInfo = fileAnnotationInfo;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public void setColumns(String[] stringArray) {
        this.columns = stringArray;
    }

    public String[] getNotFormattedColumns() {
        return this.notFormatedColumns;
    }

    public void setNotFormattedColumns(String[] stringArray) {
        this.notFormatedColumns = stringArray;
    }

    public synchronized String getTooltip() {
        if (this.tooltip == null) {
            if (this.notFormatedColumns == null || this.notFormatedColumns.length == 0) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html><body>");
            int n = 0;
            for (String string : this.getFileAnnotationInfo().getColumnNames()) {
                if (n > 0) {
                    stringBuilder.append("<br>");
                }
                stringBuilder.append(string).append(':').append(this.notFormatedColumns[n]);
                ++n;
            }
            stringBuilder.append("</body></html>");
            this.tooltip = stringBuilder.toString();
        }
        return this.tooltip;
    }

    public int getY1() {
        return this.y1;
    }

    public int getY2() {
        return this.y2;
    }

    public void setY(int n, int n2) {
        this.y1 = n;
        this.y2 = n2;
    }

    public String toString() {
        return this.getTooltip();
    }
}

