/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.tomcat;

import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.modules.profiler.attach.panels.AttachWizardPanel;
import org.netbeans.modules.profiler.attach.providers.TargetPlatform;
import org.netbeans.modules.profiler.attach.providers.TargetPlatformEnum;
import org.netbeans.modules.profiler.attach.providers.ValidationResult;
import org.netbeans.modules.profiler.attach.wizard.AttachWizardContext;
import org.netbeans.modules.profiler.j2ee.tomcat.AbstractTomcatIntegrationProvider;
import org.netbeans.modules.profiler.j2ee.tomcat.TomcatIntegrationPanelUI;
import org.openide.util.HelpCtx;

public class TomcatIntegrationPanel
extends AttachWizardPanel {
    private static final String HELP_CTX_KEY = "TomcatIntegrationPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("TomcatIntegrationPanel.HelpCtx");
    private Model model = new Model();
    private TomcatIntegrationPanelUI panel = null;

    public HelpCtx getHelp() {
        return HELP_CTX;
    }

    public boolean isValid() {
        return this.model.isTomcatValid() && this.model.isCatalinaValid() && this.model.getSelectedPlatform() != null;
    }

    public boolean canBack(AttachWizardContext attachWizardContext) {
        return true;
    }

    public boolean canFinish(AttachWizardContext attachWizardContext) {
        return false;
    }

    public boolean canNext(AttachWizardContext attachWizardContext) {
        return this.isValid();
    }

    public boolean onCancel(AttachWizardContext attachWizardContext) {
        return true;
    }

    public void onEnter(AttachWizardContext attachWizardContext) {
        this.model.setCatalinaBase(((AbstractTomcatIntegrationProvider)attachWizardContext.getIntegrationProvider()).getCatalinaBase());
        this.model.setTomcatInstall(((AbstractTomcatIntegrationProvider)attachWizardContext.getIntegrationProvider()).getInstallationPath());
        String string = ((AbstractTomcatIntegrationProvider)attachWizardContext.getIntegrationProvider()).getTargetJava();
        List list = TargetPlatform.getPlatformList((boolean)false);
        for (TargetPlatform targetPlatform : list) {
            if (!targetPlatform.getHomePath().equals(string)) continue;
            this.model.setSelectedPlatform(targetPlatform);
        }
        this.panel.loadModel();
    }

    public void onExit(AttachWizardContext attachWizardContext) {
        AbstractTomcatIntegrationProvider abstractTomcatIntegrationProvider = (AbstractTomcatIntegrationProvider)attachWizardContext.getIntegrationProvider();
        boolean bl = false;
        if (abstractTomcatIntegrationProvider.getTargetJavaHome() != null && this.model.getSelectedPlatform() != null && !abstractTomcatIntegrationProvider.getTargetJavaHome().equals(this.model.getSelectedPlatform().getHomePath())) {
            bl = true;
        } else if (!abstractTomcatIntegrationProvider.getCatalinaBase().equals(this.model.getCatalinaBase())) {
            bl = true;
        } else if (!abstractTomcatIntegrationProvider.getInstallationPath().equals(this.model.getTomcatInstall())) {
            bl = true;
        }
        if (bl) {
            attachWizardContext.setConfigChanged();
        }
        abstractTomcatIntegrationProvider.setTargetPlatform(this.model.getSelectedPlatform());
        abstractTomcatIntegrationProvider.setCatalinaBase(this.model.getCatalinaBase());
        abstractTomcatIntegrationProvider.setInstallationPath(this.model.getTomcatInstall());
    }

    public void onFinish(AttachWizardContext attachWizardContext) {
    }

    protected JPanel getRenderPanel() {
        if (this.panel == null) {
            this.panel = new TomcatIntegrationPanelUI(this.model);
        }
        return this.panel;
    }

    protected void onPanelShow() {
        this.panel.refreshJvmList(this.model.getSelectedPlatform());
    }

    class Model {
        private TargetPlatform.TargetPlatformFilter platformFilter = new TargetPlatform.TargetPlatformFilter(){

            public boolean isSupported(TargetPlatform targetPlatform) {
                AttachSettings attachSettings = TomcatIntegrationPanel.this.getContext().getAttachSettings();
                TargetPlatformEnum targetPlatformEnum = targetPlatform.getAsEnum();
                if (!attachSettings.isDirect()) {
                    if (attachSettings.isDynamic16()) {
                        if (!targetPlatformEnum.equals((Object)TargetPlatformEnum.JDK6) && !targetPlatformEnum.equals((Object)TargetPlatformEnum.JDK7)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                return TomcatIntegrationPanel.this.getContext().getIntegrationProvider().supportsJVM(targetPlatform.getAsEnum(), attachSettings);
            }
        };
        private String catalinaBase = "";
        private String catalinaHint = "";
        private String tomcatHint = "";
        private String tomcatInstall = "";
        private TargetPlatform selectedPlatform = null;
        private boolean catalinaValid = true;
        private boolean tomcatValid = false;

        Model() {
        }

        public void setCatalinaBase(String string) {
            if (TomcatIntegrationPanel.this.getContext() == null) {
                return;
            }
            ValidationResult validationResult = ((AbstractTomcatIntegrationProvider)TomcatIntegrationPanel.this.getContext().getIntegrationProvider()).validateCatalinaBase(string);
            if (validationResult.isValid()) {
                this.catalinaValid = true;
                this.catalinaHint = "";
            } else {
                this.catalinaValid = false;
                this.catalinaHint = validationResult.getMessage();
            }
            this.catalinaBase = string;
            TomcatIntegrationPanel.this.publishUpdate(new ChangeEvent(this));
        }

        public String getCatalinaBase() {
            return this.catalinaBase;
        }

        public String getCatalinaBaseHint() {
            return this.catalinaHint;
        }

        public boolean isCatalinaValid() {
            return this.catalinaValid;
        }

        public TargetPlatform.TargetPlatformFilter getPlatformFilter() {
            return this.platformFilter;
        }

        public TargetPlatformEnum getSelectedJVM() {
            return this.selectedPlatform.getAsEnum();
        }

        public void setSelectedPlatform(TargetPlatform targetPlatform) {
            this.selectedPlatform = targetPlatform;
            TomcatIntegrationPanel.this.publishUpdate(new ChangeEvent(this));
        }

        public TargetPlatform getSelectedPlatform() {
            return this.selectedPlatform;
        }

        public void setTomcatInstall(String string) {
            if (TomcatIntegrationPanel.this.getContext() == null) {
                return;
            }
            String string2 = TomcatIntegrationPanel.this.getContext().getAttachSettings().getHostOS();
            ValidationResult validationResult = ((AbstractTomcatIntegrationProvider)TomcatIntegrationPanel.this.getContext().getIntegrationProvider()).validateInstallation(string2, string);
            if (validationResult.isValid()) {
                this.tomcatValid = true;
                this.tomcatHint = "";
            } else {
                this.tomcatValid = false;
                this.tomcatHint = validationResult.getMessage();
            }
            this.tomcatInstall = string;
            TomcatIntegrationPanel.this.publishUpdate(new ChangeEvent(this));
        }

        public String getTomcatInstall() {
            return this.tomcatInstall;
        }

        public String getTomcatInstallHint() {
            return this.tomcatHint;
        }

        public boolean isTomcatValid() {
            return this.tomcatValid;
        }
    }
}

