/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util;

public final class CharacterConversions {
    public static final char LF = '\n';
    public static final char CR = '\r';
    public static final char LS = '\u2028';
    public static final char PS = '\u2029';
    private static String systemDefaultLineSeparator = null;

    public static String lineSeparatorToLineFeed(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0) {
            return "";
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(charSequence.length());
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (bl && c == '\n') {
                stringBuilder.append('\n');
                bl = false;
                continue;
            }
            if (c == '\r') {
                bl = true;
                continue;
            }
            if (c == '\u2028' || c == '\u2029') {
                stringBuilder.append('\n');
                bl = false;
                continue;
            }
            bl = false;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String lineSeparatorToLineFeed(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence.length() == 0) {
            return "";
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder(charSequence.length());
        for (int i = 0; i < charSequence.length(); ++i) {
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 == (c = charSequence2.charAt(n))) {
                if (n == charSequence2.length() - 1) {
                    stringBuilder.append('\n');
                    n = 0;
                    continue;
                }
                ++n;
                continue;
            }
            if (n > 0) {
                stringBuilder.append(charSequence2, 0, n);
            }
            stringBuilder.append(c2);
            n = 0;
        }
        return stringBuilder.toString();
    }

    public static String lineFeedToLineSeparator(CharSequence charSequence) {
        return CharacterConversions.lineFeedToLineSeparator(charSequence, CharacterConversions.getSystemDefaultLineSeparator());
    }

    public static String lineFeedToLineSeparator(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence.length() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence.length());
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == '\n') {
                stringBuilder.append(charSequence2);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static String getSystemDefaultLineSeparator() {
        if (systemDefaultLineSeparator == null) {
            systemDefaultLineSeparator = System.getProperty("line.separator");
        }
        return systemDefaultLineSeparator;
    }

    private CharacterConversions() {
    }
}

