/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.samples.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class RestSampleUtils {
    public static final String JERSEY_LIBRARY = "restlib";
    public static String[] xlateFiles = new String[]{"build-impl.xml", "project.xml", "project.properties", "AssemblyInformation.xml"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZipFile(InputStream inputStream, FileObject fileObject) throws IOException {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    FileUtil.createFolder((FileObject)fileObject, (String)zipEntry.getName());
                    continue;
                }
                FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)zipEntry.getName());
                FileLock fileLock = fileObject2.lock();
                try {
                    OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                    try {
                        FileUtil.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        }
        finally {
            inputStream.close();
        }
    }

    public static void setProjectName(FileObject fileObject, String string, String string2) {
        try {
            File file = FileUtil.toFile((FileObject)fileObject.getFileObject("nbproject/project.xml"));
            Document document = XMLUtil.parse((InputSource)new InputSource(file.toURI().toString()), (boolean)false, (boolean)true, null, null);
            NodeList nodeList = document.getElementsByTagNameNS(string, "name");
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    RestSampleUtils.replaceText(element, string2);
                }
                RestSampleUtils.saveXml(document, fileObject, "nbproject/project.xml");
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    private static void replaceText(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            Text text = (Text)nodeList.item(i);
            text.setNodeValue(string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveXml(Document document, FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
        FileLock fileLock = fileObject2.lock();
        try {
            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
            try {
                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }
}

