/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.samples.ui;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.websvc.rest.samples.ui.SampleWizardPanel;
import org.netbeans.modules.websvc.rest.samples.util.RestSampleUtils;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final long serialVersionUID = 1L;
    public static final String PROJDIR = "projdir";
    public static final String NAME = "name";
    private Project myProject;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    public transient WizardDescriptor wiz;
    private String projectConfigNamespace = "http://www.netbeans.org/ns/web-project/3";

    public static SampleWizardIterator createIterator() {
        return new SampleWizardIterator();
    }

    protected WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new SampleWizardPanel()};
    }

    protected String[] createSteps() {
        return new String[]{NbBundle.getMessage(SampleWizardIterator.class, (String)"MSG_NameAndLocation")};
    }

    public Project getProject() {
        return this.myProject;
    }

    public void setProjectConfigNamespace(String string) {
        this.projectConfigNamespace = string;
    }

    public Set<FileObject> instantiate() throws IOException {
        File file;
        Project project;
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        File file2 = FileUtil.normalizeFile((File)((File)this.wiz.getProperty(PROJDIR)));
        file2.mkdirs();
        String string = (String)this.wiz.getProperty(NAME);
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)this.wiz);
        FileObject fileObject2 = FileUtil.toFileObject((File)file2);
        fileObject2 = fileObject2.createFolder(string);
        file2 = FileUtil.toFile((FileObject)fileObject2);
        RestSampleUtils.unZipFile(fileObject.getInputStream(), fileObject2);
        ProjectManager.getDefault().clearNonProjectCache();
        if (this.projectConfigNamespace != null) {
            RestSampleUtils.setProjectName(fileObject2, this.projectConfigNamespace, string);
        }
        this.myProject = project = ProjectManager.getDefault().findProject(fileObject2);
        linkedHashSet.add(fileObject2);
        Enumeration enumeration = fileObject2.getFolders(true);
        while (enumeration.hasMoreElements()) {
            file = (FileObject)enumeration.nextElement();
            if (!ProjectManager.getDefault().isProject((FileObject)file)) continue;
            linkedHashSet.add((FileObject)file);
        }
        file = file2.getParentFile();
        if (file != null && file.exists()) {
            ProjectChooser.setProjectsFolder((File)file);
        }
        return linkedHashSet;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wiz = wizardDescriptor;
        this.index = 0;
        this.panels = this.createPanels();
        String[] stringArray = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray[i] == null) {
                stringArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wiz.putProperty(PROJDIR, null);
        this.wiz.putProperty(NAME, null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    protected void replaceTokens(FileObject fileObject, String[] stringArray, String[][] stringArray2) throws IOException {
        for (String string : stringArray) {
            this.replaceToken(fileObject.getFileObject(string), stringArray2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceToken(FileObject fileObject, String[][] stringArray) throws IOException {
        if (fileObject == null) {
            return;
        }
        FileLock fileLock = fileObject.lock();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string = bufferedReader.readLine()) != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string.replaceAll(stringArray[i][0], stringArray[i][1]);
                }
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream(fileLock), "UTF-8");
            try {
                outputStreamWriter.write(stringBuffer.toString());
            }
            finally {
                outputStreamWriter.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }
}

