/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

public final class NbModuleLogHandler
extends Handler {
    private static StringBuffer text;
    private static Level msg;
    private static Level exc;
    private static final AtomicInteger ignoreOOME;

    public static Test registerBuffer(Level level, Level level2) {
        if (level == null) {
            level = Level.OFF;
        }
        if (level2 == null) {
            level2 = Level.OFF;
        }
        if (level2 == Level.OFF && level == Level.OFF) {
            return null;
        }
        msg = level;
        exc = level2;
        text = new StringBuffer();
        Logger logger = Logger.getLogger("");
        Level level3 = level;
        if (level3.intValue() > level2.intValue()) {
            level3 = level2;
        }
        logger.setLevel(level3);
        return new FailOnException(level, level2);
    }

    public static void finish() {
        text = null;
    }

    public static StringBuffer toString(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        stringBuffer.append(logRecord.getLoggerName());
        stringBuffer.append("] THREAD: ");
        stringBuffer.append(Thread.currentThread().getName());
        stringBuffer.append(" MSG: ");
        String string = logRecord.getMessage();
        ResourceBundle resourceBundle = logRecord.getResourceBundle();
        if (resourceBundle != null) {
            try {
                string = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (string != null && logRecord.getParameters() != null) {
            string = MessageFormat.format(string, logRecord.getParameters());
        }
        stringBuffer.append(string);
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            stringBuffer.append('\n');
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            stringBuffer.append(stringWriter.toString().replace("\tat ", "  ").replace("\t... ", "  ... "));
        }
        stringBuffer.append('\n');
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void whileIgnoringOOME(Runnable runnable) {
        ignoreOOME.incrementAndGet();
        try {
            runnable.run();
        }
        finally {
            ignoreOOME.decrementAndGet();
        }
    }

    public void publish(LogRecord logRecord) {
        StringBuffer stringBuffer = text;
        if (stringBuffer == null) {
            return;
        }
        if (logRecord.getThrown() != null) {
            if (ignoreOOME.get() > 0 && logRecord.getThrown() instanceof OutOfMemoryError) {
                return;
            }
            if (exc.intValue() <= logRecord.getLevel().intValue()) {
                stringBuffer.append(NbModuleLogHandler.toString(logRecord));
            }
        } else if (msg.intValue() <= logRecord.getLevel().intValue()) {
            stringBuffer.append(NbModuleLogHandler.toString(logRecord));
        }
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkFailures(TestCase testCase, TestResult testResult) {
        StringBuffer stringBuffer = text;
        if (stringBuffer == null) {
            return;
        }
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            if (stringBuffer.length() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("NbModuleSuite has been started with failOnMessage(");
                stringBuilder.append(msg);
                stringBuilder.append(") and failOnException(").append(exc);
                stringBuilder.append("). The following failures have been captured:\n");
                stringBuilder.append(text);
                testResult.addFailure((Test)testCase, new AssertionFailedError(stringBuilder.toString()));
                stringBuffer.setLength(0);
            }
        }
    }

    static {
        ignoreOOME = new AtomicInteger();
    }

    private static final class FailOnException
    extends TestCase {
        private final Level msg;
        private final Level exc;

        private FailOnException(Level level, Level level2) {
            super("testNoWarningsReportedDuringExecution");
            this.msg = level;
            this.exc = level2;
        }

        public int countTestCases() {
            return 1;
        }

        public void run(TestResult testResult) {
            NbModuleLogHandler.checkFailures(this, testResult);
        }
    }
}

