/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.tomcat5.TomcatManagerConfig;
import org.netbeans.modules.tomcat5.TomcatManagerImpl;
import org.netbeans.modules.tomcat5.TomcatModule;
import org.netbeans.modules.tomcat5.TomcatPlatformImpl;
import org.netbeans.modules.tomcat5.TomcatTarget;
import org.netbeans.modules.tomcat5.config.gen.Server;
import org.netbeans.modules.tomcat5.ide.StartTomcat;
import org.netbeans.modules.tomcat5.progress.MultiProgressObjectWrapper;
import org.netbeans.modules.tomcat5.util.LogManager;
import org.netbeans.modules.tomcat5.util.TomcatInstallUtil;
import org.netbeans.modules.tomcat5.util.TomcatProperties;
import org.netbeans.modules.tomcat5.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class TomcatManager
implements DeploymentManager {
    private static final Logger LOGGER = Logger.getLogger(TomcatManager.class.getName());
    static final int ENUM_AVAILABLE = 0;
    static final int ENUM_RUNNING = 1;
    static final int ENUM_NONRUNNING = 2;
    public static final String PROP_BUNDLED_TOMCAT = "is_it_bundled_tomcat";
    private boolean connected;
    private String uri;
    private StartTomcat startTomcat;
    private Process process;
    private TomcatManagerConfig tomcatManagerConfig;
    private LogManager logManager = new LogManager(this);
    private TomcatPlatformImpl tomcatPlatform;
    private TomcatProperties tp;
    private TomcatVersion tomcatVersion;
    private InstanceProperties ip;
    private boolean needsRestart;

    public TomcatManager(boolean bl, String string, TomcatVersion tomcatVersion) throws IllegalArgumentException {
        LOGGER.log(Level.FINE, "Creating connected TomcatManager uri=" + string);
        this.connected = bl;
        this.tomcatVersion = tomcatVersion;
        this.uri = string;
        this.ip = InstanceProperties.getInstanceProperties((String)this.getUri());
        if (this.ip != null) {
            this.tp = new TomcatProperties(this);
        }
    }

    public InstanceProperties getInstanceProperties() {
        return this.ip;
    }

    public boolean isBundledTomcat() {
        if (this.ip == null) {
            return false;
        }
        String string = this.ip.getProperty(PROP_BUNDLED_TOMCAT);
        return string != null ? Boolean.valueOf(string) : false;
    }

    public TomcatProperties getTomcatProperties() {
        return this.tp;
    }

    public synchronized void setNeedsRestart(boolean bl) {
        this.needsRestart = bl;
    }

    public synchronized boolean getNeedsRestart() {
        return this.needsRestart;
    }

    public boolean isRunning(boolean bl) {
        return this.isRunning(this.tp.getRunningCheckTimeout(), bl);
    }

    public boolean isRunning(int n, boolean bl) {
        block4: {
            Process process = this.getTomcatProcess();
            if (process != null) {
                try {
                    process.exitValue();
                    return false;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    if (bl) break block4;
                    return true;
                }
            }
        }
        if (bl) {
            return Utils.pingTomcat(this.getServerPort(), n);
        }
        return false;
    }

    public String getUri() {
        switch (this.tomcatVersion) {
            case TOMCAT_60: {
                return "tomcat60:" + this.uri;
            }
            case TOMCAT_55: {
                return "tomcat55:" + this.uri;
            }
        }
        return "tomcat:" + this.uri;
    }

    public String getPlainUri() {
        return "http://" + this.tp.getHost() + ":" + this.getCurrentServerPort() + "/manager/";
    }

    public String getServerUri() {
        return "http://" + this.tp.getHost() + ":" + this.getCurrentServerPort();
    }

    public String getCatalinaWork() {
        TomcatManagerConfig tomcatManagerConfig = this.getTomcatManagerConfig();
        String string = tomcatManagerConfig.getEngineElement().getAttributeValue("name");
        String string2 = tomcatManagerConfig.getHostElement().getAttributeValue("name");
        StringBuffer stringBuffer = new StringBuffer(this.tp.getCatalinaDir().toString());
        stringBuffer.append("/work/").append(string).append("/").append(string2);
        return stringBuffer.toString();
    }

    public void ensureCatalinaBaseReady() {
        String[] stringArray;
        File file = this.tp.getCatalinaBase();
        if (file != null && ((stringArray = file.list()) == null || stringArray.length == 0)) {
            FileObject fileObject;
            File file2;
            this.createBaseDir(file, this.tp.getCatalinaHome());
            if (FileUtil.toFileObject((File)file) == null && (file2 = file.getParentFile()) != null && (fileObject = FileUtil.toFileObject((File)file2)) != null) {
                fileObject.refresh();
            }
        }
    }

    public StartTomcat getStartTomcat() {
        return this.startTomcat;
    }

    public void setStartTomcat(StartTomcat startTomcat) {
        this.startTomcat = startTomcat;
    }

    public boolean isDebugged() {
        ServerDebugInfo serverDebugInfo = null;
        Session[] sessionArray = DebuggerManager.getDebuggerManager().getSessions();
        serverDebugInfo = this.getStartTomcat().getDebugInfo(null);
        if (serverDebugInfo == null) {
            LOGGER.log(Level.INFO, "DebuggerInfo cannot be found for: " + this.toString());
        }
        for (int i = 0; i < sessionArray.length; ++i) {
            Object object;
            Session session = sessionArray[i];
            if (session == null || (object = session.lookupFirst(null, AttachingDICookie.class)) == null) continue;
            AttachingDICookie attachingDICookie = (AttachingDICookie)object;
            if (!(serverDebugInfo.getTransport().equals("dt_shmem") ? attachingDICookie.getSharedMemoryName().equalsIgnoreCase(serverDebugInfo.getShmemName()) : attachingDICookie.getHostName().equalsIgnoreCase(serverDebugInfo.getHost()) && attachingDICookie.getPortNumber() == serverDebugInfo.getPort())) continue;
            return true;
        }
        return false;
    }

    public boolean isSuspended() {
        Session[] sessionArray = DebuggerManager.getDebuggerManager().getSessions();
        ServerDebugInfo serverDebugInfo = this.getStartTomcat().getDebugInfo(null);
        if (serverDebugInfo == null) {
            LOGGER.log(Level.INFO, "DebuggerInfo cannot be found for: " + this.toString());
        }
        for (int i = 0; i < sessionArray.length; ++i) {
            JPDADebugger jPDADebugger;
            Object object;
            String string;
            Object object2;
            Session session = sessionArray[i];
            if (session == null || (object2 = session.lookupFirst(null, AttachingDICookie.class)) == null) continue;
            AttachingDICookie attachingDICookie = (AttachingDICookie)object2;
            if (!(serverDebugInfo.getTransport().equals("dt_shmem") ? (string = attachingDICookie.getSharedMemoryName()) != null && string.equalsIgnoreCase(serverDebugInfo.getShmemName()) && (object = session.lookupFirst(null, JPDADebugger.class)) != null && (jPDADebugger = (JPDADebugger)object).getState() == 3 : (string = attachingDICookie.getHostName()) != null && string.equalsIgnoreCase(serverDebugInfo.getHost()) && attachingDICookie.getPortNumber() == serverDebugInfo.getPort() && (object = session.lookupFirst(null, JPDADebugger.class)) != null && (jPDADebugger = (JPDADebugger)object).getState() == 3)) continue;
            return true;
        }
        return false;
    }

    public boolean isTomcat60() {
        return this.tomcatVersion == TomcatVersion.TOMCAT_60;
    }

    public boolean isTomcat55() {
        return this.tomcatVersion == TomcatVersion.TOMCAT_55;
    }

    public boolean isTomcat50() {
        return this.tomcatVersion == TomcatVersion.TOMCAT_50;
    }

    public String libFolder() {
        return this.isTomcat60() ? "lib" : "common/lib";
    }

    public TomcatVersion getTomcatVersion() {
        return this.tomcatVersion;
    }

    public DeploymentConfiguration createConfiguration(DeployableObject deployableObject) throws InvalidModuleException {
        throw new RuntimeException("This should never be called");
    }

    public Locale getCurrentLocale() {
        return Locale.getDefault();
    }

    public Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public Locale[] getSupportedLocales() {
        return Locale.getAvailableLocales();
    }

    public boolean isLocaleSupported(Locale locale) {
        if (locale == null) {
            return false;
        }
        Locale[] localeArray = this.getSupportedLocales();
        for (int i = 0; i < localeArray.length; ++i) {
            if (!locale.equals(localeArray[i])) continue;
            return true;
        }
        return false;
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        return this.modules(0, moduleType, targetArray);
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        return this.modules(2, moduleType, targetArray);
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        return this.modules(1, moduleType, targetArray);
    }

    public Target[] getTargets() throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("TomcatManager.getTargets called on disconnected instance");
        }
        return new TomcatTarget[]{new TomcatTarget(this.uri, "Tomcat at " + this.uri, this.getServerUri())};
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return null;
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType dConfigBeanVersionType) throws DConfigBeanVersionUnsupportedException {
        if (!DConfigBeanVersionType.V1_3_1.equals(dConfigBeanVersionType)) {
            throw new DConfigBeanVersionUnsupportedException("unsupported version");
        }
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dConfigBeanVersionType) {
        return DConfigBeanVersionType.V1_3_1.equals(dConfigBeanVersionType);
    }

    public boolean isRedeploySupported() {
        return false;
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, InputStream inputStream, InputStream inputStream2) throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("TomcatManager.redeploy not supported yet.");
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, File file, File file2) throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("TomcatManager.redeploy not supported yet.");
    }

    public void release() {
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
    }

    public ProgressObject start(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("TomcatManager.start called on disconnected instance");
        }
        if (targetModuleIDArray.length != 1 || !(targetModuleIDArray[0] instanceof TomcatModule)) {
            throw new IllegalStateException("TomcatManager.start invalid TargetModuleID passed");
        }
        TomcatManagerImpl tomcatManagerImpl = new TomcatManagerImpl(this);
        tomcatManagerImpl.start((TomcatModule)targetModuleIDArray[0]);
        return tomcatManagerImpl;
    }

    public ProgressObject stop(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("TomcatManager.stop called on disconnected instance");
        }
        if (targetModuleIDArray.length != 1 || !(targetModuleIDArray[0] instanceof TomcatModule)) {
            throw new IllegalStateException("TomcatManager.stop invalid TargetModuleID passed");
        }
        TomcatManagerImpl tomcatManagerImpl = new TomcatManagerImpl(this);
        tomcatManagerImpl.stop((TomcatModule)targetModuleIDArray[0]);
        return tomcatManagerImpl;
    }

    public ProgressObject undeploy(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("TomcatManager.undeploy called on disconnected instance");
        }
        if (targetModuleIDArray == null) {
            throw new NullPointerException("TomcatManager.undeploy the tmID argument must not be null.");
        }
        if (targetModuleIDArray.length == 0) {
            throw new IllegalArgumentException("TomcatManager.undeploy at least one TargetModuleID object must be passed.");
        }
        for (int i = 0; i < targetModuleIDArray.length; ++i) {
            if (targetModuleIDArray[i] instanceof TomcatModule) continue;
            throw new IllegalStateException("TomcatManager.undeploy invalid TargetModuleID passed: " + targetModuleIDArray[i].getClass().getName());
        }
        ProgressObject[] progressObjectArray = new TomcatManagerImpl[targetModuleIDArray.length];
        for (int i = 0; i < targetModuleIDArray.length; ++i) {
            progressObjectArray[i] = new TomcatManagerImpl(this);
        }
        MultiProgressObjectWrapper multiProgressObjectWrapper = new MultiProgressObjectWrapper(progressObjectArray);
        for (int i = 0; i < targetModuleIDArray.length; ++i) {
            TomcatModule tomcatModule = (TomcatModule)targetModuleIDArray[i];
            if ("/manager".equals(tomcatModule.getPath())) {
                String string = NbBundle.getMessage(TomcatModule.class, (String)"MSG_CannotUndeployManager");
                throw new IllegalStateException(string);
            }
            progressObjectArray[i].remove(tomcatModule);
        }
        return multiProgressObjectWrapper;
    }

    public ProgressObject distribute(Target[] targetArray, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("TomcatManager.distribute called on disconnected instance");
        }
        LOGGER.log(Level.FINE, "TomcatManager.distribute streams");
        TomcatManagerImpl tomcatManagerImpl = new TomcatManagerImpl(this);
        tomcatManagerImpl.deploy(targetArray[0], inputStream, inputStream2);
        return tomcatManagerImpl;
    }

    public ProgressObject distribute(Target[] targetArray, File file, File file2) throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("TomcatManager.distribute called on disconnected instance");
        }
        LOGGER.log(Level.FINE, "TomcatManager.distribute archive=" + file.getPath() + ", plan=" + file2.getPath());
        TomcatManagerImpl tomcatManagerImpl = new TomcatManagerImpl(this);
        tomcatManagerImpl.install(targetArray[0], file, file2);
        return tomcatManagerImpl;
    }

    public ProgressObject distribute(Target[] targetArray, ModuleType moduleType, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        return this.distribute(targetArray, inputStream, inputStream2);
    }

    private TargetModuleID[] modules(int n, ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("TomcatManager.modules called on disconnected instance");
        }
        if (targetArray.length != 1) {
            throw new TargetException("TomcatManager.modules supports only one target");
        }
        if (!ModuleType.WAR.equals(moduleType)) {
            return new TargetModuleID[0];
        }
        TomcatManagerImpl tomcatManagerImpl = new TomcatManagerImpl(this);
        return tomcatManagerImpl.list(targetArray[0], n);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String toString() {
        return "Tomcat manager [" + this.uri + ", home " + this.tp.getCatalinaHome() + ", base " + this.tp.getCatalinaBase() + (this.connected ? "conneceted" : "disconnected") + "]";
    }

    public void setServerPort(int n) {
        this.ensureCatalinaBaseReady();
        if (TomcatInstallUtil.setServerPort(n, this.tp.getServerXml())) {
            this.tp.setServerPort(n);
        }
    }

    public void setShutdownPort(int n) {
        this.ensureCatalinaBaseReady();
        if (TomcatInstallUtil.setShutdownPort(n, this.tp.getServerXml())) {
            this.tp.setShutdownPort(n);
        }
    }

    public int getCurrentServerPort() {
        if (this.startTomcat != null && this.isRunning(false)) {
            return this.startTomcat.getCurrentServerPort();
        }
        return this.getServerPort();
    }

    public int getServerPort() {
        this.ensurePortsUptodate();
        return this.tp.getServerPort();
    }

    public int getShutdownPort() {
        this.ensurePortsUptodate();
        return this.tp.getShutdownPort();
    }

    private void ensurePortsUptodate() {
        File file = this.tp.getServerXml();
        long l = -1L;
        if (file.exists() && (l = file.lastModified()) > this.tp.getTimestamp()) {
            try {
                if (this.isBundledTomcat() && !new File(this.tp.getCatalinaBase(), "conf/server.xml").exists()) {
                    this.tp.setTimestamp(l);
                    this.tp.setServerPort(8084);
                    this.tp.setShutdownPort(8025);
                    return;
                }
                Server server = Server.createGraph(file);
                this.tp.setTimestamp(l);
                this.tp.setServerPort(Integer.parseInt(TomcatInstallUtil.getPort(server)));
                this.tp.setShutdownPort(Integer.parseInt(TomcatInstallUtil.getShutdownPort(server)));
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, null, iOException);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.log(Level.INFO, null, numberFormatException);
            }
            catch (RuntimeException runtimeException) {
                LOGGER.log(Level.INFO, null, runtimeException);
            }
        }
    }

    public Server getRoot() {
        try {
            return Server.createGraph(this.tp.getServerXml());
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, null, iOException);
            return null;
        }
        catch (RuntimeException runtimeException) {
            LOGGER.log(Level.INFO, null, runtimeException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createBaseDir(File file, File file2) {
        File file3;
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("netbeans.user") + System.getProperty("file.separator") + file);
            file3 = new File(System.getProperty("netbeans.user"));
        } else {
            file3 = file.getParentFile();
        }
        try {
            String[] stringArray;
            if (file3 == null) {
                LOGGER.log(Level.INFO, "Cannot find parent folder for base dir " + file.getPath());
                return null;
            }
            File file4 = new File(file3, file.getName());
            file4.mkdir();
            String[] stringArray2 = new String[]{"conf", "conf/Catalina", "conf/Catalina/localhost", "logs", "work", "temp", "webapps"};
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray = new File(file4, stringArray2[i]);
                stringArray.mkdirs();
            }
            stringArray = new String[]{"conf/catalina.policy", "conf/catalina.properties", "conf/logging.properties", "conf/server.xml", "conf/tomcat-users.xml", "conf/web.xml", "conf/Catalina/localhost/admin.xml", "conf/Catalina/localhost/manager.xml"};
            String[] stringArray3 = new String[]{null, null, null, null, "</tomcat-users>", null, "docBase=\"../server/webapps/admin\"", this.isTomcat50() || this.isTomcat55() ? "docBase=\"../server/webapps/manager\"" : null};
            String string = null;
            if (this.isBundledTomcat() && "ide_manager".equals(string = this.tp.getPassword())) {
                string = TomcatInstallUtil.generatePassword(8);
                this.tp.setPassword(string);
            }
            String[] stringArray4 = new String[]{null, null, null, null, string != null ? "<user username=\"ide\" password=\"" + string + "\" roles=\"manager,admin\"/>\n</tomcat-users>" : null, null, "docBase=\"${catalina.home}/server/webapps/admin\"", this.isTomcat50() || this.isTomcat55() ? "docBase=\"${catalina.home}/server/webapps/manager\"" : null};
            block20: for (int i = 0; i < stringArray.length; ++i) {
                int n = stringArray[i].lastIndexOf(47);
                String string2 = stringArray[i].substring(0, n);
                File file5 = new File(file2, string2);
                File file6 = new File(file, string2);
                if (stringArray4[i] == null) {
                    File file7 = new File(file2, stringArray[i]);
                    if (!file7.exists()) {
                        LOGGER.log(Level.INFO, "Cannot copy file " + file7.getAbsolutePath() + " to the Tomcat base dir, since it does not exist.");
                        continue;
                    }
                    FileInputStream fileInputStream = new FileInputStream(file7);
                    FileOutputStream fileOutputStream = new FileOutputStream(new File(file6, stringArray[i].substring(n + 1)));
                    try {
                        byte[] byArray = new byte[4096];
                        while (true) {
                            int n2;
                            if ((n2 = fileInputStream.read(byArray)) == -1) {
                                continue block20;
                            }
                            fileOutputStream.write(byArray, 0, n2);
                        }
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.INFO, null, iOException);
                        continue;
                    }
                    finally {
                        try {
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                        try {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (this.copyAndPatch(new File(file5, stringArray[i].substring(n + 1)), new File(file6, stringArray[i].substring(n + 1)), stringArray3[i], stringArray4[i]) || "conf/Catalina/localhost/admin.xml".equals(stringArray[i]) && !new File(file5, stringArray[i].substring(n + 1)).exists()) continue;
                LOGGER.log(Level.INFO, "Cannot create config file " + stringArray[i]);
            }
            if (new File(file2, "webapps/ROOT").exists()) {
                this.writeToFile(new File(file, "conf/Catalina/localhost/ROOT.xml"), "<Context path=\"\" docBase=\"${catalina.home}/webapps/ROOT\"/>\n");
            }
            if (!this.isTomcat50() && !this.isTomcat55() && new File(file2, "webapps/manager").exists()) {
                this.writeToFile(new File(file, "conf/Catalina/localhost/manager.xml"), "<Context docBase=\"${catalina.home}/webapps/manager\" antiResourceLocking=\"false\" privileged=\"true\"/>\n");
            }
            if (this.isBundledTomcat()) {
                TomcatInstallUtil.patchCatalinaProperties(new File(file, "conf/catalina.properties"));
                TomcatInstallUtil.createNBLibDirectory(file);
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
            return null;
        }
        if (this.isBundledTomcat()) {
            TomcatInstallUtil.patchBundledServerXml(new File(file, "conf/server.xml"));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(File file, String string) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(string);
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyAndPatch(File file, File file2, String string, String string2) {
        Reader reader = null;
        Writer writer = null;
        if (!file.exists()) {
            return false;
        }
        try {
            int n;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[4096];
            while ((n = reader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
            int n2 = stringBuffer.toString().indexOf(string);
            if (n2 >= 0) {
                stringBuffer.replace(n2, n2 + string.length(), string2);
            } else {
                LOGGER.log(Level.INFO, "Pattern " + string + " not found in " + file.getPath());
            }
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "utf-8"));
            writer.write(stringBuffer.toString());
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public void openLog(TargetModuleID targetModuleID) {
        TomcatModule tomcatModule = null;
        if (targetModuleID instanceof TomcatModule) {
            tomcatModule = (TomcatModule)targetModuleID;
        } else {
            try {
                TargetModuleID[] targetModuleIDArray = this.getRunningModules(ModuleType.WAR, new Target[]{targetModuleID.getTarget()});
                for (int i = 0; i < targetModuleIDArray.length; ++i) {
                    if (!targetModuleID.getModuleID().equals(targetModuleIDArray[i].getModuleID())) continue;
                    tomcatModule = (TomcatModule)targetModuleIDArray[i];
                    break;
                }
            }
            catch (TargetException targetException) {
                LOGGER.log(Level.INFO, null, targetException);
            }
        }
        if (tomcatModule != null && this.logManager.hasContextLogger(tomcatModule)) {
            this.logManager.openContextLog(tomcatModule);
        } else {
            this.logManager.openSharedContextLog();
        }
    }

    public synchronized TomcatManagerConfig getTomcatManagerConfig() {
        if (this.tomcatManagerConfig == null) {
            this.tomcatManagerConfig = new TomcatManagerConfig(this.tp.getServerXml());
        }
        return this.tomcatManagerConfig;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public synchronized void setTomcatProcess(Process process) {
        this.process = process;
    }

    public synchronized Process getTomcatProcess() {
        return this.process;
    }

    public void terminate() {
        Process process = this.getTomcatProcess();
        if (process != null) {
            process.destroy();
        }
    }

    public synchronized TomcatPlatformImpl getTomcatPlatform() {
        if (this.tomcatPlatform == null) {
            this.tomcatPlatform = new TomcatPlatformImpl(this);
        }
        return this.tomcatPlatform;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TomcatVersion {
        TOMCAT_50,
        TOMCAT_55,
        TOMCAT_60;

    }
}

