/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.index.JsfBinaryIndexer;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptorException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFaceletLibraries {
    public static DefaultFaceletLibraries INSTANCE;
    private Collection<FileObject> libraryDescriptorsFiles;
    private Map<String, FaceletsLibraryDescriptor> librariesDescriptors;
    private static Map<String, LibraryInfo> LIBRARY_INFOS;

    public static synchronized DefaultFaceletLibraries getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DefaultFaceletLibraries();
        }
        return INSTANCE;
    }

    public DefaultFaceletLibraries() {
        this.init();
    }

    private void init() {
        File file = InstalledFileLocator.getDefault().locate("modules/ext/jsf-2_0/jsf-impl.jar", "org.netbeans.modules.web.jsf20", false);
        assert (file != null);
        FileObject fileObject = FileUtil.getArchiveRoot((FileObject)FileUtil.toFileObject((File)file));
        this.libraryDescriptorsFiles = JsfBinaryIndexer.findLibraryDescriptors(fileObject, ".taglib.xml");
    }

    public Collection<FileObject> getLibrariesDescriptorsFiles() {
        return this.libraryDescriptorsFiles;
    }

    public synchronized Map<String, FaceletsLibraryDescriptor> getLibrariesDescriptors() {
        if (this.librariesDescriptors == null) {
            this.librariesDescriptors = new HashMap<String, FaceletsLibraryDescriptor>();
            this.parseLibraries();
        }
        return this.librariesDescriptors;
    }

    private void parseLibraries() {
        for (FileObject fileObject : this.getLibrariesDescriptorsFiles()) {
            try {
                FaceletsLibraryDescriptor faceletsLibraryDescriptor = FaceletsLibraryDescriptor.create(fileObject);
                this.librariesDescriptors.put(faceletsLibraryDescriptor.getURI(), faceletsLibraryDescriptor);
            }
            catch (LibraryDescriptorException libraryDescriptorException) {
                Logger.global.log(Level.WARNING, "Error parsing facelets library " + FileUtil.getFileDisplayName((FileObject)fileObject) + " in jsf-impl.jar from bundled web.jsf20 library", libraryDescriptorException);
            }
        }
    }

    private static synchronized LibraryInfo getLibraryInfo(String string) {
        if (LIBRARY_INFOS == null) {
            LIBRARY_INFOS = new HashMap<String, LibraryInfo>();
            LIBRARY_INFOS.put("http://java.sun.com/jsf/facelets", new LibraryInfo("Facelets", "ui"));
            LIBRARY_INFOS.put("http://mojarra.dev.java.net/mojarra_ext", new LibraryInfo("Mojarra Extensions", "mj"));
            LIBRARY_INFOS.put("http://java.sun.com/jsf/composite", new LibraryInfo("Composite Components", "composite"));
            LIBRARY_INFOS.put("http://java.sun.com/jsf/html", new LibraryInfo("Html Basic", "h"));
            LIBRARY_INFOS.put("http://java.sun.com/jsf/core", new LibraryInfo("Jsf Core", "f"));
            LIBRARY_INFOS.put("http://java.sun.com/jsp/jstl/core", new LibraryInfo("Jstl Core", "c"));
        }
        return LIBRARY_INFOS.get(string);
    }

    public static String getLibraryDisplayName(String string) {
        LibraryInfo libraryInfo = DefaultFaceletLibraries.getLibraryInfo(string);
        return libraryInfo != null ? libraryInfo.getDisplayName() : null;
    }

    public static String getLibraryDefaultPrefix(String string) {
        LibraryInfo libraryInfo = DefaultFaceletLibraries.getLibraryInfo(string);
        return libraryInfo != null ? libraryInfo.getDefaultPrefix() : null;
    }

    private static class LibraryInfo {
        public String displayName;
        public String defaultPrefix;

        public LibraryInfo(String string, String string2) {
            this.displayName = string;
            this.defaultPrefix = string2;
        }

        public String getDefaultPrefix() {
            return this.defaultPrefix;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

