/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.xam;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.ChangeInfo;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.dom.SyncUnit;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.diff.NodeInfo;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.xam.XDMAccess;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XDMListener
implements PropertyChangeListener {
    private AbstractDocumentModel model;
    private boolean inSync;
    private Document oldDocument;
    private Map<Integer, SyncUnit> syncUnits = new HashMap<Integer, SyncUnit>();

    public XDMListener(AbstractDocumentModel abstractDocumentModel) {
        this.model = abstractDocumentModel;
    }

    private XDMModel getXDMModel() {
        return ((XDMAccess)this.model.getAccess()).getXDMModel();
    }

    void startSync() {
        this.inSync = true;
        this.syncUnits.clear();
        this.oldDocument = this.getXDMModel().getCurrentDocument();
        this.getXDMModel().addPropertyChangeListener(this);
    }

    Document getOldDocument() {
        return this.oldDocument;
    }

    void endSync() {
        this.endSync(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endSync(boolean bl) {
        this.getXDMModel().removePropertyChangeListener(this);
        try {
            if (bl) {
                for (SyncUnit syncUnit : this.syncUnits.values()) {
                    this.model.processSyncUnit(syncUnit);
                }
            }
        }
        finally {
            this.syncUnits.clear();
            this.inSync = false;
        }
    }

    private static Integer getID(ChangeInfo changeInfo) {
        if (changeInfo.getParent() == null) {
            return 0;
        }
        org.netbeans.modules.xml.xdm.nodes.Element element = (org.netbeans.modules.xml.xdm.nodes.Element)changeInfo.getParent();
        return element.getId();
    }

    private static Integer getID(DocumentComponent documentComponent) {
        if (documentComponent == null) {
            return 0;
        }
        org.netbeans.modules.xml.xdm.nodes.Element element = (org.netbeans.modules.xml.xdm.nodes.Element)((AbstractDocumentComponent)documentComponent).getPeer();
        return element.getId();
    }

    protected void processChange(ChangeInfo changeInfo) {
        Integer n = XDMListener.getID(changeInfo);
        SyncUnit syncUnit = this.syncUnits.get(n);
        SyncUnit syncUnit2 = this.model.prepareSyncUnit(changeInfo, syncUnit);
        if (syncUnit2 == null) {
            return;
        }
        Integer n2 = XDMListener.getID(syncUnit2.getTarget());
        syncUnit = this.syncUnits.get(n2);
        if (syncUnit == null) {
            if (n.equals(n2)) {
                this.syncUnits.put(n2, syncUnit2);
            } else {
                syncUnit = this.syncUnits.get(n2);
                if (syncUnit != null) {
                    syncUnit.merge(syncUnit2);
                } else {
                    this.syncUnits.put(n2, syncUnit2);
                }
            }
        } else if (syncUnit != syncUnit2) {
            if (n.equals(n2)) {
                syncUnit.merge(syncUnit2);
            } else {
                this.syncUnits.remove(n);
                syncUnit = this.syncUnits.get(n2);
                if (syncUnit != null) {
                    syncUnit.merge(syncUnit2);
                } else {
                    this.syncUnits.put(n2, syncUnit2);
                }
            }
        }
    }

    protected void processEvent(Node node, List<Node> list, boolean bl) {
        if (list.size() == 1) {
            assert (list.get(0) instanceof Document);
            if (!(node instanceof org.netbeans.modules.xml.xdm.nodes.Element)) {
                return;
            }
            if (!bl) {
                return;
            }
            DocumentComponent documentComponent = null;
            String string = null;
            try {
                documentComponent = this.model.createRootComponent((Element)((org.netbeans.modules.xml.xdm.nodes.Element)node));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = illegalArgumentException.getMessage();
            }
            if (documentComponent == null) {
                string = string != null ? string : "Unexpected root element " + AbstractDocumentComponent.getQName((org.w3c.dom.Node)node);
                throw new IllegalArgumentException(new IOException(string));
            }
            this.model.firePropertyChangeEvent(new PropertyChangeEvent(this.model, "state", Model.State.NOT_SYNCED, Model.State.VALID));
        } else {
            if (node.getId() == list.get(0).getId()) {
                throw new IllegalArgumentException("Event node has same id as parent");
            }
            list = new ArrayList<Node>(list);
            list.add(0, node);
            ChangeInfo changeInfo = this.model.prepareChangeInfo(XDMListener.toDomNodes(list));
            changeInfo.setAdded(bl);
            this.processChange(changeInfo);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Node node;
        if (!this.inSync) {
            return;
        }
        NodeInfo nodeInfo = (NodeInfo)propertyChangeEvent.getOldValue();
        NodeInfo nodeInfo2 = (NodeInfo)propertyChangeEvent.getNewValue();
        Node node2 = nodeInfo != null ? nodeInfo.getNode() : null;
        Node node3 = node = nodeInfo2 != null ? nodeInfo2.getNode() : null;
        if (node2 != null) {
            this.processEvent(node2, nodeInfo.getNewAncestors(), false);
        }
        if (node != null) {
            this.processEvent(node, nodeInfo2.getNewAncestors(), true);
        }
    }

    static List<org.w3c.dom.Node> toDomNodes(List<Node> list) {
        ArrayList<org.w3c.dom.Node> arrayList = new ArrayList<org.w3c.dom.Node>();
        for (Node node : list) {
            arrayList.add(node);
        }
        return arrayList;
    }
}

