/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Profile;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class NewProfilePanel
extends JPanel {
    private POMModel model;
    private NotificationLineSupport nls;
    private JCheckBox cbActFile;
    private JCheckBox cbActOS;
    private JCheckBox cbActProperty;
    private JCheckBox cbDependencies;
    private JCheckBox cbPlugins;
    private JLabel lblId;
    private JTextField txtId;

    public NewProfilePanel(POMModel pOMModel) {
        this.initComponents();
        this.model = pOMModel;
        boolean bl = "pom".equals(pOMModel.getProject().getPackaging());
        if (!bl) {
            Mnemonics.setLocalizedText((AbstractButton)this.cbPlugins, (String)NbBundle.getMessage(NewProfilePanel.class, (String)"NewProfilePanel.cbPlugins.text2"));
            Mnemonics.setLocalizedText((AbstractButton)this.cbDependencies, (String)NbBundle.getMessage(NewProfilePanel.class, (String)"NewProfilePanel.cbDependencies.text2"));
        }
        this.txtId.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                NewProfilePanel.this.checkId();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                NewProfilePanel.this.checkId();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                NewProfilePanel.this.checkId();
            }
        });
    }

    public void attachDialogDisplayer(DialogDescriptor dialogDescriptor) {
        this.nls = dialogDescriptor.getNotificationLineSupport();
        if (this.nls == null) {
            this.nls = dialogDescriptor.createNotificationLineSupport();
        }
    }

    public void addNotify() {
        super.addNotify();
        assert (this.nls != null) : " The notificationLineSupport was not attached to the panel.";
    }

    private void checkId() {
        String string = this.txtId.getText().trim();
        Profile profile = this.model.getProject().findProfileById(string);
        if (profile != null) {
            this.nls.setErrorMessage(NbBundle.getMessage(NewProfilePanel.class, (String)"ERR_SameProfileId"));
        } else {
            this.nls.clearMessages();
        }
    }

    private void initComponents() {
        this.lblId = new JLabel();
        this.txtId = new JTextField();
        this.cbActProperty = new JCheckBox();
        this.cbActOS = new JCheckBox();
        this.cbActFile = new JCheckBox();
        this.cbPlugins = new JCheckBox();
        this.cbDependencies = new JCheckBox();
        this.lblId.setLabelFor(this.txtId);
        Mnemonics.setLocalizedText((JLabel)this.lblId, (String)NbBundle.getMessage(NewProfilePanel.class, (String)"NewProfilePanel.lblId.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbActProperty, (String)NbBundle.getMessage(NewProfilePanel.class, (String)"NewProfilePanel.cbActProperty.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbActOS, (String)NbBundle.getMessage(NewProfilePanel.class, (String)"NewProfilePanel.cbActOS.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbActFile, (String)NbBundle.getMessage(NewProfilePanel.class, (String)"NewProfilePanel.cbActFile.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbPlugins, (String)NbBundle.getMessage(NewProfilePanel.class, (String)"NewProfilePanel.cbPlugins.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbDependencies, (String)NbBundle.getMessage(NewProfilePanel.class, (String)"NewProfilePanel.cbDependencies.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbDependencies).add((Component)this.cbPlugins).add((Component)this.cbActFile).add((Component)this.cbActOS).add((Component)this.cbActProperty).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblId).addPreferredGap(0).add((Component)this.txtId, -1, 234, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblId).add((Component)this.txtId, -2, -1, -2)).add(18, 18, 18).add((Component)this.cbActProperty).addPreferredGap(0).add((Component)this.cbActOS).addPreferredGap(0).add((Component)this.cbActFile).add(18, 18, 18).add((Component)this.cbPlugins).addPreferredGap(0).add((Component)this.cbDependencies).addContainerGap(64, Short.MAX_VALUE)));
    }

    String getProfileId() {
        return this.txtId.getText();
    }

    boolean isActivation() {
        return this.isActiovationByFile() || this.isActiovationByOS() || this.isActiovationByProperty();
    }

    boolean isActiovationByProperty() {
        return this.cbActProperty.isSelected();
    }

    boolean isActiovationByOS() {
        return this.cbActOS.isSelected();
    }

    boolean isActiovationByFile() {
        return this.cbActFile.isSelected();
    }

    boolean generateDependencies() {
        return this.cbDependencies.isSelected();
    }

    boolean generatePlugins() {
        return this.cbPlugins.isSelected();
    }
}

