/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.maven.codegen.NewProfilePanel;
import org.netbeans.modules.maven.model.settings.Mirror;
import org.netbeans.modules.maven.model.settings.SettingsModel;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class NewMirrorPanel
extends JPanel {
    private SettingsModel model;
    private NotificationLineSupport nls;
    private static final String CENTRAL = "central";
    private static final String ALL = "*";
    private static final String ALL_NON_LOCAL = "external:*";
    private static final String ALL_BUT_FOO = "*,!foo";
    private static final String LIST = "foo,bar";
    private final String[] MIRROROFS = new String[]{"central", "*", "external:*", "*,!foo", "foo,bar"};
    private DefaultComboBoxModel urlmodel;
    private JButton btnLink;
    private JComboBox comMirrorOf;
    private JComboBox comUrl;
    private JLabel lblId;
    private JLabel lblMirrorOf;
    private JLabel lblUrl;
    private JTextField txtId;

    public NewMirrorPanel(SettingsModel settingsModel) {
        this.initComponents();
        this.model = settingsModel;
        this.txtId.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                NewMirrorPanel.this.checkId();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                NewMirrorPanel.this.checkId();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                NewMirrorPanel.this.checkId();
            }
        });
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(this.MIRROROFS);
        this.comMirrorOf.setModel(defaultComboBoxModel);
        this.comMirrorOf.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (component instanceof JLabel) {
                    JLabel jLabel = (JLabel)component;
                    if (NewMirrorPanel.CENTRAL.equals(object)) {
                        jLabel.setText(NbBundle.getMessage(NewMirrorPanel.class, (String)"LBL_Central"));
                    } else if (NewMirrorPanel.ALL.equals(object)) {
                        jLabel.setText(NbBundle.getMessage(NewMirrorPanel.class, (String)"LBL_All"));
                    } else if (NewMirrorPanel.ALL_NON_LOCAL.equals(object)) {
                        jLabel.setText(NbBundle.getMessage(NewMirrorPanel.class, (String)"LBL_NonLocal"));
                    } else if (NewMirrorPanel.ALL_BUT_FOO.equals(object)) {
                        jLabel.setText(NbBundle.getMessage(NewMirrorPanel.class, (String)"LBL_AllButFoo"));
                    } else if (NewMirrorPanel.LIST.equals(object)) {
                        jLabel.setText(NbBundle.getMessage(NewMirrorPanel.class, (String)"LBL_List"));
                    }
                }
                return component;
            }
        });
        Component component = this.comMirrorOf.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            JTextField jTextField = (JTextField)component;
            jTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    NewMirrorPanel.this.checkCentral();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    NewMirrorPanel.this.checkCentral();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    NewMirrorPanel.this.checkCentral();
                }
            });
        }
        this.urlmodel = new DefaultComboBoxModel();
        this.comUrl.setModel(this.urlmodel);
        this.btnLink.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URL uRL = new URL("http://maven.apache.org/guides/mini/guide-mirror-settings.html");
                    HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    Exceptions.printStackTrace((Throwable)malformedURLException);
                }
            }
        });
        this.checkCentral();
    }

    public void attachDialogDisplayer(DialogDescriptor dialogDescriptor) {
        this.nls = dialogDescriptor.getNotificationLineSupport();
        if (this.nls == null) {
            this.nls = dialogDescriptor.createNotificationLineSupport();
        }
    }

    public void addNotify() {
        super.addNotify();
        assert (this.nls != null) : " The notificationLineSupport was not attached to the panel.";
    }

    private void checkId() {
        String string = this.txtId.getText().trim();
        Mirror mirror = this.model.getSettings().findMirrorById(string);
        if (mirror != null) {
            this.nls.setErrorMessage(NbBundle.getMessage(NewProfilePanel.class, (String)"ERR_SameMirrorId"));
        } else {
            this.nls.clearMessages();
        }
    }

    private void checkCentral() {
        String string = (String)this.comMirrorOf.getSelectedItem();
        this.urlmodel.removeAllElements();
        if (CENTRAL.equals(string)) {
            this.urlmodel.addElement("http://mirrors.ibiblio.org/pub/mirrors/maven2");
            this.urlmodel.addElement("http://www.ibiblio.net/pub/packages/maven2");
            this.urlmodel.addElement("http://ftp.cica.es/mirrors/maven2");
            this.urlmodel.addElement("http://repo1.sonatype.net/maven2");
            this.urlmodel.addElement("http://repo.exist.com/maven2");
            this.urlmodel.addElement("http://mirrors.redv.com/maven2");
            this.urlmodel.addElement("http://mirrors.dotsrc.org/maven2");
        }
    }

    private void initComponents() {
        this.lblId = new JLabel();
        this.txtId = new JTextField();
        this.lblMirrorOf = new JLabel();
        this.comMirrorOf = new JComboBox();
        this.lblUrl = new JLabel();
        this.comUrl = new JComboBox();
        this.btnLink = new JButton();
        this.lblId.setLabelFor(this.txtId);
        Mnemonics.setLocalizedText((JLabel)this.lblId, (String)NbBundle.getMessage(NewMirrorPanel.class, (String)"NewMirrorPanel.lblId.text"));
        this.lblMirrorOf.setLabelFor(this.comMirrorOf);
        Mnemonics.setLocalizedText((JLabel)this.lblMirrorOf, (String)NbBundle.getMessage(NewMirrorPanel.class, (String)"NewMirrorPanel.lblMirrorOf.text"));
        this.comMirrorOf.setEditable(true);
        this.comMirrorOf.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.lblUrl.setLabelFor(this.comUrl);
        Mnemonics.setLocalizedText((JLabel)this.lblUrl, (String)NbBundle.getMessage(NewMirrorPanel.class, (String)"NewMirrorPanel.lblUrl.text"));
        this.comUrl.setEditable(true);
        this.comUrl.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLink, (String)NbBundle.getMessage(NewMirrorPanel.class, (String)"NewMirrorPanel.btnLink.text"));
        this.btnLink.setBorder(null);
        this.btnLink.setBorderPainted(false);
        this.btnLink.setContentAreaFilled(false);
        this.btnLink.setHorizontalAlignment(2);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblMirrorOf).add((Component)this.lblId)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.txtId, -1, 158, Short.MAX_VALUE).add(145, 145, 145)).add((Component)this.comMirrorOf, 0, 303, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblUrl).addPreferredGap(1).add((Component)this.comUrl, 0, 303, Short.MAX_VALUE)).add((Component)this.btnLink, -1, 390, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblId).add((Component)this.txtId, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblMirrorOf).add((Component)this.comMirrorOf, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblUrl).add((Component)this.comUrl, -2, -1, -2)).add(18, 18, 18).add((Component)this.btnLink).addContainerGap(36, Short.MAX_VALUE)));
    }

    String getMirrorId() {
        return this.txtId.getText().trim();
    }

    String getMirrorOf() {
        return (String)this.comMirrorOf.getSelectedItem();
    }

    String getMirrorUrl() {
        return (String)this.comUrl.getSelectedItem();
    }
}

