/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.beans.BeanPanelUI;
import org.netbeans.modules.beans.BeanUtils;
import org.netbeans.modules.beans.ClassPattern;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.beans.TmpPattern;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PatternAnalyser {
    private BeanPanelUI ui;
    private FileObject fileObject;
    private ElementHandle<TypeElement> classElementHandle;
    private ArrayList<ClassPattern> currentClassesPatterns = new ArrayList();
    private ArrayList<PropertyPattern> currentPropertyPatterns = new ArrayList();
    private ArrayList<IdxPropertyPattern> currentIdxPropertyPatterns = new ArrayList();
    private ArrayList<EventSetPattern> currentEventSetPatterns = new ArrayList();
    final AtomicBoolean canceled = new AtomicBoolean();
    private boolean deepIntrospection = false;
    static final Logger LOG = Logger.getLogger(PatternAnalyser.class.getName());

    public PatternAnalyser(FileObject fileObject, BeanPanelUI beanPanelUI) {
        this(fileObject, beanPanelUI, false);
    }

    public PatternAnalyser(FileObject fileObject, BeanPanelUI beanPanelUI, boolean bl) {
        this.fileObject = fileObject;
        this.ui = beanPanelUI;
        this.deepIntrospection = bl;
    }

    public PatternAnalyser(FileObject fileObject, BeanPanelUI beanPanelUI, Collection<ClassPattern> collection) {
        this(fileObject, beanPanelUI);
        this.currentClassesPatterns.addAll(collection);
    }

    public List<PropertyPattern> getPropertyPatterns() {
        return this.currentPropertyPatterns;
    }

    public List<IdxPropertyPattern> getIdxPropertyPatterns() {
        return this.currentIdxPropertyPatterns;
    }

    public List<EventSetPattern> getEventSetPatterns() {
        return this.currentEventSetPatterns;
    }

    public List<Pattern> getPatterns() {
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>(this.currentClassesPatterns.size() + this.currentEventSetPatterns.size() + this.currentIdxPropertyPatterns.size() + this.currentIdxPropertyPatterns.size());
        arrayList.addAll(this.currentPropertyPatterns);
        arrayList.addAll(this.currentIdxPropertyPatterns);
        arrayList.addAll(this.currentEventSetPatterns);
        arrayList.addAll(this.currentClassesPatterns);
        return arrayList;
    }

    public ElementHandle<TypeElement> getClassElementHandle() {
        return this.classElementHandle;
    }

    public BeanPanelUI getUI() {
        return this.ui;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public void analyzeAll(CompilationInfo compilationInfo, TypeElement typeElement) {
        if (this.isCanceled()) {
            return;
        }
        Parameters parameters = new Parameters(compilationInfo, typeElement);
        this.classElementHandle = ElementHandle.create((Element)typeElement);
        this.resolveMethods(parameters);
        this.resolveFields(parameters);
        this.resolveTypes(parameters);
        try {
            this.resolveChangesOfProperties(parameters);
            this.resolveChangesOfIdxProperties(parameters);
            this.resolveChangesOfEventSets(parameters);
        }
        catch (IntrospectionException introspectionException) {
            Exceptions.printStackTrace((Throwable)introspectionException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCanceled() {
        AtomicBoolean atomicBoolean = this.canceled;
        synchronized (atomicBoolean) {
            return this.canceled.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        AtomicBoolean atomicBoolean = this.canceled;
        synchronized (atomicBoolean) {
            this.canceled.set(true);
        }
    }

    private void resolveTypes(Parameters parameters) {
        List<TypeElement> list = ElementFilter.typesIn(parameters.element.getEnclosedElements());
        for (TypeElement typeElement : list) {
            if (typeElement.getKind() != ElementKind.CLASS && typeElement.getKind() != ElementKind.INTERFACE) continue;
            PatternAnalyser patternAnalyser = new PatternAnalyser(parameters.ci.getFileObject(), this.ui);
            patternAnalyser.analyzeAll(parameters.ci, typeElement);
            ClassPattern classPattern = new ClassPattern(patternAnalyser, typeElement.asType(), BeanUtils.nameAsString(typeElement));
            this.currentClassesPatterns.add(classPattern);
        }
    }

    private void resolveMethods(Parameters parameters) {
        List<? extends VariableElement> list;
        Object object;
        List<? extends ExecutableElement> list2 = this.methodsIn(parameters.element, parameters.ci);
        HashMap<String, ExecutableElement> hashMap = new HashMap<String, ExecutableElement>();
        HashMap<String, ExecutableElement> hashMap2 = new HashMap<String, ExecutableElement>();
        for (ExecutableElement object2 : list2) {
            if (!object2.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            object = BeanUtils.nameAsString(object2);
            int n = ((String)object).length();
            if ((((String)object).startsWith("get") && n > "get".length() || ((String)object).startsWith("set") && n > "set".length() || ((String)object).startsWith("is") && n > "is".length()) && (list = this.analyseMethodForProperties(parameters, object2)) != null) {
                this.addProperty(parameters, (TmpPattern.Property)((Object)list));
            }
            if ((!((String)object).startsWith("add") || n <= "add".length()) && (!((String)object).startsWith("remove") || n <= "remove".length())) continue;
            this.analyseMethodForEventSets(parameters, object2, hashMap, hashMap2);
        }
        for (String string : hashMap.keySet()) {
            if (hashMap2.get(string) == null || string.indexOf("Listener:") <= 0) continue;
            object = (ExecutableElement)hashMap.get(string);
            ExecutableElement executableElement = (ExecutableElement)hashMap2.get(string);
            list = object.getParameters();
            TypeMirror typeMirror = ((VariableElement)list.get(0)).asType();
            if (typeMirror.getKind() != TypeKind.DECLARED || !parameters.ci.getTypes().isSubtype(typeMirror, parameters.ci.getElements().getTypeElement("java.util.EventListener").asType())) continue;
            TmpPattern.EventSet eventSet = new TmpPattern.EventSet(parameters.ci, (ExecutableElement)object, executableElement);
            this.addEventSet(parameters, eventSet);
        }
    }

    private List<? extends ExecutableElement> methodsIn(TypeElement typeElement, CompilationInfo compilationInfo) {
        return this.deepIntrospection ? BeanUtils.methodsIn(typeElement, compilationInfo) : ElementFilter.methodsIn(typeElement.getEnclosedElements());
    }

    private void resolveFields(Parameters parameters) {
        List<VariableElement> list = ElementFilter.fieldsIn(parameters.element.getEnclosedElements());
        String string = "this.";
        for (VariableElement variableElement : list) {
            TypeMirror typeMirror;
            TmpPattern.Property property;
            if (variableElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
            String string2 = BeanUtils.nameAsString(variableElement);
            if (string2.startsWith(string)) {
                string2 = string2.substring(1);
            }
            if ((property = (TmpPattern.Property)parameters.propertyPatterns.get(string2)) == null) {
                property = (TmpPattern.Property)parameters.idxPropertyPatterns.get(string2);
            }
            if (property == null || (typeMirror = property.type) == null || !((Object)typeMirror).equals(variableElement.asType())) continue;
            property.estimatedField = variableElement;
        }
    }

    TmpPattern.Property analyseMethodForProperties(Parameters parameters, ExecutableElement executableElement) {
        if (executableElement.getModifiers().contains((Object)Modifier.STATIC)) {
            return null;
        }
        String string = BeanUtils.nameAsString(executableElement);
        VariableElement[] variableElementArray = executableElement.getParameters().toArray(new VariableElement[0]);
        TypeMirror typeMirror = executableElement.getReturnType();
        TmpPattern.Property property = null;
        try {
            if (variableElementArray.length == 0) {
                if (string.startsWith("get")) {
                    property = new TmpPattern.Property(parameters.ci, executableElement, null);
                } else if (typeMirror.getKind() == TypeKind.BOOLEAN && string.startsWith("is")) {
                    property = new TmpPattern.Property(parameters.ci, executableElement, null);
                }
            } else if (variableElementArray.length == 1) {
                if (variableElementArray[0].asType().getKind() == TypeKind.INT && string.startsWith("get")) {
                    property = new TmpPattern.IdxProperty(parameters.ci, null, null, executableElement, null);
                } else if (typeMirror.getKind() == TypeKind.VOID && string.startsWith("set")) {
                    property = new TmpPattern.Property(parameters.ci, null, executableElement);
                }
            } else if (variableElementArray.length == 2 && variableElementArray[0].asType().getKind() == TypeKind.INT && string.startsWith("set")) {
                property = new TmpPattern.IdxProperty(parameters.ci, null, null, null, executableElement);
            }
        }
        catch (IntrospectionException introspectionException) {
            LOG.log(Level.INFO, introspectionException.getMessage(), introspectionException);
            property = null;
        }
        return property;
    }

    void analyseMethodForEventSets(Parameters parameters, ExecutableElement executableElement, Map<String, ExecutableElement> map, Map<String, ExecutableElement> map2) {
        TypeMirror typeMirror;
        if (executableElement.getModifiers().contains((Object)Modifier.STATIC)) {
            return;
        }
        String string = BeanUtils.nameAsString(executableElement);
        VariableElement[] variableElementArray = executableElement.getParameters().toArray(new VariableElement[0]);
        TypeMirror typeMirror2 = executableElement.getReturnType();
        if (variableElementArray.length == 1 && typeMirror2.getKind() == TypeKind.VOID && (typeMirror = variableElementArray[0].asType()).getKind() == TypeKind.DECLARED) {
            Element element = parameters.ci.getTypes().asElement(typeMirror);
            String string2 = BeanUtils.nameAsString(element);
            if (string.startsWith("add") && string.substring(3).equals(string2)) {
                String string3 = string.substring(3) + ":" + BeanUtils.nameAsString(element);
                map.put(string3, executableElement);
            } else if (string.startsWith("remove") && string.substring(6).equals(string2)) {
                String string4 = string.substring(6) + ":" + BeanUtils.nameAsString(element);
                map2.put(string4, executableElement);
            }
        }
    }

    private void addProperty(Parameters parameters, TmpPattern.Property property) {
        boolean bl = property instanceof TmpPattern.IdxProperty;
        HashMap hashMap = bl ? parameters.idxPropertyPatterns : parameters.propertyPatterns;
        String string = property.name;
        TmpPattern.Property property2 = (TmpPattern.Property)parameters.propertyPatterns.get(string);
        if (property2 == null) {
            property2 = (TmpPattern.Property)parameters.idxPropertyPatterns.get(string);
        }
        if (property2 == null) {
            hashMap.put(string, property);
            return;
        }
        TypeMirror typeMirror = property2.type;
        TypeMirror typeMirror2 = property.type;
        if (typeMirror != null && typeMirror2 != null && !parameters.ci.getTypes().isSameType(typeMirror, typeMirror2)) {
            hashMap.put(string, property);
            return;
        }
        boolean bl2 = property2 instanceof TmpPattern.IdxProperty;
        if (bl || bl2) {
            if (bl && !bl2) {
                parameters.propertyPatterns.remove(property2.name);
            } else if (!bl && bl2) {
                parameters.idxPropertyPatterns.remove(property2.name);
            }
            TmpPattern.IdxProperty idxProperty = new TmpPattern.IdxProperty(parameters.ci, property2, property);
            parameters.idxPropertyPatterns.put(string, idxProperty);
        } else {
            TmpPattern.Property property3 = new TmpPattern.Property(parameters.ci, property2, property);
            parameters.propertyPatterns.put(string, property3);
        }
    }

    private void addEventSet(Parameters parameters, TmpPattern.EventSet eventSet) {
        String string = eventSet.name + parameters.ci.getTypes().asElement(eventSet.type).getSimpleName();
        TmpPattern.EventSet eventSet2 = (TmpPattern.EventSet)parameters.eventSetPatterns.get(string);
        if (eventSet2 == null) {
            parameters.eventSetPatterns.put(string, eventSet);
            return;
        }
        TmpPattern.EventSet eventSet3 = new TmpPattern.EventSet(eventSet2, eventSet);
        parameters.eventSetPatterns.put(string, eventSet3);
    }

    private void resolveChangesOfProperties(Parameters parameters) throws IntrospectionException {
        this.currentPropertyPatterns = new ArrayList(parameters.propertyPatterns.size());
        for (TmpPattern.Property property : parameters.propertyPatterns.values()) {
            this.currentPropertyPatterns.add(property.createPattern(this));
        }
        Collections.sort(this.currentPropertyPatterns, Pattern.NAME_COMPARATOR);
    }

    private void resolveChangesOfIdxProperties(Parameters parameters) throws IntrospectionException {
        this.currentIdxPropertyPatterns = new ArrayList(parameters.idxPropertyPatterns.size());
        for (TmpPattern.IdxProperty idxProperty : parameters.idxPropertyPatterns.values()) {
            this.currentIdxPropertyPatterns.add(idxProperty.createPattern(this));
        }
        Collections.sort(this.currentIdxPropertyPatterns, Pattern.NAME_COMPARATOR);
    }

    private void resolveChangesOfEventSets(Parameters parameters) {
        this.currentEventSetPatterns = new ArrayList(parameters.eventSetPatterns.size());
        for (TmpPattern.EventSet eventSet : parameters.eventSetPatterns.values()) {
            this.currentEventSetPatterns.add(eventSet.createPattern(this));
        }
        Collections.sort(this.currentEventSetPatterns, Pattern.NAME_COMPARATOR);
    }

    private static class Parameters {
        private CompilationInfo ci;
        private TypeElement element;
        private HashMap<String, TmpPattern.Property> propertyPatterns;
        private HashMap<String, TmpPattern.IdxProperty> idxPropertyPatterns;
        private HashMap<String, TmpPattern.EventSet> eventSetPatterns;

        Parameters(CompilationInfo compilationInfo, TypeElement typeElement) {
            this.ci = compilationInfo;
            this.element = typeElement;
            this.propertyPatterns = new HashMap();
            this.idxPropertyPatterns = new HashMap();
            this.eventSetPatterns = new HashMap();
        }
    }
}

