/*
 * Decompiled with CFR 0.152.
 */
package freemind.preferences.layout;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import freemind.common.BooleanProperty;
import freemind.common.ColorProperty;
import freemind.common.ComboProperty;
import freemind.common.DontShowNotificationProperty;
import freemind.common.NextLineProperty;
import freemind.common.NumberProperty;
import freemind.common.PropertyBean;
import freemind.common.PropertyControl;
import freemind.common.RemindValueProperty;
import freemind.common.SeparatorProperty;
import freemind.common.StringProperty;
import freemind.common.TextTranslator;
import freemind.common.XmlBindingTools;
import freemind.controller.actions.generated.instance.OptionPanelWindowConfigurationStorage;
import freemind.controller.actions.generated.instance.WindowConfigurationStorage;
import freemind.main.FreeMind;
import freemind.main.Tools;
import freemind.modes.IconInformation;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.NodeGeneralAction;
import freemind.preferences.FreemindPropertyContributor;
import freemind.preferences.layout.GrabKeyDialog;
import freemind.preferences.layout.VariableSizeCardLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;

public class OptionPanel
implements TextTranslator {
    private static final Color MARKED_BUTTON_COLOR = Color.BLUE;
    private Vector controls;
    private final JDialog frame;
    private HashMap tabButtonMap = new HashMap();
    private HashMap tabActionMap = new HashMap();
    private String selectedPanel = null;
    private static JColorChooser colorChooser;
    private final OptionPanelFeedback feedback;
    private static FreeMind fmMain;
    private static final String PREFERENCE_STORAGE_PROPERTY = "OptionPanel_Window_Properties";
    private static final String DEFAULT_LAYOUT_FORMAT = "right:max(40dlu;p), 4dlu, 120dlu, 7dlu";
    public static Vector changeListeners;
    private static String lastKey;
    private static Set sContributors;

    public OptionPanel(FreeMind fm, JDialog frame, OptionPanelFeedback feedback) {
        if (fmMain == null) {
            fmMain = fm;
        }
        this.frame = frame;
        this.feedback = feedback;
        WindowConfigurationStorage storage = XmlBindingTools.getInstance().decorateDialog(fm.getController(), frame, PREFERENCE_STORAGE_PROPERTY);
        if (storage != null && storage instanceof OptionPanelWindowConfigurationStorage) {
            OptionPanelWindowConfigurationStorage oWindowSettings = (OptionPanelWindowConfigurationStorage)storage;
            this.selectedPanel = oWindowSettings.getPanel();
        }
    }

    public void setProperties() {
        Iterator i = this.controls.iterator();
        while (i.hasNext()) {
            PropertyControl control = (PropertyControl)i.next();
            if (!(control instanceof PropertyBean)) continue;
            PropertyBean bean = (PropertyBean)((Object)control);
            String label = bean.getLabel();
            String value = fmMain.getAdjustableProperty(label);
            bean.setValue(value);
        }
    }

    private Properties getOptionProperties() {
        Properties p = new Properties();
        Iterator i = this.controls.iterator();
        while (i.hasNext()) {
            PropertyBean bean;
            String value;
            PropertyControl control = (PropertyControl)i.next();
            if (!(control instanceof PropertyBean) || (value = (bean = (PropertyBean)((Object)control)).getValue()) == null) continue;
            p.setProperty(bean.getLabel(), value);
        }
        return p;
    }

    public void buildPanel() {
        FormLayout leftLayout = new FormLayout("80dlu", "");
        DefaultFormBuilder leftBuilder = new DefaultFormBuilder(leftLayout);
        VariableSizeCardLayout cardLayout = new VariableSizeCardLayout();
        JPanel rightStack = new JPanel(cardLayout);
        FormLayout rightLayout = null;
        PanelBuilder rightBuilder = null;
        String lastTabName = null;
        this.controls = this.getControls();
        Iterator i = this.controls.iterator();
        while (i.hasNext()) {
            PropertyControl control = (PropertyControl)i.next();
            if (control instanceof NewTabProperty) {
                NewTabProperty newTab = (NewTabProperty)control;
                if (rightBuilder != null) {
                    rightStack.add((Component)rightBuilder.getPanel(), lastTabName);
                }
                rightLayout = new FormLayout(newTab.getDescription(), "");
                rightBuilder = new DefaultFormBuilder(rightLayout);
                rightBuilder.setDefaultDialogBorder();
                lastTabName = newTab.getLabel();
                JButton tabButton = new JButton(this.getText(lastTabName));
                ChangeTabAction changeTabAction = new ChangeTabAction(cardLayout, rightStack, lastTabName);
                tabButton.addActionListener(changeTabAction);
                this.registerTabButton(tabButton, lastTabName, changeTabAction);
                leftBuilder.append(tabButton);
                continue;
            }
            control.layout((DefaultFormBuilder)rightBuilder, this);
        }
        rightStack.add((Component)rightBuilder.getPanel(), lastTabName);
        if (this.selectedPanel != null && this.tabActionMap.containsKey(this.selectedPanel)) {
            ((ChangeTabAction)this.tabActionMap.get(this.selectedPanel)).actionPerformed(null);
        }
        JScrollPane rightScrollPane = new JScrollPane(rightStack);
        rightScrollPane.getVerticalScrollBar().setUnitIncrement(100);
        JSplitPane centralPanel = new JSplitPane(1, leftBuilder.getPanel(), rightScrollPane);
        this.frame.getContentPane().add((Component)centralPanel, "Center");
        JButton cancelButton = new JButton(this.getText("Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                OptionPanel.this.closeWindow();
            }
        });
        JButton okButton = new JButton(this.getText("OK"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                OptionPanel.this.feedback.writeProperties(OptionPanel.this.getOptionProperties());
                OptionPanel.this.closeWindow();
            }
        });
        this.frame.getRootPane().setDefaultButton(okButton);
        this.frame.getContentPane().add((Component)ButtonBarFactory.buildOKCancelBar(cancelButton, okButton), "South");
    }

    public String getText(String string) {
        if (string == null) {
            return null;
        }
        OptionPanel.checkConnectionToFreeMindMain();
        return fmMain.getResourceString("OptionPanel." + string);
    }

    private static void checkConnectionToFreeMindMain() {
        if (fmMain == null) {
            throw new IllegalArgumentException("FreeMindMain not set yet.");
        }
    }

    private void registerTabButton(JButton tabButton, String name, ChangeTabAction changeTabAction) {
        this.tabButtonMap.put(name, tabButton);
        this.tabActionMap.put(name, changeTabAction);
        if (this.selectedPanel == null) {
            this.selectedPanel = name;
        }
    }

    private JButton getTabButton(String name) {
        return (JButton)this.tabButtonMap.get(name);
    }

    private Collection getAllButtons() {
        return this.tabButtonMap.values();
    }

    private Vector getControls() {
        Vector<PropertyControl> controls = new Vector<PropertyControl>();
        controls.add(new NewTabProperty("Environment"));
        controls.add(new SeparatorProperty("language"));
        controls.add(new ComboProperty("language.tooltip", "language", new String[]{"automatic", "ar", "cs", "de", "dk", "en", "el", "es", "et", "fr", "gl", "hr", "hu", "id", "it", "ja", "kr", "lt", "nl", "nn", "nb", "pl", "pt_BR", "pt_PT", "ro", "ru", "sk", "se", "sl", "tr", "uk_UA", "vi", "zh_TW", "zh_CN"}, new TextTranslator(){

            public String getText(String pKey) {
                return Tools.removeTranslateComment(OptionPanel.this.getText(pKey));
            }
        }));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("files"));
        controls.add(new StringProperty(null, "last_opened_list_length"));
        controls.add(new BooleanProperty("loadLastMap.tooltip", "loadLastMap"));
        controls.add(new BooleanProperty("experimental_file_locking_on.tooltip", "experimental_file_locking_on"));
        controls.add(new NextLineProperty());
        controls.add(new StringProperty(null, "userproperties"));
        controls.add(new StringProperty(null, "patternsfile"));
        controls.add(new StringProperty("browsemode_initial_map.tooltip", "browsemode_initial_map"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("automatic_save"));
        controls.add(new StringProperty("time_for_automatic_save.tooltip", "time_for_automatic_save"));
        controls.add(new BooleanProperty("delete_automatic_saves_at_exit.tooltip", "delete_automatic_saves_at_exit"));
        controls.add(new StringProperty("number_of_different_files_for_automatic_save.tooltip", "number_of_different_files_for_automatic_save"));
        controls.add(new StringProperty("path_to_automatic_saves.tooltip", "path_to_automatic_saves"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("save"));
        controls.add(new BooleanProperty("resources_save_folding_state.tooltip", "resources_save_folding_state"));
        controls.add(new BooleanProperty("save_only_intrisically_needed_ids.tooltip", "save_only_intrisically_needed_ids"));
        controls.add(new NewTabProperty("Defaults"));
        controls.add(new SeparatorProperty("default_styles"));
        controls.add(new ComboProperty("standardnodestyle.tooltip", "standardnodestyle", MindMapNode.NODE_STYLES, this));
        controls.add(new ComboProperty("standardrootnodestyle.tooltip", "standardrootnodestyle", new String[]{"fork", "bubble", "combined"}, this));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("default_colors"));
        controls.add(new ColorProperty("standardnodetextcolor.tooltip", "standardnodetextcolor", fmMain.getDefaultProperty("standardnodetextcolor"), this));
        controls.add(new ColorProperty("standardedgecolor.tooltip", "standardedgecolor", fmMain.getDefaultProperty("standardedgecolor"), this));
        controls.add(new ColorProperty("standardlinkcolor.tooltip", "standardlinkcolor", fmMain.getDefaultProperty("standardlinkcolor"), this));
        controls.add(new ColorProperty("standardbackgroundcolor.tooltip", "standardbackgroundcolor", fmMain.getDefaultProperty("standardbackgroundcolor"), this));
        controls.add(new BooleanProperty("printonwhitebackground.tooltip", "printonwhitebackground"));
        controls.add(new ColorProperty("standardcloudcolor.tooltip", "standardcloudcolor", fmMain.getDefaultProperty("standardcloudcolor"), this));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("default_fonts"));
        controls.add(new StringProperty("defaultfont.tooltip", "defaultfont"));
        controls.add(new StringProperty(null, "defaultfontstyle"));
        controls.add(new NumberProperty("defaultfontsize.tooltip", "defaultfontsize", 1, 96, 1));
        controls.add(new NumberProperty("max_node_width.tooltip", "max_node_width", 1, Integer.MAX_VALUE, 1));
        controls.add(new NumberProperty("max_tooltip_width.tooltip", "max_tooltip_width", 1, Integer.MAX_VALUE, 1));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("other_defaults"));
        controls.add(new ComboProperty("standardedgestyle.tooltip", "standardedgestyle", new String[]{"bezier", "linear"}, this));
        controls.add(new NewTabProperty("Appearance"));
        controls.add(new SeparatorProperty("look_and_feel"));
        UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
        int reservedCount = 6;
        String[] lafNames = new String[lafInfo.length + reservedCount];
        Vector<String> translatedLafNames = new Vector<String>();
        lafNames[0] = "default";
        translatedLafNames.add(this.getText("default"));
        lafNames[1] = "metal";
        translatedLafNames.add(this.getText("metal"));
        lafNames[2] = "windows";
        translatedLafNames.add(this.getText("windows"));
        lafNames[3] = "motif";
        translatedLafNames.add(this.getText("motif"));
        lafNames[4] = "gtk";
        translatedLafNames.add(this.getText("gtk"));
        lafNames[5] = "nothing";
        translatedLafNames.add(this.getText("nothing"));
        for (int i = 0; i < lafInfo.length; ++i) {
            String className;
            UIManager.LookAndFeelInfo info = lafInfo[i];
            lafNames[i + reservedCount] = className = info.getClassName();
            translatedLafNames.add(info.getName());
        }
        controls.add(new ComboProperty("lookandfeel.tooltip", "lookandfeel", lafNames, translatedLafNames));
        controls.add(new BooleanProperty("use_tabbed_pane.tooltip", "use_tabbed_pane"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("selection_colors"));
        controls.add(new BooleanProperty("standarddrawrectangleforselection.tooltip", "standarddrawrectangleforselection"));
        controls.add(new ColorProperty("standardselectednoderectanglecolor.tooltip", "standardselectednoderectanglecolor", fmMain.getDefaultProperty("standardselectednoderectanglecolor"), this));
        controls.add(new ColorProperty("standardselectednodecolor.tooltip", "standardselectednodecolor", fmMain.getDefaultProperty("standardselectednodecolor"), this));
        controls.add(new NextLineProperty());
        String RESOURCE_ROOT_NODE = "root_node_appearance";
        String RESOURCE_USE_COMMON_OUT_POINT_FOR_ROOT_NODE = "use_common_out_point_for_root_node";
        controls.add(new SeparatorProperty("root_node_appearance"));
        controls.add(new BooleanProperty("use_common_out_point_for_root_node.tooltip", "use_common_out_point_for_root_node"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("anti_alias"));
        controls.add(new ComboProperty("antialias.tooltip", "antialias", new String[]{"antialias_edges", "antialias_all", "antialias_none"}, this));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("initial_map_size"));
        controls.add(new StringProperty("mapxsize.tooltip", "mapxsize"));
        controls.add(new StringProperty(null, "mapysize"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("hyperlink_types"));
        controls.add(new ComboProperty("links.tooltip", "links", new String[]{"relative", "absolute"}, this));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("edit_long_node_window"));
        controls.add(new StringProperty("el__buttons_position.tooltip", "el__buttons_position"));
        controls.add(new BooleanProperty(null, "el__position_window_below_node"));
        controls.add(new StringProperty(null, "el__min_default_window_height"));
        controls.add(new StringProperty(null, "el__max_default_window_height"));
        controls.add(new StringProperty(null, "el__min_default_window_width"));
        controls.add(new StringProperty(null, "el__max_default_window_width"));
        controls.add(new BooleanProperty(null, "el__enter_confirms_by_default"));
        controls.add(new BooleanProperty(null, "el__show_icon_for_attributes"));
        controls.add(new SeparatorProperty("icon_properties"));
        controls.add(new BooleanProperty(null, "resources_don_t_show_note_icons"));
        controls.add(new StringProperty("icon_order_description", "icons.list"));
        String form = "right:max(40dlu;p), 4dlu, 80dlu, 7dlu";
        controls.add(new NewTabProperty("Keystrokes", form + "," + form));
        controls.add(new SeparatorProperty("commands_for_the_program"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_newMap"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_open"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_save"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_saveAs"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_print"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_close"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_quit"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_option_dialog"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_export_to_html"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_export_branch_to_html"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_open_first_in_history"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_previousMap"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_nextMap"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_mode_MindMap"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_mode_Browse"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_mode_File"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_toggle_italic"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_toggle_boldface"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_toggle_underlined"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_toggle_cloud"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_undo"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_redo"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_delete_child"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_select_all"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_select_branch"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_zoom_out"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_zoom_in"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("node_editing_commands"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_cut"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_copy"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_copy_single"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_paste"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_remove"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_add_arrow_link_action"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_add_local_link_action"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("node_navigation_commands"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_moveToRoot"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_move_up"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_move_down"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_move_left"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_move_right"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_follow_link"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("new_node_commands"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_add"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_add_child"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_add_child_mac"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_add_sibling_before"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("node_editing_commands"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_edit"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_edit_long_node"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_join_nodes"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_toggle_folded"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_toggle_children_folded"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_set_link_by_filechooser"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_set_link_by_textfield"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_set_image_by_filechooser"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_up"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_down"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_increase_font_size"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_decrease_font_size"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_export_branch"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_color"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_node_color_blend"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_edge_color"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_find"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_find_next"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("patterns"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_accessories/plugins/ManagePatterns_manage_patterns_dialog"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_1"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_2"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_3"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_4"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_5"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_6"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_7"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_8"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_9"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_10"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_11"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_12"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_13"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_14"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_15"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_16"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_17"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_apply_pattern_18"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("others"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_accessories/plugins/ChangeNodeLevelAction_left.properties_key"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_accessories/plugins/ChangeNodeLevelAction_right.properties_key"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_accessories/plugins/FormatCopy.properties.properties_key"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_accessories/plugins/FormatPaste.properties.properties_key"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_accessories/plugins/IconSelectionPlugin.properties.properties_key"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_accessories/plugins/NewParentNode.properties_key"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_accessories/plugins/NodeNote_jumpto.keystroke.alt_N"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_accessories/plugins/NodeNote_hide_show.keystroke.control_shift_less"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_accessories/plugins/RemoveNote.properties.properties_key"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_accessories/plugins/UnfoldAll.keystroke.alt_PAGE_UP"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_accessories/plugins/UnfoldAll.keystroke.alt_PAGE_DOWN"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_accessories/plugins/UnfoldAll.keystroke.alt_HOME"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_accessories/plugins/UnfoldAll.keystroke.alt_END"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("attributes"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_edit_attributes"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_show_all_attributes"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_show_selected_attributes"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_hide_all_attributes"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_show_attribute_manager"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_assign_attributes"));
        controls.add(new KeyProperty(this.frame, null, "keystroke_plugins/ScriptingEngine.keystroke.evaluate"));
        ModeController modeController = fmMain.getController().getModeController();
        if (modeController instanceof MindMapController) {
            MindMapController controller = (MindMapController)modeController;
            Vector iconActions = controller.iconActions;
            Vector<NodeGeneralAction> actions = new Vector<NodeGeneralAction>();
            actions.addAll(iconActions);
            actions.add(controller.removeLastIconAction);
            actions.add(controller.removeAllIconsAction);
            controls.add(new NextLineProperty());
            controls.add(new SeparatorProperty("icons"));
            Iterator iterator = actions.iterator();
            while (iterator.hasNext()) {
                IconInformation info = (IconInformation)iterator.next();
                KeyProperty keyProperty = new KeyProperty(this.frame, null, info.getKeystrokeResourceName());
                keyProperty.setLabelText(info.getDescription());
                keyProperty.setImageIcon(info.getIcon());
                keyProperty.disableModifiers();
                controls.add(keyProperty);
            }
        }
        controls.add(new NewTabProperty("Behaviour"));
        controls.add(new SeparatorProperty("behaviour"));
        controls.add(new ComboProperty("placenewbranches.tooltip", "placenewbranches", new String[]{"first", "last"}, this));
        controls.add(new BooleanProperty("draganddrop.tooltip", "draganddrop"));
        controls.add(new BooleanProperty("unfold_on_paste.tooltip", "unfold_on_paste"));
        controls.add(new BooleanProperty("disable_cursor_move_paper.tooltip", "disable_cursor_move_paper"));
        controls.add(new BooleanProperty("enable_leaves_folding.tooltip", "enable_leaves_folding"));
        controls.add(new StringProperty("foldingsymbolwidth.tooltip", "foldingsymbolwidth"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("key_typing"));
        controls.add(new BooleanProperty("disable_key_type.tooltip", "disable_key_type"));
        controls.add(new BooleanProperty("key_type_adds_new.tooltip", "key_type_adds_new"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("resources_notifications"));
        controls.add(new RemindValueProperty("remind_type_of_new_nodes.tooltip", "remind_use_rich_text_in_new_long_nodes", modeController));
        controls.add(new DontShowNotificationProperty("resources_convert_to_current_version.tooltip", "resources_convert_to_current_version"));
        controls.add(new DontShowNotificationProperty("delete_nodes_without_question.tooltip", "delete_nodes_without_question"));
        controls.add(new DontShowNotificationProperty("cut_nodes_without_question.tooltip", "resources_cut_nodes_without_question"));
        controls.add(new DontShowNotificationProperty("remove_notes_without_question.tooltip", "resources_remove_notes_without_question"));
        controls.add(new DontShowNotificationProperty("execute_scripts_without_asking.tooltip", "resources_execute_scripts_without_asking"));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("selection_method"));
        controls.add(new ComboProperty("selection_method.tooltip", "selection_method", new String[]{"selection_method_direct", "selection_method_delayed", "selection_method_by_click"}, this));
        controls.add(new NumberProperty("time_for_delayed_selection.tooltip", "time_for_delayed_selection", 1, Integer.MAX_VALUE, 1));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("mouse_wheel"));
        controls.add(new NumberProperty("wheel_velocity.tooltip", "wheel_velocity", 1, 250, 1));
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("undo"));
        controls.add(new NumberProperty("undo_levels.tooltip", "undo_levels", 2, 1000, 1));
        controls.add(new NewTabProperty("HTML"));
        controls.add(new SeparatorProperty("browser"));
        controls.add(new StringProperty("default_browser_command_windows_nt.tooltip", "default_browser_command_windows_nt"));
        controls.add(new StringProperty("default_browser_command_windows_9x.tooltip", "default_browser_command_windows_9x"));
        controls.add(new StringProperty("default_browser_command_other_os.tooltip", "default_browser_command_other_os"));
        controls.add(new StringProperty("default_browser_command_mac.tooltip", "default_browser_command_mac"));
        controls.add(new SeparatorProperty("html_export"));
        controls.add(new ComboProperty(null, "html_export_folding", new String[]{"html_export_no_folding", "html_export_fold_currently_folded", "html_export_fold_all", "html_export_based_on_headings"}, this));
        controls.add(new NextLineProperty());
        controls.add(new BooleanProperty("export_icons_in_html.tooltip", "export_icons_in_html"));
        Iterator iter = sContributors.iterator();
        while (iter.hasNext()) {
            FreemindPropertyContributor contributor = (FreemindPropertyContributor)iter.next();
            controls.addAll(contributor.getControls(this));
        }
        return controls;
    }

    public void closeWindow() {
        OptionPanelWindowConfigurationStorage storage = new OptionPanelWindowConfigurationStorage();
        storage.setPanel(this.selectedPanel);
        XmlBindingTools.getInstance().storeDialogPositions(fmMain.getController(), this.frame, (WindowConfigurationStorage)storage, PREFERENCE_STORAGE_PROPERTY);
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    public static void addContributor(FreemindPropertyContributor contributor) {
        sContributors.add(contributor);
    }

    public static void removeContributor(FreemindPropertyContributor contributor) {
        sContributors.remove(contributor);
    }

    static {
        changeListeners = new Vector();
        lastKey = "";
        sContributors = new HashSet();
    }

    private static class KeyProperty
    extends PropertyBean
    implements PropertyControl {
        private int modifierMask = 0;
        String description;
        String label;
        JButton mButton = new JButton();
        private String labelText;
        private ImageIcon icon;
        private static RowSpec rowSpec;

        public KeyProperty(final JDialog frame, String description, String label) {
            this.description = description;
            this.label = label;
            this.mButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    Vector allKeybindings = new Vector();
                    GrabKeyDialog dialog = new GrabKeyDialog(fmMain, frame, new GrabKeyDialog.KeyBinding(KeyProperty.this.getLabel(), KeyProperty.this.getLabel(), KeyProperty.this.getValue(), false), allKeybindings, null, KeyProperty.this.modifierMask);
                    if (dialog.isOK()) {
                        KeyProperty.this.setValue(dialog.getShortcut());
                        KeyProperty.this.firePropertyChangeEvent();
                    }
                }
            });
        }

        public void disableModifiers() {
            this.modifierMask = 10;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLabel() {
            return this.label;
        }

        public void setValue(String value) {
            this.mButton.setText(value);
            this.mButton.setToolTipText(this.mButton.getText());
        }

        public String getValue() {
            return this.mButton.getText();
        }

        public void layout(DefaultFormBuilder builder, TextTranslator pTranslator) {
            if (this.labelText == null) {
                this.labelText = pTranslator.getText(this.getLabel());
            }
            JLabel label = new JLabel(this.labelText, this.icon, 4);
            label.setToolTipText(pTranslator.getText(this.getDescription()));
            if (rowSpec == null) {
                rowSpec = new RowSpec("fill:20dlu");
            }
            if (3 < builder.getColumn()) {
                builder.appendRelatedComponentsGapRow();
                builder.appendRow(rowSpec);
                builder.nextLine(2);
            } else {
                builder.nextColumn(2);
            }
            builder.add(label);
            builder.nextColumn(2);
            builder.add(this.mButton);
        }

        public void setEnabled(boolean pEnabled) {
            this.mButton.setEnabled(pEnabled);
        }

        public void setLabelText(String labelText) {
            this.labelText = labelText;
        }

        public void setImageIcon(ImageIcon icon) {
            this.icon = icon;
        }
    }

    public static class NewTabProperty
    implements PropertyControl {
        private String label;
        private String layoutFormat;

        public NewTabProperty(String label) {
            this(label, OptionPanel.DEFAULT_LAYOUT_FORMAT);
        }

        public NewTabProperty(String label, String layoutFormat) {
            this.label = label;
            this.layoutFormat = layoutFormat;
        }

        public String getDescription() {
            return this.layoutFormat;
        }

        public String getLabel() {
            return this.label;
        }

        public void layout(DefaultFormBuilder builder, TextTranslator pTranslator) {
        }

        public void setEnabled(boolean pEnabled) {
        }
    }

    private final class ChangeTabAction
    implements ActionListener {
        private CardLayout cardLayout;
        private JPanel centralPanel;
        private String tabName;

        private ChangeTabAction(CardLayout cardLayout, JPanel centralPanel, String tabName) {
            this.cardLayout = cardLayout;
            this.centralPanel = centralPanel;
            this.tabName = tabName;
        }

        public void actionPerformed(ActionEvent arg0) {
            this.cardLayout.show(this.centralPanel, this.tabName);
            Collection c = OptionPanel.this.getAllButtons();
            Iterator i = c.iterator();
            while (i.hasNext()) {
                JButton button = (JButton)i.next();
                button.setForeground(null);
            }
            OptionPanel.this.getTabButton(this.tabName).setForeground(MARKED_BUTTON_COLOR);
            OptionPanel.this.selectedPanel = this.tabName;
        }
    }

    public static interface OptionPanelFeedback {
        public void writeProperties(Properties var1);
    }
}

