/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.MoveNodesAction;
import freemind.controller.actions.generated.instance.NodeListMember;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.modes.MapAdapter;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;

public class NodeUpAction
extends AbstractAction
implements ActorXml {
    private final MindMapController modeController;
    private static Logger logger;

    public NodeUpAction(MindMapController modeController) {
        super(modeController.getText("node_up"));
        this.modeController = modeController;
        modeController.getActionFactory().registerActor(this, this.getDoActionClass());
        if (logger == null) {
            logger = modeController.getFrame().getLogger(this.getClass().getName());
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.moveNodes(this.modeController.getSelected(), this.modeController.getSelecteds(), -1);
    }

    public void moveNodes(MindMapNode selected, List selecteds, int direction) {
        MoveNodesAction doAction = this.createMoveNodesAction(selected, selecteds, direction);
        MoveNodesAction undoAction = this.createMoveNodesAction(selected, selecteds, -direction);
        this.modeController.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.modeController.getActionFactory().executeAction(new ActionPair((XmlAction)doAction, (XmlAction)undoAction));
        this.modeController.getActionFactory().endTransaction((String)this.getValue("Name"));
    }

    public void _moveNodes(MindMapNode selected, List selecteds, int direction) {
        Comparator comparator;
        Comparator comparator2 = comparator = direction == -1 ? null : new Comparator(){

            public int compare(Object o1, Object o2) {
                int i1 = (Integer)o1;
                int i2 = (Integer)o2;
                return i2 - i1;
            }
        };
        if (!selected.isRoot()) {
            MindMapNode parent = selected.getParentNode();
            Vector sortedChildren = this.getSortedSiblings(parent);
            TreeSet<Integer> range = new TreeSet<Integer>(comparator);
            Iterator i = selecteds.iterator();
            while (i.hasNext()) {
                MindMapNode node = (MindMapNode)i.next();
                if (node.getParent() != parent) {
                    logger.warning("Not all selected nodes have the same parent.");
                    return;
                }
                range.add(new Integer(sortedChildren.indexOf(node)));
            }
            Integer last = (Integer)range.iterator().next();
            Iterator i2 = range.iterator();
            while (i2.hasNext()) {
                Integer newInt = (Integer)i2.next();
                if (Math.abs(newInt - last) > 1) {
                    logger.warning("Not adjacent nodes. Skipped. ");
                    return;
                }
                last = newInt;
            }
            i2 = range.iterator();
            while (i2.hasNext()) {
                Integer position = (Integer)i2.next();
                MindMapNode node = (MindMapNode)sortedChildren.get(position);
                this.moveNodeTo(node, parent, direction);
            }
            MapView mapView = this.modeController.getView();
            NodeView selectedNodeView = mapView.getNodeView(selected);
            mapView.selectAsTheOnlyOneSelected(selectedNodeView);
            mapView.scrollNodeToVisible(selectedNodeView);
            Iterator i3 = range.iterator();
            while (i3.hasNext()) {
                Integer position = (Integer)i3.next();
                MindMapNode node = (MindMapNode)sortedChildren.get(position);
                NodeView nodeView = mapView.getNodeView(node);
                mapView.makeTheSelected(nodeView);
            }
            this.modeController.getController().obtainFocusForSelected();
        }
    }

    public int moveNodeTo(MindMapNode newChild, MindMapNode parent, int direction) {
        int index;
        MapAdapter model = this.modeController.getModel();
        int newIndex = index = model.getIndexOfChild(parent, newChild);
        int maxIndex = parent.getChildCount();
        Vector sortedNodesIndices = this.getSortedSiblings(parent);
        int newPositionInVector = sortedNodesIndices.indexOf(newChild) + direction;
        if (newPositionInVector < 0) {
            newPositionInVector = maxIndex - 1;
        }
        if (newPositionInVector >= maxIndex) {
            newPositionInVector = 0;
        }
        MindMapNode destinationNode = (MindMapNode)sortedNodesIndices.get(newPositionInVector);
        newIndex = model.getIndexOfChild(parent, destinationNode);
        model.removeNodeFromParent(newChild);
        model.insertNodeInto(newChild, parent, newIndex);
        this.modeController.nodeChanged(newChild);
        return newIndex;
    }

    private Vector getSortedSiblings(MindMapNode node) {
        Vector nodes = new Vector();
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            nodes.add(i.next());
        }
        Collections.sort(nodes, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof MindMapNode) {
                    MindMapNode n1 = (MindMapNode)o1;
                    if (o2 instanceof MindMapNode) {
                        MindMapNode n2 = (MindMapNode)o2;
                        int b1 = n1.isLeft() ? 0 : 1;
                        int b2 = n2.isLeft() ? 0 : 1;
                        return b1 - b2;
                    }
                }
                throw new IllegalArgumentException("Elements in LeftRightComparator are not comparable.");
            }
        });
        return nodes;
    }

    public void act(XmlAction action) {
        if (action instanceof MoveNodesAction) {
            MoveNodesAction moveAction = (MoveNodesAction)action;
            NodeAdapter selected = this.modeController.getNodeFromID(moveAction.getNode());
            Vector<NodeAdapter> selecteds = new Vector<NodeAdapter>();
            Iterator i = moveAction.getListNodeListMemberList().iterator();
            while (i.hasNext()) {
                NodeListMember node = (NodeListMember)i.next();
                selecteds.add(this.modeController.getNodeFromID(node.getNode()));
            }
            this._moveNodes(selected, selecteds, moveAction.getDirection());
        }
    }

    public Class getDoActionClass() {
        return MoveNodesAction.class;
    }

    private MoveNodesAction createMoveNodesAction(MindMapNode selected, List selecteds, int direction) {
        MoveNodesAction moveAction = new MoveNodesAction();
        moveAction.setDirection(direction);
        moveAction.setNode(selected.getObjectId(this.modeController));
        Iterator i = selecteds.iterator();
        while (i.hasNext()) {
            MindMapNode node = (MindMapNode)i.next();
            NodeListMember nodeListMember = new NodeListMember();
            nodeListMember.setNode(node.getObjectId(this.modeController));
            moveAction.addNodeListMember(nodeListMember);
        }
        return moveAction;
    }
}

