/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.common;

import freemind.main.Tools;
import freemind.modes.ControllerAdapter;
import freemind.modes.MindMapNode;
import java.awt.event.ActionEvent;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.swing.AbstractAction;

public class CommonToggleFoldedAction
extends AbstractAction {
    private ControllerAdapter modeController;
    private Logger logger;

    public CommonToggleFoldedAction(ControllerAdapter controller) {
        super(controller.getText("toggle_folded"));
        this.modeController = controller;
        this.logger = this.modeController.getFrame().getLogger(this.getClass().getName());
    }

    public void actionPerformed(ActionEvent e) {
        this.toggleFolded();
    }

    public void toggleFolded() {
        this.toggleFolded(this.modeController.getSelecteds().listIterator());
    }

    public void toggleFolded(ListIterator listIterator) {
        boolean fold = CommonToggleFoldedAction.getFoldingState(CommonToggleFoldedAction.reset(listIterator));
        ListIterator i = CommonToggleFoldedAction.reset(listIterator);
        while (i.hasNext()) {
            MindMapNode node = (MindMapNode)i.next();
            this.modeController.setFolded(node, fold);
        }
    }

    public static ListIterator reset(ListIterator iterator) {
        while (iterator.hasPrevious()) {
            iterator.previous();
        }
        return iterator;
    }

    public static boolean getFoldingState(ListIterator iterator) {
        Tools.BooleanHolder state = null;
        boolean allNodeHaveSameFoldedStatus = true;
        ListIterator it = iterator;
        while (it.hasNext()) {
            MindMapNode node = (MindMapNode)it.next();
            if (node.getChildCount() == 0) continue;
            if (state == null) {
                state = new Tools.BooleanHolder();
                state.setValue(node.isFolded());
                continue;
            }
            if (node.isFolded() == state.getValue()) continue;
            allNodeHaveSameFoldedStatus = false;
            break;
        }
        boolean fold = true;
        if (allNodeHaveSameFoldedStatus && state != null) {
            fold = !state.getValue();
        }
        return fold;
    }
}

