/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins.time;

import accessories.plugins.time.FlatNodeTableFilterModel;
import accessories.plugins.time.TableSorter;
import accessories.plugins.time.TimeManagementOrganizer;
import com.jgoodies.forms.factories.ButtonBarFactory;
import freemind.controller.BlindIcon;
import freemind.controller.actions.generated.instance.TimeWindowColumnSetting;
import freemind.controller.actions.generated.instance.TimeWindowConfigurationStorage;
import freemind.controller.actions.generated.instance.WindowConfigurationStorage;
import freemind.main.HtmlTools;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindIcon;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.common.plugins.ReminderHookBase;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.hooks.MindMapHookAdapter;
import freemind.view.mindmapview.MultipleImage;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class TimeList
extends MindMapHookAdapter {
    private static final int TYPE_DELAY_TIME = 500;
    private static String COLUMN_MODIFIED = "Modified";
    private static String COLUMN_CREATED = "Created";
    private static String COLUMN_ICONS = "Icons";
    private static String COLUMN_TEXT = "Text";
    private static String COLUMN_DATE = "Date";
    private static String COLUMN_NOTES = "Notes";
    private static final int DATE_COLUMN = 0;
    public static final int NODE_TEXT_COLUMN = 1;
    protected static final int NODE_ICON_COLUMN = 2;
    protected static final int NODE_CREATED_COLUMN = 3;
    protected static final int NODE_MODIFIED_COLUMN = 4;
    protected static final int NODE_NOTES_COLUMN = 5;
    private JDialog dialog;
    private JPanel timePanel;
    private JTable timeTable;
    private DefaultTableModel timeTableModel;
    private TableSorter sorter;
    private DateRenderer dateRenderer;
    private NodeRenderer nodeRenderer;
    private IconsRenderer iconsRenderer;
    private boolean showAllNodes = false;
    private static final String WINDOW_PREFERENCE_STORAGE_PROPERTY = TimeList.class.getName() + "_properties";
    private FlatNodeTableFilterModel mFlatNodeTableFilterModel;
    private JTextField mFilterTextSearchField;
    private JTextField mFilterTextReplaceField;
    private NotesRenderer notesRenderer;
    private JLabel mTreeLabel;
    static /* synthetic */ Class class$accessories$plugins$time$TimeList$NodeHolder;
    static /* synthetic */ Class class$accessories$plugins$time$TimeList$NotesHolder;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$awt$event$KeyListener;

    public void startupMapHook() {
        super.startupMapHook();
        COLUMN_MODIFIED = this.getResourceString("plugins/TimeList.xml_Modified");
        COLUMN_CREATED = this.getResourceString("plugins/TimeList.xml_Created");
        COLUMN_ICONS = this.getResourceString("plugins/TimeList.xml_Icons");
        COLUMN_TEXT = this.getResourceString("plugins/TimeList.xml_Text");
        COLUMN_DATE = this.getResourceString("plugins/TimeList.xml_Date");
        COLUMN_NOTES = this.getResourceString("plugins/TimeList.xml_Notes");
        this.showAllNodes = Tools.xmlToBoolean(this.getResourceString("show_all_nodes"));
        this.dialog = new JDialog((Frame)this.getController().getFrame().getJFrame(), true);
        String windowTitle = this.showAllNodes ? "plugins/TimeManagement.xml_WindowTitle_All_Nodes" : "plugins/TimeManagement.xml_WindowTitle";
        this.dialog.setTitle(this.getResourceString(windowTitle));
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                TimeList.this.disposeDialog();
            }
        });
        Tools.addEscapeActionToDialog(this.dialog, new AbstractAction(){

            public void actionPerformed(ActionEvent arg0) {
                TimeList.this.disposeDialog();
            }
        });
        Container contentPane = this.dialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        gbl.columnWeights = new double[]{1.0};
        gbl.rowWeights = new double[]{1.0};
        contentPane.setLayout(gbl);
        contentPane.add((Component)new JLabel(this.getResourceString("plugins/TimeManagement.xml_Find")), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mFilterTextSearchField = new JTextField();
        this.mFilterTextSearchField.getDocument().addDocumentListener(new FilterTextDocumentListener());
        this.mFilterTextSearchField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent pEvent) {
                if (pEvent.getKeyCode() == 40) {
                    TimeList.this.logger.info("Set Focus to replace fields");
                    TimeList.this.mFilterTextReplaceField.requestFocusInWindow();
                }
            }
        });
        contentPane.add((Component)this.mFilterTextSearchField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        contentPane.add((Component)new JLabel(this.getResourceString("plugins/TimeManagement.xml_Replace")), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mFilterTextReplaceField = new JTextField();
        contentPane.add((Component)this.mFilterTextReplaceField, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mFilterTextReplaceField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent pEvent) {
                if (pEvent.getKeyCode() == 40) {
                    TimeList.this.logger.info("Set Focus to table");
                    TimeList.this.timeTable.requestFocusInWindow();
                } else if (pEvent.getKeyCode() == 38) {
                    TimeList.this.logger.info("Set Focus to table");
                    TimeList.this.mFilterTextSearchField.requestFocusInWindow();
                }
            }
        });
        this.dateRenderer = new DateRenderer();
        this.nodeRenderer = new NodeRenderer();
        this.notesRenderer = new NotesRenderer();
        this.iconsRenderer = new IconsRenderer(this.getController());
        this.timeTable = new FlatNodeTable();
        this.timeTable.addKeyListener(new FlatNodeTableKeyListener());
        this.timeTable.addMouseListener(new FlatNodeTableMouseAdapter());
        this.timeTable.getTableHeader().setReorderingAllowed(false);
        this.timeTableModel = this.updateModel();
        this.mFlatNodeTableFilterModel = new FlatNodeTableFilterModel(this.timeTableModel, 1);
        this.sorter = new TableSorter(this.mFlatNodeTableFilterModel);
        this.timeTable.setModel(this.sorter);
        this.sorter.setTableHeader(this.timeTable.getTableHeader());
        this.sorter.setColumnComparator(Date.class, TableSorter.COMPARABLE_COMAPRATOR);
        this.sorter.setColumnComparator(MindMapNode.class, TableSorter.LEXICAL_COMPARATOR);
        this.sorter.setColumnComparator(IconsHolder.class, TableSorter.COMPARABLE_COMAPRATOR);
        this.sorter.setSortingStatus(0, 1);
        JScrollPane pane = new JScrollPane(this.timeTable);
        contentPane.add((Component)pane, new GridBagConstraints(0, 4, 1, 1, 1.0, 10.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mTreeLabel = new JLabel();
        contentPane.add((Component)new JScrollPane(this.mTreeLabel), new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        final AbstractAction selectAction = new AbstractAction(this.getResourceString("plugins/TimeManagement.xml_Select")){

            public void actionPerformed(ActionEvent arg0) {
                TimeList.this.selectSelectedRows();
            }
        };
        JButton selectButton = new JButton(selectAction);
        final AbstractAction exportAction = new AbstractAction(this.getResourceString("plugins/TimeManagement.xml_Export")){

            public void actionPerformed(ActionEvent arg0) {
                TimeList.this.exportSelectedRowsAndClose();
            }
        };
        JButton exportButton = new JButton(exportAction);
        AbstractAction replaceAllAction = new AbstractAction(this.getResourceString("plugins/TimeManagement.xml_Replace_All")){

            public void actionPerformed(ActionEvent arg0) {
                TimeList.this.replace(new ReplaceAllInfo());
            }
        };
        JButton replaceAllButton = new JButton(replaceAllAction);
        final AbstractAction replaceSelectedAction = new AbstractAction(this.getResourceString("plugins/TimeManagement.xml_Replace_Selected")){

            public void actionPerformed(ActionEvent arg0) {
                TimeList.this.replace(new ReplaceSelectedInfo());
            }
        };
        JButton replaceSelectedButton = new JButton(replaceSelectedAction);
        final AbstractAction gotoAction = new AbstractAction(this.getResourceString("plugins/TimeManagement.xml_Goto")){

            public void actionPerformed(ActionEvent arg0) {
                TimeList.this.selectSelectedRows();
                TimeList.this.disposeDialog();
            }
        };
        JButton gotoButton = new JButton(gotoAction);
        AbstractAction disposeAction = new AbstractAction(this.getResourceString("plugins/TimeManagement.xml_Cancel")){

            public void actionPerformed(ActionEvent arg0) {
                TimeList.this.disposeDialog();
            }
        };
        JButton cancelButton = new JButton(disposeAction);
        selectAction.setEnabled(false);
        gotoAction.setEnabled(false);
        exportAction.setEnabled(false);
        replaceSelectedAction.setEnabled(false);
        JPanel bar = ButtonBarFactory.buildGrowingBar(new JButton[]{cancelButton, exportButton, replaceAllButton, replaceSelectedButton, gotoButton, selectButton});
        contentPane.add((Component)bar, new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu(this.getResourceString("plugins/TimeManagement.xml_menu_actions"));
        AbstractAction[] actionList = new AbstractAction[]{selectAction, gotoAction, replaceSelectedAction, replaceAllAction, exportAction, disposeAction};
        for (int i = 0; i < actionList.length; ++i) {
            AbstractAction action = actionList[i];
            JMenuItem item = menu.add(action);
            item.setIcon(new BlindIcon(16));
        }
        menuBar.add(menu);
        this.dialog.setJMenuBar(menuBar);
        ListSelectionModel rowSM = this.timeTable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                boolean enable = !lsm.isSelectionEmpty();
                replaceSelectedAction.setEnabled(enable);
                selectAction.setEnabled(enable);
                gotoAction.setEnabled(enable);
                exportAction.setEnabled(enable);
            }
        });
        rowSM.addListSelectionListener(new ListSelectionListener(){

            String getNodeText(MindMapNode node) {
                return node.getShortText(TimeList.this.getController()) + (node.isRoot() ? "" : " <- " + this.getNodeText(node.getParentNode()));
            }

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    TimeList.this.mTreeLabel.setText("");
                    return;
                }
                int selectedRow = lsm.getLeadSelectionIndex();
                MindMapNode mindMapNode = TimeList.this.getMindMapNode(selectedRow);
                TimeList.this.mTreeLabel.setText(this.getNodeText(mindMapNode));
            }
        });
        WindowConfigurationStorage storage = this.getMindMapController().decorateDialog(this.dialog, WINDOW_PREFERENCE_STORAGE_PROPERTY);
        if (storage != null) {
            this.timeTable.setAutoResizeMode(0);
            int column = 0;
            Iterator i = ((TimeWindowConfigurationStorage)storage).getListTimeWindowColumnSettingList().iterator();
            while (i.hasNext()) {
                TimeWindowColumnSetting setting = (TimeWindowColumnSetting)i.next();
                this.timeTable.getColumnModel().getColumn(column).setPreferredWidth(setting.getColumnWidth());
                this.sorter.setSortingStatus(column, setting.getColumnSorting());
                ++column;
            }
        }
        this.dialog.setVisible(true);
    }

    protected void exportSelectedRowsAndClose() {
        int[] selectedRows = this.timeTable.getSelectedRows();
        Vector<MindMapNode> selectedNodes = new Vector<MindMapNode>();
        for (int i = 0; i < selectedRows.length; ++i) {
            int row = selectedRows[i];
            selectedNodes.add(this.getMindMapNode(row));
        }
        MindMap newMap = this.getMindMapController().newMap();
        MindMapController newMindMapController = (MindMapController)newMap.getModeController();
        Iterator iter = selectedNodes.iterator();
        while (iter.hasNext()) {
            MindMapNode node = (MindMapNode)iter.next();
            MindMapNode copy = node.shallowCopy();
            if (copy == null) continue;
            newMindMapController.insertNodeInto(copy, newMap.getRootNode());
        }
        this.disposeDialog();
    }

    private void replace(IReplaceInputInformation info) {
        try {
            String searchString = this.getText(this.mFilterTextSearchField.getDocument());
            String replaceString = this.getText(this.mFilterTextReplaceField.getDocument());
            TimeList.replace(info, searchString, replaceString);
            this.timeTableModel.fireTableDataChanged();
            this.mFlatNodeTableFilterModel.resetFilter();
            this.mFilterTextSearchField.setText("");
        }
        catch (BadLocationException e) {
            Resources.getInstance().logException(e);
        }
    }

    public static void replace(IReplaceInputInformation info, String searchString, String replaceString) {
        String regExp = "(" + TimeList.getPureRegularExpression(searchString) + ")";
        Pattern p = Pattern.compile(regExp, 2);
        String replacement = replaceString;
        int length = info.getLength();
        for (int i = 0; i < length; ++i) {
            String replaceResult;
            NodeHolder nodeHolder = info.getNodeHolderAt(i);
            String text = nodeHolder.node.getText();
            if (Tools.safeEquals(text, replaceResult = HtmlTools.getInstance().getReplaceResult(p, replacement, text))) continue;
            info.changeString(nodeHolder, replaceResult);
        }
    }

    private void selectSelectedRows() {
        this.selectNodes(this.timeTable.getSelectedRow(), this.timeTable.getSelectedRows());
    }

    private void gotoNodesAndClose(int focussedRow, int[] selectedRows) {
        this.selectNodes(focussedRow, selectedRows);
        this.disposeDialog();
    }

    private void selectNodes(int focussedRow, int[] selectedRows) {
        if (focussedRow >= 0) {
            MindMapNode focussedNode = this.getMindMapNode(focussedRow);
            Vector<MindMapNode> selectedNodes = new Vector<MindMapNode>();
            for (int i = 0; i < selectedRows.length; ++i) {
                int row = selectedRows[i];
                selectedNodes.add(this.getMindMapNode(row));
            }
            this.getMindMapController().selectMultipleNodes(focussedNode, selectedNodes);
        }
    }

    private MindMapNode getMindMapNode(int focussedRow) {
        MindMapNode selectedNode = ((NodeHolder)this.timeTable.getModel().getValueAt(focussedRow, 1)).node;
        return selectedNode;
    }

    private DefaultTableModel updateModel() {
        MindMapNode node = this.getController().getMap().getRootNode();
        DefaultTableModel model = new DefaultTableModel(){

            public Class getColumnClass(int arg0) {
                switch (arg0) {
                    case 0: 
                    case 3: 
                    case 4: {
                        return class$java$util$Date == null ? (class$java$util$Date = TimeList.class$("java.util.Date")) : class$java$util$Date;
                    }
                    case 1: {
                        return class$accessories$plugins$time$TimeList$NodeHolder == null ? (class$accessories$plugins$time$TimeList$NodeHolder = TimeList.class$("accessories.plugins.time.TimeList$NodeHolder")) : class$accessories$plugins$time$TimeList$NodeHolder;
                    }
                    case 2: {
                        return class$accessories$plugins$time$TimeList$IconsHolder == null ? (class$accessories$plugins$time$TimeList$IconsHolder = TimeList.class$("accessories.plugins.time.TimeList$IconsHolder")) : class$accessories$plugins$time$TimeList$IconsHolder;
                    }
                    case 5: {
                        return class$accessories$plugins$time$TimeList$NotesHolder == null ? (class$accessories$plugins$time$TimeList$NotesHolder = TimeList.class$("accessories.plugins.time.TimeList$NotesHolder")) : class$accessories$plugins$time$TimeList$NotesHolder;
                    }
                }
                return class$java$lang$Object == null ? (class$java$lang$Object = TimeList.class$("java.lang.Object")) : class$java$lang$Object;
            }
        };
        model.addColumn(COLUMN_DATE);
        model.addColumn(COLUMN_TEXT);
        model.addColumn(COLUMN_ICONS);
        model.addColumn(COLUMN_CREATED);
        model.addColumn(COLUMN_MODIFIED);
        model.addColumn(COLUMN_NOTES);
        this.updateModel(model, node);
        return model;
    }

    private void updateModel(DefaultTableModel model, MindMapNode node) {
        ReminderHookBase hook = TimeManagementOrganizer.getHook(node);
        Date date = null;
        if (hook != null) {
            date = new Date(hook.getRemindUserAt());
        }
        if (this.showAllNodes || hook != null) {
            model.addRow(new Object[]{date, new NodeHolder(node), new IconsHolder(node), node.getHistoryInformation().getCreatedAt(), node.getHistoryInformation().getLastModifiedAt(), new NotesHolder(node)});
        }
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            MindMapNode child = (MindMapNode)i.next();
            this.updateModel(model, child);
        }
    }

    private JPanel getTimePanel() {
        if (this.timePanel == null) {
            this.timePanel = new JPanel();
            this.timePanel.setLayout(new GridBagLayout());
        }
        return this.timePanel;
    }

    private void disposeDialog() {
        TimeWindowConfigurationStorage storage = new TimeWindowConfigurationStorage();
        for (int i = 0; i < this.timeTable.getColumnCount(); ++i) {
            TimeWindowColumnSetting setting = new TimeWindowColumnSetting();
            setting.setColumnWidth(this.timeTable.getColumnModel().getColumn(i).getWidth());
            setting.setColumnSorting(this.sorter.getSortingStatus(i));
            storage.addTimeWindowColumnSetting(setting);
        }
        this.getMindMapController().storeDialogPositions(this.dialog, (WindowConfigurationStorage)storage, WINDOW_PREFERENCE_STORAGE_PROPERTY);
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public static String getRegularExpression(String text) throws BadLocationException {
        text = ".*(" + text + ").*";
        return text;
    }

    private String getText(Document document) throws BadLocationException {
        String text = document.getText(0, document.getLength());
        return text;
    }

    public static String getPureRegularExpression(String text) {
        text = text.replaceAll("([().\\[\\]^$|])", "\\\\$1");
        text = text.replaceAll("\\*", ".*");
        return text;
    }

    static class IconsRenderer
    extends DefaultTableCellRenderer {
        private final ModeController modeController;

        public IconsRenderer(ModeController controller) {
            this.modeController = controller;
        }

        public void setValue(Object value) {
            if (value instanceof IconsHolder) {
                IconsHolder iconsHolder = (IconsHolder)value;
                MultipleImage iconImages = new MultipleImage(1.0);
                Iterator i = iconsHolder.getIcons().iterator();
                while (i.hasNext()) {
                    MindIcon icon = (MindIcon)i.next();
                    iconImages.addImage(icon.getIcon());
                }
                if (iconImages.getImageCount() > 0) {
                    this.setIcon(iconImages);
                } else {
                    this.setIcon(null);
                }
            }
        }
    }

    static class IconsHolder
    implements Comparable {
        Vector icons = new Vector();
        private Vector iconNames;

        public IconsHolder(MindMapNode node) {
            this.icons.addAll(node.getIcons());
            this.iconNames = new Vector();
            Iterator i = this.icons.iterator();
            while (i.hasNext()) {
                MindIcon icon = (MindIcon)i.next();
                this.iconNames.add(icon.getName());
            }
            Collections.sort(this.iconNames);
        }

        public int compareTo(Object compareToObject) {
            return this.toString().compareTo(compareToObject.toString());
        }

        public Vector getIcons() {
            return this.icons;
        }

        public String toString() {
            String result = "";
            Iterator i = this.iconNames.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                result = result + name + " ";
            }
            return result;
        }
    }

    public static class NotesHolder
    implements Comparable {
        private final MindMapNode node;
        private String untaggedNotesText = null;
        private String originalNotesText = null;

        public NotesHolder(MindMapNode node) {
            this.node = node;
        }

        public int compareTo(Object compareToObject) {
            return this.toString().compareTo(compareToObject.toString());
        }

        public String toString() {
            return this.getUntaggedNotesText();
        }

        public String getUntaggedNotesText() {
            String notesText = this.node.getNoteText();
            if (notesText == null) {
                return "";
            }
            if (this.untaggedNotesText == null || this.originalNotesText != null && !this.originalNotesText.equals(notesText)) {
                this.originalNotesText = notesText;
                this.untaggedNotesText = HtmlTools.removeHtmlTagsFromString(notesText).replaceAll("\\s+", " ");
            }
            return this.untaggedNotesText;
        }
    }

    public static class NodeHolder
    implements Comparable {
        private final MindMapNode node;
        private String untaggedNodeText = null;
        private String originalNodeText = null;

        public NodeHolder(MindMapNode node) {
            this.node = node;
        }

        public int compareTo(Object compareToObject) {
            return this.toString().compareTo(compareToObject.toString());
        }

        public String toString() {
            return this.getUntaggedNodeText();
        }

        public String getUntaggedNodeText() {
            String nodeText = this.node.getText();
            if (this.untaggedNodeText == null || this.originalNodeText != null && !this.originalNodeText.equals(nodeText)) {
                this.originalNodeText = nodeText;
                this.untaggedNodeText = HtmlTools.removeHtmlTagsFromString(nodeText).replaceAll("\\s+", " ");
            }
            return this.untaggedNodeText;
        }
    }

    static class NotesRenderer
    extends DefaultTableCellRenderer {
        public void setValue(Object value) {
            this.setText(value == null ? "" : ((NotesHolder)value).getUntaggedNotesText());
        }
    }

    static class NodeRenderer
    extends DefaultTableCellRenderer {
        public void setValue(Object value) {
            this.setText(value == null ? "" : ((NodeHolder)value).getUntaggedNodeText());
        }
    }

    static class DateRenderer
    extends DefaultTableCellRenderer {
        DateFormat formatter;

        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateTimeInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    private final class FlatNodeTable
    extends JTable {
        private FlatNodeTable() {
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            Object object = this.getModel().getValueAt(row, column);
            if (object instanceof Date) {
                return TimeList.this.dateRenderer;
            }
            if (object instanceof NodeHolder) {
                return TimeList.this.nodeRenderer;
            }
            if (object instanceof NotesHolder) {
                return TimeList.this.notesRenderer;
            }
            if (object instanceof IconsHolder) {
                return TimeList.this.iconsRenderer;
            }
            return super.getCellRenderer(row, column);
        }

        public boolean isCellEditable(int rowIndex, int vColIndex) {
            return false;
        }

        protected void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                EventListener[] el = super.getListeners(class$java$awt$event$KeyListener == null ? (class$java$awt$event$KeyListener = TimeList.class$("java.awt.event.KeyListener")) : class$java$awt$event$KeyListener);
                if (e.getID() != 402) {
                    return;
                }
                for (int i = 0; i < el.length; ++i) {
                    KeyListener kl = (KeyListener)el[i];
                    kl.keyReleased(e);
                }
                return;
            }
            super.processKeyEvent(e);
        }
    }

    private final class FlatNodeTableKeyListener
    implements KeyListener {
        private FlatNodeTableKeyListener() {
        }

        public void keyTyped(KeyEvent arg0) {
        }

        public void keyPressed(KeyEvent arg0) {
        }

        public void keyReleased(KeyEvent arg0) {
            if (arg0.getKeyCode() == 27) {
                TimeList.this.disposeDialog();
            }
            if (arg0.getKeyCode() == 10) {
                TimeList.this.selectSelectedRows();
                TimeList.this.disposeDialog();
            }
        }
    }

    private final class FlatNodeTableMouseAdapter
    extends MouseAdapter {
        private FlatNodeTableMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Point p = e.getPoint();
                int row = TimeList.this.timeTable.rowAtPoint(p);
                TimeList.this.gotoNodesAndClose(row, new int[]{row});
            }
        }
    }

    private final class FilterTextDocumentListener
    implements DocumentListener {
        private Timer mTypeDelayTimer = null;

        private FilterTextDocumentListener() {
        }

        private synchronized void change(DocumentEvent event) {
            if (this.mTypeDelayTimer != null) {
                this.mTypeDelayTimer.cancel();
                this.mTypeDelayTimer = null;
            }
            this.mTypeDelayTimer = new Timer();
            this.mTypeDelayTimer.schedule((TimerTask)new DelayedTextEntry(event), 500L);
        }

        public void insertUpdate(DocumentEvent event) {
            this.change(event);
        }

        public void removeUpdate(DocumentEvent event) {
            this.change(event);
        }

        public void changedUpdate(DocumentEvent event) {
            this.change(event);
        }

        protected class DelayedTextEntry
        extends TimerTask {
            private final DocumentEvent event;

            DelayedTextEntry(DocumentEvent event) {
                this.event = event;
            }

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            Document document = DelayedTextEntry.this.event.getDocument();
                            String text = TimeList.getRegularExpression(TimeList.this.getText(document));
                            TimeList.this.mFlatNodeTableFilterModel.setFilter(text);
                        }
                        catch (BadLocationException e) {
                            Resources.getInstance().logException(e);
                            TimeList.this.mFlatNodeTableFilterModel.resetFilter();
                        }
                    }
                });
            }
        }
    }

    private class ReplaceSelectedInfo
    implements IReplaceInputInformation {
        private ReplaceSelectedInfo() {
        }

        public int getLength() {
            return TimeList.this.timeTable.getSelectedRowCount();
        }

        public NodeHolder getNodeHolderAt(int i) {
            return (NodeHolder)TimeList.this.sorter.getValueAt(TimeList.this.timeTable.getSelectedRows()[i], 1);
        }

        public void changeString(NodeHolder nodeHolder, String newText) {
            TimeList.this.getMindMapController().setNodeText(nodeHolder.node, newText);
        }
    }

    private class ReplaceAllInfo
    implements IReplaceInputInformation {
        private ReplaceAllInfo() {
        }

        public int getLength() {
            return TimeList.this.mFlatNodeTableFilterModel.getRowCount();
        }

        public NodeHolder getNodeHolderAt(int i) {
            return (NodeHolder)TimeList.this.mFlatNodeTableFilterModel.getValueAt(i, 1);
        }

        public void changeString(NodeHolder nodeHolder, String newText) {
            TimeList.this.getMindMapController().setNodeText(nodeHolder.node, newText);
        }
    }

    public static interface IReplaceInputInformation {
        public int getLength();

        public NodeHolder getNodeHolderAt(int var1);

        public void changeString(NodeHolder var1, String var2);
    }
}

