/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.AttributeComboBox;
import com.lightdev.app.shtm.AttributeComponent;
import com.lightdev.app.shtm.BorderPanel;
import com.lightdev.app.shtm.ColorPanel;
import com.lightdev.app.shtm.DialogShell;
import com.lightdev.app.shtm.MarginPanel;
import com.lightdev.app.shtm.SizeSelectorPanel;
import com.lightdev.app.shtm.StylePanel;
import com.lightdev.app.shtm.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;

class TableDialog
extends DialogShell {
    Vector tableComponents = new Vector();
    Vector cellComponents = new Vector();
    JComboBox cellRange;

    public TableDialog(Frame parent, String title) {
        super(parent, title);
        Container contentPane = super.getContentPane();
        contentPane.add((Component)this.buildTablePanel(), "North");
        contentPane.add((Component)this.buildCellPanel(), "Center");
        this.pack();
    }

    public void setTableAttributes(AttributeSet a) {
        this.setComponentAttributes(this.tableComponents, a);
    }

    public void setCellAttributes(AttributeSet a) {
        this.setComponentAttributes(this.cellComponents, a);
    }

    public void setComponentAttributes(Vector v, AttributeSet a) {
        Enumeration components = v.elements();
        while (components.hasMoreElements()) {
            AttributeComponent ac = (AttributeComponent)components.nextElement();
            ac.setValue(a);
        }
    }

    public AttributeSet getTableAttributes() {
        return this.getComponentAttributes(this.tableComponents);
    }

    public AttributeSet getCellAttributes() {
        return this.getComponentAttributes(this.cellComponents);
    }

    private AttributeSet getComponentAttributes(Vector v) {
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        Enumeration components = v.elements();
        while (components.hasMoreElements()) {
            AttributeComponent ac = (AttributeComponent)components.nextElement();
            attributes.addAttributes(ac.getValue());
        }
        return attributes;
    }

    private JPanel buildCellPanel() {
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel cellPanel = new JPanel(new BorderLayout());
        cellPanel.setBorder(new TitledBorder(new EtchedBorder(1), Util.getResourceString("cellPanelTitle")));
        JTabbedPane tp = new JTabbedPane();
        tp.setTabLayoutPolicy(1);
        StylePanel sp = new StylePanel(2);
        this.cellComponents.add(sp);
        tp.add(Util.getResourceString("cellGenTabLabel"), sp);
        MarginPanel mp = new MarginPanel();
        this.cellComponents.add(mp);
        tp.add(Util.getResourceString("cellMarginTabLabel"), mp);
        BorderPanel bPanel = new BorderPanel();
        this.cellComponents.add(bPanel);
        tp.add(Util.getResourceString("cellBorderTabLabel"), bPanel);
        JPanel crPanel = new JPanel();
        String[] cellRangeSelection = new String[]{Util.getResourceString("thisCellRangeLabel"), Util.getResourceString("thisColRangeLabel"), Util.getResourceString("thisRowRangeLabel"), Util.getResourceString("allCellsRangeLabel")};
        crPanel.add(new JLabel(Util.getResourceString("applyCellAttrLabel")));
        this.cellRange = new JComboBox<String>(cellRangeSelection);
        crPanel.add(this.cellRange);
        cellPanel.add((Component)tp, "Center");
        cellPanel.add((Component)crPanel, "South");
        return cellPanel;
    }

    public int getCellRange() {
        return this.cellRange.getSelectedIndex();
    }

    private JPanel buildTablePanel() {
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel tablePanel = new JPanel(g);
        tablePanel.setBorder(new TitledBorder(new EtchedBorder(1), Util.getResourceString("tablePanelTitle")));
        JLabel lb = new JLabel(Util.getResourceString("tableWidthLabel"));
        Util.addGridBagComponent(tablePanel, lb, g, c, 0, 0, 13);
        SizeSelectorPanel ssp = new SizeSelectorPanel(CSS.Attribute.WIDTH, HTML.Attribute.WIDTH, false, 2);
        Util.addGridBagComponent(tablePanel, ssp, g, c, 1, 0, 17);
        this.tableComponents.addElement(ssp);
        lb = new JLabel(Util.getResourceString("tableBgColLabel"));
        Util.addGridBagComponent(tablePanel, lb, g, c, 0, 1, 13);
        ColorPanel cp = new ColorPanel(null, Color.white, CSS.Attribute.BACKGROUND_COLOR);
        Util.addGridBagComponent(tablePanel, cp, g, c, 1, 1, 17);
        this.tableComponents.addElement(cp);
        lb = new JLabel(Util.getResourceString("alignLabel"));
        Util.addGridBagComponent(tablePanel, lb, g, c, 0, 2, 13);
        String[] items = new String[]{Util.getResourceString("alignLeft"), Util.getResourceString("alignCenter"), Util.getResourceString("alignRight")};
        String[] names = new String[]{"left", "center", "right"};
        AttributeComboBox tAlgn = new AttributeComboBox(items, names, CSS.Attribute.TEXT_ALIGN, HTML.Attribute.ALIGN);
        Util.addGridBagComponent(tablePanel, tAlgn, g, c, 1, 2, 17);
        this.tableComponents.addElement(tAlgn);
        return tablePanel;
    }
}

