/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXPanel;
import org.limewire.core.api.malware.VirusEngine;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.action.UrlAction;
import org.limewire.ui.swing.components.HTMLLabel;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.LanguageComboBox;
import org.limewire.ui.swing.components.LimeJDialog;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.components.NonNullJComboBox;
import org.limewire.ui.swing.painter.GenericBarPainter;
import org.limewire.ui.swing.util.FontUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.LanguageUtils;
import org.limewire.ui.swing.util.PainterUtils;
import org.limewire.ui.swing.util.ResizeUtils;
import org.limewire.ui.swing.wizard.IntentGreenButtonBackgroundPainter;
import org.limewire.ui.swing.wizard.IntentLightButtonBackgroundPainter;
import org.limewire.util.SystemUtils;

public class IntentDialog
extends LimeJDialog {
    private final VirusEngine virusEngine;
    private final Color backgroundColor = Color.WHITE;
    private final Font headingFont = new Font("Dialog", 1, 14);
    private final Font smallFont = new Font("Dialog", 0, 12);
    private final Font normalFont = new Font("Dialog", 0, 14);
    private final Font buttonFont = new Font("Dialog", 1, 14);
    private final Color headerGradientTop = new Color(0xF4F4F4);
    private final Color headerGradientBottom = new Color(0xD7D7D7);
    private final Paint headerTopBorder1 = new Color(0xFFFFFF);
    private final Paint headerTopBorder2 = PainterUtils.TRASPARENT;
    private final Paint headerBottomBorder1 = new Color(0x696969);
    private final Paint headerBottomBorder2 = new Color(0xFFFFFF);
    private final JLabel headingLabel;
    private final HTMLLabel bodyLabel;
    private final JLabel agreeLabel;
    private final JButton licenseButton;
    private final JButton avgLicenseButton;
    private final JButton privacyButton;
    private final JLabel languageLabel;
    private final JXButton agreeButton;
    private final JXButton exitButton;
    private final JLabel copyrightLabel;
    private final JLabel policiesLabel;
    private final String copyrightURL = "http://client-data.limewire.com/client_startup/docs/?page=copyright&is_client=true";
    private final String licenseURL = "http://client-data.limewire.com/client_startup/docs/?page=agreement&is_client=true";
    private final String avgLicenseURL = "http://client-data.limewire.com/client_startup/docs/?page=avg_agreement&is_client=true";
    private final String privacyURL = "http://client-data.limewire.com/client_startup/docs/?page=privacy&is_client=true";
    private boolean agreed = false;

    public IntentDialog(String version, VirusEngine virusEngine) {
        this.virusEngine = virusEngine;
        ResizeUtils.forceSize(this, new Dimension(514, 402));
        final String title = "LimeWire " + version;
        this.setTitle(title);
        this.setModal(true);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBackground(this.backgroundColor);
        this.add(contentPane);
        JPanel panel = new JPanel(new MigLayout("nogrid, insets 0, gap 0"));
        panel.setOpaque(false);
        this.headingLabel = new JLabel();
        this.headingLabel.setFont(this.headingFont);
        this.copyrightLabel = new JLabel();
        this.copyrightLabel.setFont(this.headingFont);
        this.policiesLabel = new JLabel();
        this.policiesLabel.setFont(this.headingFont);
        final JComboBox languageDropDown = this.createLanguageDropDown(this.normalFont);
        final UrlAction.GetParamAppender languageAppender = new UrlAction.GetParamAppender(){

            @Override
            public String appendParams(String original) {
                return original + "&lang=" + languageDropDown.getSelectedItem().toString();
            }
        };
        this.agreeLabel = new MultiLineLabel("", 500);
        this.agreeLabel.setFont(this.smallFont);
        this.licenseButton = new HyperlinkButton(new UrlAction("http://client-data.limewire.com/client_startup/docs/?page=agreement&is_client=true", title, languageAppender));
        this.licenseButton.setFocusPainted(false);
        this.licenseButton.setFont(this.smallFont);
        FontUtils.underline(this.licenseButton);
        this.licenseButton.setForeground(new Color(2183846));
        this.privacyButton = new HyperlinkButton(new UrlAction("http://client-data.limewire.com/client_startup/docs/?page=privacy&is_client=true", title, languageAppender));
        this.privacyButton.setFocusPainted(false);
        this.privacyButton.setFont(this.smallFont);
        FontUtils.underline(this.privacyButton);
        this.privacyButton.setForeground(new Color(2183846));
        this.avgLicenseButton = new HyperlinkButton(new UrlAction("http://client-data.limewire.com/client_startup/docs/?page=avg_agreement&is_client=true", UrlAction.LaunchType.POPUP, languageAppender));
        this.avgLicenseButton.setFocusPainted(false);
        this.avgLicenseButton.setFont(this.smallFont);
        FontUtils.underline(this.avgLicenseButton);
        this.avgLicenseButton.setForeground(new Color(2183846));
        this.bodyLabel = new HTMLLabel("");
        this.bodyLabel.setHtmlFont(this.smallFont);
        this.bodyLabel.setHtmlLinkForeground(new Color(2183846));
        this.bodyLabel.setEditable(false);
        this.bodyLabel.setOpaque(false);
        this.bodyLabel.addHyperlinkListener(new HyperlinkListener(){
            private final Action urlAction;
            {
                this.urlAction = new UrlAction("http://client-data.limewire.com/client_startup/docs/?page=copyright&is_client=true", title, languageAppender);
            }

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    this.urlAction.actionPerformed(null);
                }
            }
        });
        this.languageLabel = new JLabel();
        this.languageLabel.setFont(this.smallFont);
        this.agreeButton = new JXButton();
        this.decorateButton(this.agreeButton);
        this.agreeButton.setBackgroundPainter(new IntentGreenButtonBackgroundPainter());
        this.exitButton = new JXButton();
        this.decorateButton(this.exitButton);
        this.exitButton.setBackgroundPainter(new IntentLightButtonBackgroundPainter());
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel outerPanel = new JPanel(new BorderLayout());
        JPanel innerPanel = new JPanel(new MigLayout("gap 6, insets 0, fill"));
        JPanel langInnerPanel = new JPanel(new MigLayout("flowy, gap 4, insets 0, fill"));
        bottomPanel.setOpaque(false);
        outerPanel.setOpaque(false);
        innerPanel.setOpaque(false);
        langInnerPanel.setOpaque(false);
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(0, 14, 14, 14));
        JXPanel headerBar = new JXPanel(new MigLayout("insets 14, gap 0, fill"));
        headerBar.setBackgroundPainter(new GenericBarPainter(new GradientPaint(0.0f, 0.0f, this.headerGradientTop, 0.0f, 1.0f, this.headerGradientBottom, false), this.headerTopBorder1, this.headerTopBorder2, this.headerBottomBorder1, this.headerBottomBorder2));
        int indent = 14;
        headerBar.add((Component)this.headingLabel, "grow, wrap");
        panel.add((Component)this.copyrightLabel, "gapleft " + indent + ", gaptop 10, wrap");
        panel.add((Component)this.bodyLabel, "gapleft " + (indent + indent) + ", gaptop 10, wrap");
        panel.add((Component)this.policiesLabel, "gapleft " + indent + ", gaptop 20, wrap");
        panel.add((Component)this.licenseButton, "gaptop 10, gapleft " + (indent + indent) + ", wrap");
        panel.add((Component)this.privacyButton, "gapleft " + (indent + indent) + ", wrap");
        if (virusEngine.isSupported()) {
            panel.add((Component)this.avgLicenseButton, "gapleft " + (indent + indent) + ", wrap");
        }
        panel.add((Component)this.agreeLabel, "gapleft " + indent + ", gaptop 30, wrap");
        langInnerPanel.add(this.languageLabel);
        langInnerPanel.add(languageDropDown);
        bottomPanel.add((Component)langInnerPanel, "West");
        innerPanel.add(this.agreeButton);
        innerPanel.add(this.exitButton);
        outerPanel.add((Component)innerPanel, "South");
        bottomPanel.add((Component)outerPanel, "East");
        this.setTextContents();
        contentPane.add((Component)headerBar, "North");
        contentPane.add((Component)panel, "Center");
        contentPane.add((Component)bottomPanel, "South");
        this.pack();
    }

    private void decorateButton(JXButton button) {
        button.setFont(this.buttonFont);
        button.setOpaque(false);
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setBorder(BorderFactory.createEmptyBorder(0, 10, 3, 10));
        button.setMaximumSize(new Dimension(Integer.MAX_VALUE, 32));
        button.setMinimumSize(new Dimension(105, 32));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setAlwaysOnTop(true);
        SystemUtils.setWindowTopMost(this);
    }

    private void finish(boolean agreed) {
        this.agreed = agreed;
        this.setVisible(false);
        this.dispose();
    }

    public boolean confirmLegal() {
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        return this.agreed;
    }

    private JComboBox createLanguageDropDown(Font normalFont) {
        final NonNullJComboBox languageDropDown = new NonNullJComboBox();
        Locale[] locales = LanguageUtils.getLocales(normalFont);
        languageDropDown.setRenderer(new LanguageComboBox.LocaleRenderer());
        languageDropDown.setFont(this.smallFont);
        languageDropDown.setModel(new DefaultComboBoxModel<Locale>(locales));
        ((JComboBox)languageDropDown).setSelectedItem(LanguageUtils.guessBestAvailableLocale(locales));
        LanguageUtils.setLocale((Locale)languageDropDown.getSelectedItem());
        languageDropDown.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Locale locale = (Locale)languageDropDown.getSelectedItem();
                    LanguageUtils.setLocale(locale);
                    IntentDialog.this.setTextContents();
                }
            }
        });
        return languageDropDown;
    }

    private void setTextContents() {
        String heading = I18n.tr("Some Legal Stuff");
        String bodyText1 = I18n.tr("<html><body>LimeWire Basic and LimeWire PRO are peer-to-peer programs for sharing authorized files only. Copyright laws may forbid obtaining or distributing certain copyrighted content. Learn more information about <a href=\"{0}\">Copyright</a></body></html>.", 0);
        String copyInfringementText = I18n.tr("Copyright Infringement");
        String privacyText = I18n.tr("LimeWire Privacy Policy");
        String licenseText = I18n.tr("LimeWire License Agreement");
        String avgLicenseText = I18n.tr("AVG Anti-Virus License Agreement");
        String agreementText = this.virusEngine.isSupported() ? I18n.tr("By clicking \"I Agree\", you agree that you have read, understand and assent to the terms of the LimeWire and AVG Anti-Virus License Agreements and LimeWire Privacy Policy. You also agree that you will not use LimeWire for copyright infringement.") : I18n.tr("By clicking \"I Agree\", you agree that you have read, understand and assent to the terms of the LimeWire License Agreement and LimeWire Privacy Policy. You also agree that you will not use LimeWire for copyright infringement.");
        String languageText = I18n.tr("Choose your language");
        String policiesText = I18n.tr("Policies Governing Your Use:");
        AbstractAction exitAction = new AbstractAction(I18n.tr("Exit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntentDialog.this.finish(false);
            }
        };
        AbstractAction agreeAction = new AbstractAction(I18n.tr("I Agree")){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntentDialog.this.finish(true);
            }
        };
        this.headingLabel.setText(heading);
        this.bodyLabel.setText(bodyText1);
        this.copyrightLabel.setText(copyInfringementText);
        this.policiesLabel.setText(policiesText);
        this.licenseButton.setText(licenseText);
        this.avgLicenseButton.setText(avgLicenseText);
        this.privacyButton.setText(privacyText);
        this.agreeLabel.setText(agreementText);
        this.languageLabel.setText(languageText);
        this.exitButton.setAction(exitAction);
        this.agreeButton.setAction(agreeAction);
    }
}

